# coding=utf-8

__author__ = '******'
# 获取主机上数据库的一些基本信息，如版本号.

import traceback
from common import util
from common import constants

CLI = None
LANGUAGE = None
CHECK_FAIL = 0
CHECK_PASS = 1
ASMUSER = None
ORACLE_SID = None

sql_info_id = [
    "sql_display_database_basic_v$version",
    "sql_display_database_basic_v$asm_diskgroup",
    "sql_display_database_basic_x$ksppi_x$ksppcv",
    "sql_display_database_basic_v$asm_disk",
    "sql_display_database_capacity_v$asm_disk"
]

sql_info_dese = [
    "select * from v$version;",
    "select group_number gno,name,state,type,total_mb,free_mb,sector_size from v$asm_diskgroup;",
    r"select a.ksppinm name,b.ksppstvl value,a.ksppdesc describe from x$ksppi a,x$ksppcv b"
    r" where a.inst_id = userenv('instance') and b.inst_id = userenv('instance')"
    r" and a.indx = b.indx and a.ksppinm like '\_asm_hbeatio%' escape '\';",
    "select name,path,group_number, disk_number,mount_status,header_status,mode_status,state,sector_size"
    " from v$asm_disk;",
    "select NAME,PATH,STATE,TOTAL_MB,FREE_MB,HOT_USED_MB,COLD_USED_MB from v$asm_disk;",
]


def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = context.get("lang")
    cmd_display = context.get("ret_map")

    return cmd_execute(cmd_display, context)


def cmd_execute(cmd_display, context):
    fun_err_msg = ''
    fun_err_msg_temp = ''
    try:
        util.updateItemProgress(context, constants.PROG5)
        curstep = constants.PROG5
        util.updateItemProgress(context, curstep)

        # MySQL信息采集
        util.updateItemProgress(context, constants.PROG20)
        fun_err_msg += cmd_mysql_execute(cmd_display, fun_err_msg_temp)

        # db2信息采集
        util.updateItemProgress(context, constants.PROG35)
        fun_err_msg += cmd_db2_execute(cmd_display, fun_err_msg_temp)
        # oracle 数据库采集
        fun_err_msg += ssh_oracle_execute(CLI, cmd_display, fun_err_msg_temp,
                                          context)

        util.updateItemProgress(context, constants.PROG90)

        cmd_display.put("err_msg", fun_err_msg)
        return CHECK_PASS, cmd_display, fun_err_msg
    except Exception:
        util.updateItemProgress(context, constants.PROG90)
        msg = traceback.format_exc()
        cmd_display.put("err_msg", fun_err_msg)
        context.get("Logger").error("execute database basic info info ==> " + msg)
        return CHECK_PASS, cmd_display, fun_err_msg


# DB2数据库版本查询方法
def cmd_db2_execute(cmd_display, fun_err_msg_temp):
    cmd_db2sysc = "ps -ef|grep db2sysc | cat"
    cmd_db2sysc_user = "ps -ef|grep -w db2sysc |grep -v 'grep'| " \
                       "awk '{print $1}'|head -1"
    cmd_su = "su - "

    sql_display_temp, fun_err_msg_temp = \
        build_display_data(cmd_display,
                           "cmd_display_database_basic_db2sysc",
                           cmd_db2sysc,
                           fun_err_msg_temp)

    asm_name_ret = CLI.execCmdHasLogTimout(cmd_db2sysc_user, 60)
    asm_name_lines = asm_name_ret.splitlines()

    # root账户检测
    root_flag = is_root()
    if not root_flag:
        return fun_err_msg_temp

    # asmname检测
    if asm_name_lines is None or asm_name_lines == "" or len(
            asm_name_lines) <= 1:
        return fun_err_msg_temp

    asm_name = asm_name_lines[1].strip()

    sql_display_temp, fun_err_msg_temp = \
        build_display_data(cmd_display,
                           "cmd_display_database_basic_su",
                           cmd_su + asm_name.strip(),
                           fun_err_msg_temp)

    # 获取版本信息

    sql_display_temp, fun_err_msg_temp = \
        build_display_data(cmd_display,
                           "cmd_display_database_basic_db2level",
                           "db2level",
                           fun_err_msg_temp)

    # 退出当前模式，返回root模式
    # root检测，防止切换失败，导致错误中断链接。
    root_flag = is_root()

    if not root_flag:
        CLI.execDbCmdNoLogTimout("exit", 60)

    return fun_err_msg_temp


# MySQL数据库版本查询方法
def cmd_mysql_execute(cmd_display, fun_err_msg_temp):
    sql_display_temp, fun_err_msg_temp = \
        build_display_data(cmd_display,
                           "cmd_display_database_basic_mysql",
                           "mysql -V", fun_err_msg_temp)
    return fun_err_msg_temp


def is_root():
    # root用户检测，如果不为root用户，后续的root权限命令则不再执行
    cmd_display_temp_id = CLI.execCmdHasLogTimout("whoami", 60)
    splitlines_root = cmd_display_temp_id.splitlines()

    if splitlines_root is None or splitlines_root == " " or len(
            splitlines_root) <= 1:
        return False

    userName = splitlines_root[1].strip().lower()
    if "root" != userName and (
            'not found' in userName or 'not-found' in userName):
        cmd_display_temp_id = CLI.execCmdHasLogTimout("id | awk "
                                                      "'{print $1}'",
                                                      60)
        if '(root)' in cmd_display_temp_id.strip().lower():
            return True
    else:
        if "root" == userName:
            return True
    return False


# Oracle数据库版本查询方法
def ssh_oracle_execute(CLI, sql_display, fun_err_msg_temp, context):
    global logger
    root_flag = is_root()
    if not root_flag:
        return fun_err_msg_temp

    sql_display_temp, fun_err_msg_temp = \
        build_display_data(sql_display,
                           "sql_display_database_basic_asm",
                           "ps -ef|grep pmon|cat",
                           fun_err_msg_temp)
    # 解析获取ASM值
    splitlines = sql_display_temp.splitlines()
    ORACLE_SID = ""
    ORACLE_HOME = ""
    ASMUSER = ""
    for line in splitlines:
        if "asm_pmon_" in line:
            splits = line.strip().split()
            str = splits[len(splits) - 1]
            ORACLE_SID = str[str.find("asm_pmon_") + constants.NINE:]

    util.updateItemProgress(context, constants.PROG40)

    sql_display_temp, fun_err_msg_temp = \
        build_display_data(sql_display,
                           "sql_display_database_basic_ocssd_bin",
                           "ps -ef|grep ocssd.bin|cat",
                           fun_err_msg_temp)
    splitlines = sql_display_temp.splitlines()

    for line in splitlines:
        if "/bin/ocssd.bin" in line:
            splits = line.strip().split()
            ASMUSER = splits[0].strip()
            str = splits[len(splits) - 1]
            ORACLE_HOME = str[0:str.find("/bin/ocssd.bin")]

    util.updateItemProgress(context, constants.PROG45)

    sql_display_temp, fun_err_msg_temp = \
        build_display_data(sql_display,
                           "sql_display_database_basic"
                           "_olsnodes", ORACLE_HOME + "/bin/olsnodes -s",
                           fun_err_msg_temp)

    util.updateItemProgress(context, constants.PROG50)
    logger.info(
        "ASMUSER: " + ASMUSER + " ORACLE_HOME: " +
        ORACLE_HOME + " ORACLE_SID :" + ORACLE_SID)
    if ASMUSER and ORACLE_HOME and ORACLE_SID:
        # 切换至ASMUSER权限，前提为root权限
        sql_display_temp, fun_err_msg_temp = \
            build_display_data(sql_display,
                               "sql_display_database_basic_su_",
                               "su - " + ASMUSER,
                               fun_err_msg_temp)

        sql_display_temp, fun_err_msg_temp = \
            build_display_data(sql_display,
                               "sql_display_database_basic_nodeapps",
                               "srvctl config nodeapps",
                               fun_err_msg_temp)
        util.updateItemProgress(context, constants.PROG55)
        # SQL命令查询
        # 环境变量设置
        CLI.execCmdHasLogTimout("export ORACLE_SID=" + ORACLE_SID, 60)
        CLI.execCmdHasLogTimout("export ORACLE_HOME=" + ORACLE_HOME, 60)
        sql_display_temp, fun_err_msg_temp = \
            build_display_data(sql_display,
                               "sql_display_database_basic_sqlplus",
                               "sqlplus / as sysasm",
                               fun_err_msg_temp)
        # 临时修改用户sqlplus模式下的消息头
        sql_display_temp, fun_err_msg_temp = \
            build_display_data(sql_display,
                               "sql_display_database_basic_sqlprompt",
                               "set sqlprompt SQL>",
                               fun_err_msg_temp)

        # 设置回显格式
        CLI.execCmdHasLogTimout("set linesize 1000", 60)
        CLI.execCmdHasLogTimout("col path for a40", 60)
        CLI.execCmdHasLogTimout("col name for a30", 60)
        CLI.execCmdHasLogTimout("col value for a30", 60)
        CLI.execCmdHasLogTimout("col describe for a100", 60)

        prgStep = constants.PROG15 / len(sql_info_id)
        curstep = constants.PROG55

        for rg in range(len(sql_info_id)):
            cmd_display_temp = CLI.execCmdHasLogTimout(sql_info_dese[rg], 60)
            curstep += prgStep
            util.updateItemProgress(context, curstep)
            sql_display.put(sql_info_id[rg],
                            build_sql_display(cmd_display_temp))
            fun_err_msg_temp += deal_fun_err_msg(sql_display_temp,
                                                 sql_info_dese[rg],
                                                 fun_err_msg_temp)

        exitCmd = 'exit'
        sql_whoami = CLI.execCmdHasLogTimout("whoami", 60)
        # dbcon 框架已经已经进入sql模式，执行数据库外部命令需要退出sql到
        # root权限。
        if "SQL>" in sql_whoami:
            CLI.execCmdHasLogTimout(exitCmd, 60)
        if not is_root():
            CLI.execCmdHasLogTimout(exitCmd, 60)
        util.updateItemProgress(context, constants.PROG70)

    return fun_err_msg_temp


# 构造回显报告中的显示信息
def build_display_data(sql_display, cmd_id, cmd, fun_err_msg_temp):
    sql_display_temp = CLI.execCmdHasLogTimout(cmd, 60)
    sql_display.put(cmd_id, sql_display_temp)
    fun_err_msg_temp += deal_fun_err_msg(sql_display_temp, cmd,
                                         fun_err_msg_temp)
    return sql_display_temp, fun_err_msg_temp


# 在回文头前拼接SQL>确保报告的命令头显示正确
def build_sql_display(sql_display_temp):
    if sql_display_temp is None or '' == sql_display_temp or \
            sql_display_temp.find(
                'TOOLKIT_SEND_CMD_TIME_OUT') > 0 or \
            sql_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
        return sql_display_temp
    if not sql_display_temp.startswith("SQL>"):
        return "SQL>" + sql_display_temp


def deal_fun_err_msg(cmd_display_temp, cmd, fun_err_msg):
    if cmd_display_temp is None or '' == cmd_display_temp or \
            cmd_display_temp.find(
                'TOOLKIT_SEND_CMD_TIME_OUT') > 0 or \
            cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
        if "en" == LANGUAGE:
            fun_err_msg = cmd + ":\texecute failed\r\n"
        else:
            fun_err_msg = cmd + u":\t执行失败\r\n"
    else:
        if "en" == LANGUAGE:
            fun_err_msg = cmd + ":\texecute success\r\n"
        else:
            fun_err_msg = cmd + u":\t执行成功\r\n"

    return fun_err_msg
