# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

DM_NAME_STARTER = "dm-"


def get_dm_name_list(lines):
    """
    获取linux主机DM多路径的dm盘名字
    :param lines: 上下文
    :return: dm盘名字
    """
    result = []
    for line in lines:
        line = line.strip()
        if not line or DM_NAME_STARTER not in line:
            continue
        dm_name = filter(is_dm_name, line.split())
        if not dm_name:
            continue
        result.append(dm_name[0])
    return result


def is_dm_name(content):
    """
    是否dm盘名字
    :param content: 数据
    :return: dm盘名字
    """
    return content.startswith(DM_NAME_STARTER)
