#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.
import re
from common.contentParse import get_result_from_data


def get_host_ip(context):
    """
    获取ip
    :param context: 上下文
    :return: ip
    """
    offline_file = context.get("reportPath", "")
    if not offline_file:
        return context.get("ip")
    context["command"] = "self_define_cmd_basicinfo"
    ip_info = get_result_from_data(context)
    if len(ip_info) == 2:
        return ip_info[-1].strip()
    return ""


def safe_get_split(splits, index):
    """
    安全获取数据
    :param splits: 分割的数据
    :param index: 下标
    :return: 数据
    """
    if index < len(splits):
        return splits[index]
    return ""


def get_horizontal_cli_ret_by_head(cli_ret):
    """
    按逐行字典的方式获取水平表格形式的cli回显集合（非标准电子标签：根据表头分隔，而非电子标签的---分隔符）
    @param cli_ret: cli回显
    @return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合,处理不正常时，返回空集合
    """
    try:
        split_line = ""
        i = 0
        cli_ret_list = cli_ret.encode("utf8").splitlines()
        for line in cli_ret_list:
            reg_headline = re.compile("^\s*-+(\s+-+)*\s*$")
            match_headline = reg_headline.search(line)
            if match_headline:
                split_line = match_headline.group()
                break
            i += 1
        if split_line == "" or i == 0 or i >= len(cli_ret_list) - 1:
            return []
        title = cli_ret_list[i - 1]

        field_words = cli_ret_list[(i + 1):]
        reg_split = re.compile('\\s{2,}')
        tuple_idxs = []
        start_pos = 0
        end_pos = 0
        while (start_pos <= len(title)):
            match = reg_split.search(title, start_pos)
            if match:
                end_pos = match.end()
                tuple_idxs.append((start_pos, end_pos))
                start_pos = end_pos
            else:
                break
        if tuple_idxs and start_pos <= len(title) - 1:
            tuple_idxs.append((start_pos, len(title) - 1))
        keys = []
        for item in tuple_idxs:
            key = title[item[0]:item[1]].strip()
            if keys.count(key):
                key += "_" + str(str(keys).count(key + "_") + 1)
            keys.append(key.decode("utf8"))
        required_line_len = tuple_idxs[-1][0]
        dict_list = []
        for line in field_words:
            if re.search("^-+(\s+-+)*\s*$", line) or len(line.strip()) == 0 or len(line) <= required_line_len:
                continue
            vals = []
            for item in tuple_idxs:
                vals.append(line[item[0]:item[1]].strip().decode("utf8"))
            dict_list.append(dict(zip(keys, vals)))
        return dict_list
    except Exception:
        return []


def remove_blank_lines(lines):
    """
    去掉空白行
    :param lines: 行数据
    :return: 数据
    """
    return filter(lambda line: line.strip(), lines)
