# coding=utf-8
__author__ = '******'
# 获取linux主机的HBA卡信息
import sys
import os
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, os.path.pardir)
path = os.path.join(path, os.path.pardir)
sys.path.append(path)

from hosts.linux import linux_hba_card_info
from common import contentParse, util
from common.util import *
from hosts.sudo_utils import get_sudo_cmd_desc
from hosts.sudo_utils import FS

cmd_info_id = [
               "cmd_info_hba_card_port_name_ls",
               "cmd_info_hba_card_port_name_cat",
               "cmd_info_hba_card_model_ls",
               "cmd_info_hba_card_model_cat",
               "cmd_info_hba_card_driver_version_ls",
               "cmd_info_hba_card_fw_version_ls",
               "cmd_info_hba_card_Folder",
               "cmd_info_hba_card_config",
               'cmd_info_hba_card_status',
               'cmd_info_hba_card_lspci',
               ]
            
cmd_info_desc = [
                 "ls /sys/class/fc_host/host*/port*name",
                 "cat  /sys/class/fc_host/host*/port*name",
                 "ls /sys/class/scsi_host/host*/model*name",
                 "cat  /sys/class/scsi_host/host*/model*name",
                 "ls /sys/class/scsi_host/host*/*version |awk '/lpfc_drvr_version|driver_version/'",
                 "ls /sys/class/scsi_host/host*/*fw* |awk '/fwrev|optrom_fw_version/'",
                 "ls /sys/class/fc_remote_ports/",
                 "sh /opt/galax/eucalyptus/ecs_scripts/bsb/fc/queryHBAInf.sh",
                 "cat /sys/class/fc_host/host*/port_state",
                 "lspci -vvnn | grep -iA2 'Fibre Channel'",
                 ]

cmd_info_id_fw_version = "cmd_info_hba_card_fw_version_cat" 
cmd_info_id_hba_driver_version = "cmd_info_hba_card_driver_version_cat"
cmd_info_id_tmo = "cmd_info_hba_card_tmo" 


def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 获取HBA 端口 型号 驱动版本信息
    util.updateItemProgress(context, constants.PROG20)
    contentParse.getCommandRet(context, cmd_info_id,
                               get_sudo_cmd_desc(cmd_info_desc, FS, context))
    errMsgRet = context.get("ret_map").get("err_msg") 
    
    #获取HBA驱动版本信息
    util.updateItemProgress(context, constants.PROG40)
    getHbaDrvVersion(context)
    errMsgDrv = context.get("ret_map").get("err_msg") 

    #获取FW Version命令信息
    util.updateItemProgress(context, constants.PROG60)
    getFwVersion(context)
    errMsgFw = context.get("ret_map").get("err_msg")
    
    #获取HBA卡的超时时间
    util.updateItemProgress(context, constants.PROG80)
    getHbaCardTimeout(context)
    errMsgTMO = context.get("ret_map").get("err_msg") 
    
    errMsgFinal = errMsgRet + errMsgDrv + errMsgFw + errMsgTMO
   
    context.get("ret_map").put("err_msg", errMsgFinal)
    return context
  
def getHbaDrvVersion(context):
    #获取FW Version命令信息
    CLI = context.get("SSH")
    hbzFrvVersionCmd = ""
    hbaHbaDrvVersionCmd_list = CLI.execCmdNoLog(cmd_info_desc[4]).splitlines()
    for cmd in hbaHbaDrvVersionCmd_list[1:]:
        if cmd == "" or "No such file or directory" in cmd or "TOOLKIT_EXE_CMD_FAILED" in cmd or "ls:" in cmd:
            continue
        hbzFrvVersionCmd += "cat " + cmd + ";"  
    if hbzFrvVersionCmd == "":
        return  
    #获取固件信息 
    contentParse.getSingleCommandRet(context, cmd_info_id_hba_driver_version,
                                     hbzFrvVersionCmd)
      
def getFwVersion(context):
    #获取FW Version命令信息
    CLI = context.get("SSH")
    fwVersionCmd = ""
    hbaFwVersionCmd_list = CLI.execCmdNoLog(cmd_info_desc[5]).splitlines()
    for cmd in hbaFwVersionCmd_list[1:]:
        if cmd == "" or "No such file or directory" in cmd or "TOOLKIT_EXE_CMD_FAILED" in cmd or "ls:" in cmd:
            continue
        fwVersionCmd += "cat " + cmd + ";"  
    if fwVersionCmd == "":
        return  
    #获取固件信息 
    contentParse.getSingleCommandRet(context, cmd_info_id_fw_version,
                                     fwVersionCmd)
    


def getHbaCardTimeout(context):
    #获取HBA目录命令信息
    devType = context.get("dev_type")
    log.info(context, "this device system type is:" + devType)
    
    HbaCardInfoList = linux_hba_card_info.getHbaCardTMOCommon(context)
    contentParse.getStringRet(context,
                              str(HbaCardInfoList).replace("u\'", "\'"))
    return

