# --*-- coding:utf-8 --*--
import sys 
import os
import re
from cmd import Cmd
reload(sys) 
sys.setdefaultencoding('utf-8')
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..\\..")
sys.path.append(path)
from common.contentParse import *

global key_lst  #对应Excel中属性列表
global attribute_arr #从传入的命令中获取的属性列表 
global  value_lst
global context

#对应excel中的属性字段
key_lst = ["server_model","cpu_model","memory","os","multipath","cluster","lvm/vxvm","database"]

#获取Linux主机集群 Server信息
def execute(context):
    #获取回文
    #start
    path = getValueFMap(context,style,'path')
    command = getValueFMap(context,style,'command').strip()
    attribute_arr = []
    value_lst = []
    if ';'== command[-1]:
        command =command[0:-1]
    addValueToMap(context,style,'command',command)
    #属性名与对应命令组成的列表的字典
    attrcom_dic = get_attrcom_dic(context)
    #对应execel属性名
    json_attr_name = get_jsonarr_name(attrcom_dic)
    attr_valuelst_dic = get_attrvalue_dic(context,attrcom_dic)
    #获取attribute ,value_lst
    for key in key_lst:
        tempList = []
        for attr in attr_valuelst_dic.keys():
            if key.lower().strip() in attr.lower():
                attribute_arr.append(attr)
                tempList = attr_valuelst_dic[attr]
                value = get_value_bykey(tempList,key)
                value_lst.append(value)
    #获取json结果字符串                 
    result = get_jsonstr(json_attr_name,attribute_arr, value_lst)
    addValueToMap(context,style,'result',result)
    return context


#功能说明：返回属性名与对应的回文列表
def get_attrvalue_dic(context,attrcom_dic):
    all_comds_lst = get_purecommands_lst(attrcom_dic)
    path = getValueFMap(context,style,'path')
    all_comds_byfile = get_comdslst_byfile(all_comds_lst,path)
    return get_attrlst_dic(attrcom_dic,all_comds_byfile,path)

 
#功能说明：返回Server model
def get_servermodel(tempList):
    if 0==len(tempList):
        return 'NA'
    for i in range(0, len(tempList)):
        if tempList[i].startswith("Linux "):
            return tempList[i].split()[1]
        
    return "NA"
    

#功能说明：返回CPU model    
def get_cpumodel(tempList):
    #架构 厂商，位数。如：x86-64 AMD64
    arch = 'NA'
    vendor = 'NA'
    osbit = 'NA'
    
    if 0==len(tempList):
        return 'NA'
    result = ""
    for i,line in enumerate(tempList):
        if ('uname' in line.lower()) and ('-a' in line.lower()):
            if 'x86_64' in tempList[i+1].lower():
                osbit = '64'
                arch = re.split('\\s+',tempList[i+1])[-2].strip()
            else:
                osbit = '32'
                arch = re.split('\\s+',tempList[i+1])[-2].strip()
    for line in tempList:
        if ('vendor' in line.lower()) and ('id' in line.lower()):
            vendor = line.split(':')[-1].strip()
            break
    result = arch+' '+vendor+osbit
    return result 


#功能说明：返回Memory
def get_memory(tempList):
    if 0==len(tempList):
        return 'NA'
    
    result = ""
    tempList = tempList[2:-1]
    try:
        for i in range(len(tempList)):
            if "MemTotal" in tempList[i].strip():
                tempStr = tempList[i]
        total_mem = tempStr.replace(':', ' ').replace('MemTotal', ' ').strip()
        total = '' + str(round(float(total_mem.replace("kB", '')) / 1024 / 1024, 2)) + "GB"
        result = total
    except:
        result = 'NA'
    if '' ==result.strip():
        result ="NA"
    return result 

#功能说明：返回Multipath name
def get_multipath(tempList):
    multipath_name = 'NA'
    
    if 0 == len(tempList):
        return  multipath_name
    
    txtList = []
    index = 0
    for i,line in enumerate(tempList):
        if divide in line:
            txtList.append(tempList[index:i])
            index = i + 1
    
    failStr = fail_flag
    
    resultTxt = []
    
    for txtBlock in txtList:
        flag = True
        for line in txtBlock:
            if failStr.lower() in line.lower():
                flag = False
                break
        if flag:
            resultTxt = txtBlock
            
    if len(resultTxt) == 0:
         
        return multipath_name
    
    for line in resultTxt:
        if 'powermt' in line:
            multipath_name= 'PowerPath'
        if ('upadmin' in line) and ('show' in line):
            multipath_name= 'UltraPath'
        if 'dlnkmgr' in line:
            multipath_name= 'HDLM'
        if 'upadm' in line:
            multipath_name= 'UltraPath'
        if ('lslpp' in line) and ('grep' in line) and ('sddpcm' in line):
            multipath_name= 'IBM'
    return multipath_name
    
#功能说明：返回集群信息    
def get_cluster(tempList):
    result = ""
    if 0==len(tempList):
        return 'NA'
    result = '\\n'.join(tempList[1:-1])
    return result
    
#功能说明：返回lvm/vxvm
def get_lvm(tempList):
    result = ""
    if 0==len(tempList):
        return 'NA'
    for i,value in enumerate(tempList):
        if ('lvm' in value.lower()) and ('version:' in value.lower()):
            result = tempList[i]
            break
    result = result.split(':')[1].strip()
    if ""!= result.lower():
        return result
    result = '\\n'.join(tempList[1:-1])
    return result 

#功能说明：返回数据库信息
def get_database(tempList):
    result = ""
    if 0==len(tempList):
        return 'NA'
    else:
        result = '\\n'.join(tempList[1:-1])
    return result 

#功能说明：返回操作系统信息
def get_os(tempList):
    if 0==len(tempList):
        return 'NA'
    tempList = tempList[2:-1]
    result = ""
    try:
        result = tempList[0].strip()
    except:
        result = 'NA'
    return result

def get_value_bykey(tempList,key):
    if key == key_lst[0]:
        return get_servermodel(tempList)
    elif key == key_lst[1]:
        return get_cpumodel(tempList)
    elif key == key_lst[2]:
        return get_memory(tempList)
    elif key == key_lst[3]:
        return get_os(tempList)
    elif key == key_lst[4]:
        return get_multipath(tempList)
    elif key == key_lst[5]:
        return get_cluster(tempList)
    elif key == key_lst[6]:
        return get_lvm(tempList)
    elif key == key_lst[7]:
        return get_database(tempList)
    else:
        return "Key Error"
