# -*- coding: UTF-8 -*-
import re
import sys
import traceback
import os
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common.contentParse import singleCmdExecute, saveAluaStatusAndCliRet2ForeEval
from common import util
from common import constants
from common import contentParse
cliRets = []
LINE_BREAK = "\n"
NUM_INT_3 = 3
queryAluaStatusFailedDisks = []
ALUA_ENABLED = 'enabled'
ALUA_NOT_ENABLED = 'not enabled'
ALUA_UNKNOW = 'unknown'
CHECK_FAIL = 0
CHECK_PASS = 1
def execute(context):
    '''
    @param context: execute context 
    '''
    global LOGGER
    LOGGER = context.get("Logger")
    cmd_display = context.get("ret_map")
    errMsg = ''
    cliRets = ''
    try:
        CLI = context.get("SSH")
        LOGGER = context.get("Logger")
        global LANGUAGE
        LANGUAGE = context.get("lang")
        LOGGER.info("start to query alua infomation")
        util.updateItemProgress(context, constants.PROG15)
        cliRets = CLI.execCmdHasLog("multipath -ll|cat")
        errMsg = util.errorMsgHandler(errMsg, cliRets, "multipath -ll|cat", LANGUAGE)
        cmd_display.put("err_msg",errMsg)
        cmd_display.put("cmd_display" + "_multipath -ll|cat", cliRets)
        multiPathInfo = cliRets.lower()
        if util.isCmdExecError(cliRets) or multiPathInfo.find('not found') > 0:
            contentParse.saveAluaStatusAndCliRet2ForeEval(ALUA_UNKNOW, cliRets, context)
            util.updateItemProgress(context, constants.PROG95)
            LOGGER.info("query alua TOOLKIT_SEND_CMD_TIME_OUT")
            return CHECK_PASS, cmd_display, errMsg
        util.updateItemProgress(context, constants.PROG55)
        if "not loaded"in multiPathInfo:
            contentParse.saveAluaStatusAndCliRet2ForeEval(ALUA_NOT_ENABLED, cliRets, context)
            return CHECK_PASS, cmd_display, errMsg
        if "policy" not in multiPathInfo:
            contentParse.saveAluaStatusAndCliRet2ForeEval(ALUA_UNKNOW, cliRets, context)
            util.updateItemProgress(context, constants.PROG95)
            contentParse.saveAluaStatusAndCliRet2ForeEval(ALUA_UNKNOW, cliRets, context)
            LOGGER.info("query alua not found")
            return CHECK_PASS, cmd_display, errMsg
        if "huawei" not in multiPathInfo:
            util.updateItemProgress(context, constants.PROG95)
            contentParse.saveAluaStatusAndCliRet2ForeEval(ALUA_NOT_ENABLED, cliRets, context)
            LOGGER.info("query alua no huawei disk")
            return CHECK_PASS, cmd_display, errMsg
        diskCfgs = multiPathInfo.split("dm-")
        patternActive = re.compile(r'prio=\d+\s+status=active')
        patternEnabled = re.compile(r'prio=\d+\s+status=enabled')
        patternPrio = re.compile(r'\d+')
        for diskCfg in diskCfgs:
            if "huawei" not in diskCfg:
                continue
            LOGGER.info("diskCfg:" + diskCfg)
            result1 = patternActive.findall(diskCfg)
            result2 = patternEnabled.findall(diskCfg)
            LOGGER.info("result1" + str(result1))
            if len(result1) > 0 and len(result2) > 0:
                prio1 = patternPrio.findall(result1[0])
                prio2 = patternPrio.findall(result2[0])
                if int(prio1[0]) != int(prio2[0]):
                    contentParse.saveAluaStatusAndCliRet2ForeEval(ALUA_ENABLED, cliRets, context)
                    util.updateItemProgress(context, constants.PROG95)
                    LOGGER.info("query alua have huawei disk enabled")
                    return CHECK_PASS, cmd_display, errMsg
        contentParse.saveAluaStatusAndCliRet2ForeEval(ALUA_NOT_ENABLED, cliRets, context)
        util.updateItemProgress(context, constants.PROG95)
        LOGGER.info("query alua have huawei disk not enabled")
        return CHECK_PASS, cmd_display, errMsg
    except:
        msg = traceback.format_exc()
        LOGGER.error("execute alua configure info ==> " + msg)
        saveAluaStatusAndCliRet2ForeEval(ALUA_UNKNOW, LINE_BREAK.join(cliRets), context)
        return CHECK_PASS, cmd_display, errMsg

