# coding=utf-8
__author__ = '******'
# 数据迁移: 获取linux主机:集群基本信息 
import re
import sys
import os
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common import util
from common import constants
from hosts.sudo_utils import get_sudo_cmd
from hosts.sudo_utils import LINUX

CLI = None
LANGUAGE = None
CHECK_FAIL          =       0
CHECK_PASS          =       1
cmd_info_id = [
               
               #PaceMaker集群版本、配置、状态
               "cmd_info_migrate_pacemaker_cluster_status",
               "cmd_info_migrate_servermodel",#主机类型
               "cmd_info_migrate_cpu",#cpu
               "cmd_info_migrate_memory",#memory
               "cmd_info_migrate_os", 
               
               "cmd_info_migrate_release", 
            ]
            
cmd_info_desc = [
                 
                 #PaceMaker集群
                 "clustat", #集群状态
                 "uname -a",
                 "cat /proc/cpuinfo",
                 "cat /proc/meminfo",
                 "cat /etc/*-release",
                 
                 "cat /etc/issue",
                 ]


def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = context.get("lang")
    cmd_display = context.get("ret_map")
    return check_and_get_result(cmd_execute(cmd_display, CLI, LANGUAGE,context))


# 取中间一个有效值
def check_and_get_result((fun_flag, result, fun_err_msg)):
    """
    :rtype : object
    """
    return result


def cmd_execute(cmd_display, CLI, LANGUAGE,context):
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    prgStep = constants.PROG85 / len(cmd_info_id)
    curstep = constants.PROG5
    for rg in range(len(cmd_info_id)):
        cmd_display_temp = CLI.execCmdHasLogTimout(
            get_sudo_cmd(cmd_info_desc[rg], LINUX, context), 60)
        curstep += prgStep
        util.updateItemProgress(context, curstep)
        cmd_display.put("cmd_display"+(cmd_info_id[rg])[8:], cmd_display_temp)
        if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
            if "en"==LANGUAGE:
                fun_err_msg        +=cmd_info_desc[rg] + ":\texecute failed\r\n"
            else:
                fun_err_msg        +=cmd_info_desc[rg] + u":\t执行失败\r\n"
        else:
            if "en"==LANGUAGE:
                fun_err_msg        +=cmd_info_desc[rg] + ":\texecute success\r\n"
            else:
                fun_err_msg        +=cmd_info_desc[rg] + u":\t执行成功\r\n"
    cmd_display.put("err_msg", fun_err_msg)
    fun_flag = CHECK_PASS
    return fun_flag, cmd_display, fun_err_msg