#  coding=utf-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.
import sys
import os

path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common import util
from common import constants
from hosts.sudo_utils import get_sudo_cmd
from hosts.sudo_utils import LINUX

cmd_info_id = [
    "cmd_info_cluster_crmadmin",
    "cmd_info_cluster_RHCS",
    "cmd_info_cluster_sf_VRTSvxvm",
    "cmd_info_cluster_VRTSvcs",
    "cmd_info_cluster_VRTSaslapm",
    "cmd_info_cluster_clustat",
    "cmd_info_cluster_cman_tool",
    "cmd_info_cluster_cluster_conf",
    "cmd_info_cluster_classes",
    "cmd_info_cluster_crm_status",
    "cmd_info_cluster_mkdisk",
    "cmd_info_cluster_gpfs_cluster",
    "cmd_info_cluster_gpfs_conf",
    "cmd_info_cluster_gpfs_nsd",
    "cmd_info_cluster_gpfs_nodes",
    "cmd_info_cluster_gpfs_nsd_m",
    "cmd_info_cluster_gpfs_nsd_l",
    "cmd_info_cluster_gpfs_nsd_x",
    "cmd_info_cluster_cmviewcl_v",
]

cmd_info_desc = [
    "crmadmin -v",
    "cman_tool status",
    "rpm -qa | grep VRTSvxvm",
    "rpm -qa | grep VRTSvcs",
    "rpm -qa | grep VRTSaslapm",
    "clustat -l",
    "cman_tool nodes -a",
    "cat /etc/cluster/cluster.conf",
    "crm ra classes",
    "crm status",
    "mkqdisk -L",
    "mmlscluster",
    "mmlsconfig",
    "mmlsnsd",
    "mmgetstate -a",
    "mmlsnsd -m",
    "mmlsnsd -L",
    "mmlsnsd -X",
    "cmviewcl -v",
]


def execute(context):
    """
    :param context: 上下文
    :return: 以字典格式返回命令执行结果
    """
    cli = context.get("SSH")
    lan = context.get("lang")
    cmd_display = context.get("ret_map")
    return cmd_execute(cmd_display, cli, lan, context)


def cmd_execute(cmd_display, cli, lan, context):
    fun_err_msg = ''
    prg_step = constants.PROG70 / len(cmd_info_id)
    cur_step = constants.PROG15
    for rg in range(len(cmd_info_id)):
        cmd_display_tmp = cli.execCmdHasLogTimout(
            get_sudo_cmd(cmd_info_desc[rg], LINUX, context), 60)
        cur_step += prg_step
        util.updateItemProgress(context, cur_step)
        cmd_display.put("cmd_display" + (cmd_info_id[rg])[8:], cmd_display_tmp)
        if cmd_display_tmp is None or '' == cmd_display_tmp \
                or cmd_display_tmp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 \
                or cmd_display_tmp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
            if "en" == lan:
                fun_err_msg += cmd_info_desc[rg] + ":\texecute failed\r\n"
            else:
                fun_err_msg += cmd_info_desc[rg] + u":\t执行失败\r\n"
        elif "en" == lan:
            fun_err_msg += cmd_info_desc[rg] + ":\texecute success\r\n"
        else:
            fun_err_msg += cmd_info_desc[rg] + u":\t执行成功\r\n"
    cmd_display.put("err_msg", fun_err_msg)

    return cmd_display
