#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
"""
@version: SmartKit 22.0.0.10
@time: 2022/10/06
@file: linux_data_turbo_collect_log.py
"""
import re
import sys
import os
import traceback
import java.lang.Exception as JException
from common.contentParse import single_cmd_execute, get_fail_msg, get_success_msg
from common import util

from common.util import log

# 超时时间为20分钟，单位为毫秒。
TIME_OUT = 20 * 60 * 1000

current_absolute_path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(current_absolute_path, "..\\..")
sys.path.append(path)


def execute(context):
    """
    采集重删客户端的日志信息
    :param context:
    :return:
    """
    # 切换到dataturbo脚本目录中。
    result = cd_target_dir(context)
    if not result:
        return False, "script is not exist."
    util.updateItemProgress(context, 10)

    # 执行生成日志的脚本。
    collect_dataturbo_info_cmd = get_data_turbo_collect_cmd(context)
    flag, cli_ret = single_cmd_execute(context, collect_dataturbo_info_cmd, 'change directory target version', True,
                                       TIME_OUT)
    util.updateItemProgress(context, 50)
    if not flag:
        return False, "Failed to generate DataTurbo logs."

    return down_load_data_turbo_log(cli_ret, context)


def get_data_turbo_collect_cmd(context):
    # 采集全部日志的命令
    collect_dataturbo_info_cmd = "bash dataturbo_info_collect.sh"
    log.info(context, "collect_model:{}".format(context.get("collect_model")))
    if context.get("collect_model") == "periodic_log":
        # 采集定期日志的命令
        start_time = context.get("start_time")
        end_time = context.get("end_time")
        collect_dataturbo_info_cmd = "bash dataturbo_info_collect.sh -s '{}' -e '{}'".format(start_time, end_time)
    return collect_dataturbo_info_cmd


def down_load_data_turbo_log(cli_ret, context):
    cmd_display = context.get("ret_map")
    sftp = context.get("sftp")
    lang = context.get("lang")
    log_path = get_data_turbo_log_path(cli_ret, context)
    try:
        # 下载日志
        local_path = get_local_path(context)
        sftp.getFile(local_path, log_path, None)
        util.updateItemProgress(context, 85)
        cmd_display.put("cmd_display_download_data_turbo_log", "Downloading DataTurbo logs succeeded.")
        # 删除日志
        sftp.deleteFile(log_path)
        set_cmd_display(cmd_display, "Downloading DataTurbo Client Logs", lang, True)
        util.updateItemProgress(context, 95)
        cmd_display.put("cmd_display_delete_data_turbo_log", "Delete DataTurbo logs succeeded.")
        return True, ""
    except (Exception, JException) as exception:
        log.info(context, "exception:{}".format(traceback.format_exc()))
        cmd_display.put("cmd_display_download_data_turbo_log", "Downloading DataTurbo logs failed.")
        # 删除日志
        sftp.deleteFile(log_path)
        set_cmd_display(cmd_display, "Downloading DataTurbo Client Logs", lang, False)
        return False, "Download DataTurbo log failed."


def set_cmd_display(cmd_display, command, lang, is_success):
    if is_success:
        err_msg = get_success_msg(command, lang)
    else:
        err_msg = get_fail_msg(command, lang)
    if cmd_display.get("err_msg"):
        err_msg = cmd_display.get("err_msg") + err_msg
    cmd_display.put("err_msg", err_msg)


def get_local_path(context):
    local_path = context.get("task_dir_path") + os.sep + "DataTurbo" + os.sep + "DataTurbo_" + context.get("DEV_IP")
    return local_path


def get_data_turbo_log_path(cli_ret, context):
    log_path = ""
    log.info(context, "linux_data_turbo_collect_log line:{}".format(cli_ret))
    if "Collection complete. The output package save as" in cli_ret:
        log_path = re.findall(r"Collection complete. The output package save as (.+?).gz", cli_ret)[0] + ".gz"
    log.info(context, "linux_data_turbo_collect_log log_path:{}".format(log_path))
    return log_path


def cd_target_dir(context):
    cd_target_dir_cmd = "cd /opt/oceanstor/dataturbo/script"
    flag, cli_ret = single_cmd_execute(context, cd_target_dir_cmd, 'change directory target dir', True)
    if not flag:
        return False
    return True
