# coding=utf-8
__author__ = '******'
# 获取linux主机的HBA卡信息

from common.contentParse import *
from common.util import *
from common import constants

cmd_info_id = [
    "cmd_info_hba_card_port_name_ls",
    "cmd_info_hba_card_port_name_cat",
    "cmd_info_hba_card_model_ls",
    "cmd_info_hba_card_model_cat",
    "cmd_info_hba_card_lspci",
    "cmd_info_hba_card_driver_version_ls",
    "cmd_info_hba_card_fw_version_ls",
    "cmd_info_hba_card_Folder",
    "cmd_info_hba_card_status",
]

# 注意，若需单独执行某调命令，不要使用cmd_info_desc的下标取命令，而是抽取命令的变量
cmd_hba_driver_version = "ls /sys/class/scsi_host/host*/*version |awk '/lpfc_drvr_version|driver_version/'"
cmd_fw_version = "ls /sys/class/scsi_host/host*/*fw* |awk '/fwrev|optrom_fw_version/'"
cmd_info_desc = [
    "ls /sys/class/fc_host/host*/port*name",
    "cat  /sys/class/fc_host/host*/port*name",
    "ls /sys/class/scsi_host/host*/model*name",
    "cat  /sys/class/scsi_host/host*/model*name",
    "lspci -vvnn | grep -iA2 'Fibre Channel'",
    cmd_hba_driver_version,
    cmd_fw_version,
    "ls /sys/class/fc_remote_ports/",
    "cat /sys/class/fc_host/host*/port_state",
]

specific_devType_list = [
    "SUSE 10",
    "CentOS 5.",
    "Red Hat 5.",
    "Oracle Linux 5.",
    "Oracle Linux 6.",
]

cmd_info_id_fw_version = "cmd_info_hba_card_fw_version_cat" 
cmd_info_id_hba_driver_version = "cmd_info_hba_card_driver_version_cat"
cmd_info_id_tmo = "cmd_info_hba_card_tmo" 
global cmd_info_number
cmd_info_number = 0

global onlineHostList
onlineHostList = []


def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 获取HBA 端口 型号 驱动版本信息
    context["totalPgr"]= constants.PROG60
    getCommandRet(context, cmd_info_id, cmd_info_desc)
    errMsgRet = context.get("ret_map").get("err_msg") 
    
    #获取HBA驱动版本信息
    getHbaDrvVersion(context)
    errMsgDrv = context.get("ret_map").get("err_msg")
    util.updateItemProgress(context, constants.PROG75)
    #获取FW Version命令信息
    getFwVersion(context)
    errMsgFw = context.get("ret_map").get("err_msg")
    util.updateItemProgress(context, constants.PROG85)
    #获取HBA卡的超时时间
    getHbaCardTMO(context)
    #获取端口wwn信息
    getFcPortWwnInfo(context)    
    util.updateItemProgress(context, constants.PROG95)
    errMsgTMO = context.get("ret_map").get("err_msg") 
    
    errMsgFinal = errMsgRet + errMsgDrv + errMsgFw + errMsgTMO
   
    context.get("ret_map").put("err_msg", errMsgFinal)
    return context


# 获取端口wwn信息
def getFcPortWwnInfo(context):
    if len(onlineHostList) > 0:
        for hostId in onlineHostList:
            getSingleCommandPureRet(context, "cmd_info_hba_fcport_name_%s" % hostId,
                                    "cat /sys/class/fc_host/%s/port_name" % hostId)
            getSingleCommandPureRet(context, "cmd_info_hba_fcport_type_%s" % hostId,
                                    "cat /sys/class/fc_host/%s/port_type" % hostId)
            getSingleCommandPureRet(context, "cmd_info_hba_fcport_model_desc_%s" % hostId,
                                    "cat /sys/class/scsi_host/%s/model_desc" % hostId)


# 获取hba卡驱动版本信息
def getHbaDrvVersion(context):
    execute_batch_cat_cmd(context, cmd_info_id_hba_driver_version, cmd_hba_driver_version)


# 获取FW Version命令信息
def getFwVersion(context):
    execute_batch_cat_cmd(context, cmd_info_id_fw_version, cmd_fw_version)


def execute_batch_cat_cmd(context, batch_cmd_info_id, root_cmd):
    batch_cat_cmd = ""
    files = context.get("SSH").execCmdHasLog(root_cmd).splitlines()
    for cmd in files[1:]:
        if cmd == "" or "No such file or directory" in cmd or "TOOLKIT_EXE_CMD_FAILED" in cmd or "ls:" in cmd:
            continue
        batch_cat_cmd += "cat " + cmd + ";"
    if batch_cat_cmd == "":
        return
    # 获取固件信息
    getSingleCommandRet(context, batch_cmd_info_id, batch_cat_cmd)


def getHbaCardTMO(context):
    devType = context.get("dev_type")
    isSpecific_devType = False
    log.info(context, "this device system type is:" + devType)
    for specific_devType in specific_devType_list:
        if specific_devType in devType:
            isSpecific_devType = True
            break
    
    if isSpecific_devType:
        HbaCardInfoList = getHbaCardTMOSpecific(context)
    else:
        #通用的查询
        HbaCardInfoList = getHbaCardTMOCommon(context)
    getStringRet(context, str(HbaCardInfoList).replace("u\'", "\'"))
    return
        
def getOnlineHbaHosts(context):
    
    onlineHbaHosts_list = []
    command = "/bin/ls /sys/class/fc_host"
    cmdRet = getSingleCommandPureRet(context, getCmdIndexWithKey(cmd_info_number,"cmd_info_hba_card_list"), command)
    hbaHostResult_list = cmdRet.splitlines()
    if 2 != len(hbaHostResult_list):
        log.info(context, "len(hbaHostResult_list):" + str(len(hbaHostResult_list)) + " cmdRet:" + cmdRet)
        return []
    hbaHostStr = hbaHostResult_list[1]
    if "TOOLKIT_EXE_CMD_FAILED" in hbaHostStr or "command not found" in hbaHostStr or "No such file or directory" in hbaHostStr:
        return []
    
    hbaHost_list = re.split("\s+", hbaHostStr)
    log.info(context, "this device system host list is:" + str(hbaHost_list))
    for host in hbaHost_list:
        command = "cat /sys/class/fc_host/%s/port_state" % host
        getSingleCommandPureRet(context, getCmdIndex(cmd_info_number), command)
        onlineHbaHosts_list.append(host)
    log.info(context, "this device system online host list is:" + str(onlineHbaHosts_list))
    return onlineHbaHosts_list


"""通过hostId获取HBA卡的相关信息（只限于可以通过hostID获取HBA所有信息的情况）"""
def getHbaCardInfoByHost(context, host):
    global cmd_info_number
    
    HbaCardInfoDict = {"WWPN":"NA", "HBADriver":"NA", "Host":{"PortID":host, "HBAName":"NA"}, "Timeout":"Error", "HBAModel":"NA"}
    
    #获取HBA卡型号
    command = "cat /sys/class/scsi_host/%s/model*name" % host
    hostModelRetLines = getSingleCommandPureRet(context, getCmdIndex(cmd_info_number), command).splitlines()
    if 2 == len(hostModelRetLines): 
        HbaCardInfoDict["HBAModel"] = hostModelRetLines[1].strip()

    #获取HBA卡wwpn
    command = "cat /sys/class/fc_host/%s/port_name" % host
    hostPortNameRetLines = getSingleCommandPureRet(context, getCmdIndex(cmd_info_number), command).splitlines()  
    if 2 == len(hostPortNameRetLines): 
        HbaCardInfoDict["WWPN"] = hostPortNameRetLines[1].strip()
    
    #获取HBA卡超时时间
    command = "cat /sys/class/fc_host/%s/dev_loss_tmo" % host
    hostTimeoutRetLines = getSingleCommandPureRet(context, getCmdIndex(cmd_info_number), command).splitlines()  
    if 2 == len(hostTimeoutRetLines): 
        timeout = hostTimeoutRetLines[1].strip()
        if timeout.isdigit():
            HbaCardInfoDict["Timeout"] = timeout

    return HbaCardInfoDict  

"""获取命令序号"""
def getCmdIndex(temp):
    global cmd_info_number
    
    cmd_info_number = temp + 1
    return cmd_info_id_tmo + "_" + str(cmd_info_number)


"""获取命令序号"""


def getCmdIndexWithKey(temp,key):
    global cmd_info_number

    cmd_info_number = temp + 1
    return key + "_" + str(cmd_info_number)

"""通过hostId获取HBA卡的相关信息（只限于可以通过hostID获取HBA所有信息的情况）"""
def getHbaCardInfoByHostForSpecific(context, host):
    global cmd_info_number
    
    HbaCardInfoDict = {"WWPN":"NA", "HBADriver":"NA", "Host":{"PortID":host, "HBAName":"NA"}, "Timeout":"Error", "HBAModel":"NA"}
    
    #获取HBA卡型号
    command = "cat /sys/class/scsi_host/" + host + "/model*name"
    hostModelRetLines = getSingleCommandPureRet(context, getCmdIndex(cmd_info_number), command).splitlines()
    if 2 == len(hostModelRetLines): 
        HbaCardInfoDict["HBAModel"] = hostModelRetLines[1].strip()

    #获取HBA卡wwpn
    command = "cat /sys/class/fc_host/%s/port_name" % host
    hostPortNameRetLines = getSingleCommandPureRet(context, getCmdIndex(cmd_info_number), command).splitlines()  
    if 2 == len(hostPortNameRetLines): 
        HbaCardInfoDict["WWPN"] = hostPortNameRetLines[1].strip()
    
    #获取HBA卡超时时间
    command = "cat /sys/class/scsi_host/%s/lpfc_devloss_tmo" % host
    hostTimeoutRetLines = getSingleCommandPureRet(context, getCmdIndex(cmd_info_number), command).splitlines()  
    if 2 == len(hostTimeoutRetLines): 
        timeout = hostTimeoutRetLines[1].strip()
        if timeout.isdigit():
            HbaCardInfoDict["Timeout"] = timeout

    return HbaCardInfoDict   

"""从Host列表中拆解Q卡和E卡列表"""
def getCardHostList(context, hostList):
   
    CLI = context.get("SSH")
    eCardHostList = []
    qCardHostList = []
    otherCardHostList = []
    for host in hostList:
        command = "cat /sys/class/scsi_host/" + host + "/model*name"
        hostModel = getSingleCommandPureRet(context, getCmdIndex(cmd_info_number), command)
        log.info(context, "the host id is:%s,the hbaModel is:%s" % (host, hostModel))
        if "LP" in hostModel or "OCe" in hostModel:
            eCardHostList.append(host)
        elif "QLE" in hostModel:
            qCardHostList.append(host)
        else:
            otherCardHostList.append(host)
    
    return eCardHostList, qCardHostList, otherCardHostList

"""通过hostId获取HBA卡的相关信息"""
def getHbaCardTMOCommon(context):
    global onlineHostList
    HbaCardInfoList = []
    #获取在线的端口信息
    onlineHostList = getOnlineHbaHosts(context)
    for host in onlineHostList:
        #记录HBA卡信息
        HbaCardInfoList.append(getHbaCardInfoByHost(context, host))
    
    return HbaCardInfoList
  
"""特殊操作系统获取HBA卡的相关信息（如Suse10和CentOS 5.11）"""
def getHbaCardTMOSpecific(context):
    global cmd_info_number
    global onlineHostList
    
    CLI = context.get("SSH")
    HbaCardInfoList = []

    #获取在线的端口信息
    onlineHostList = getOnlineHbaHosts(context)
    eCardHostList, qCardHostList, otherCardHostList = getCardHostList(context, onlineHostList)
    log.info(context, "this device system Emulex card list is:" + str(eCardHostList))
    log.info(context, "this device system Qlogic card list is:" + str(qCardHostList))
    log.info(context, "this device system other Card list is:" + str(otherCardHostList))

    #其他厂商的卡，也当成E卡处理，如果收集失败，记录错误信息
    eCardAndOtherCardHostList = eCardHostList + otherCardHostList
    for host in eCardAndOtherCardHostList:
        #记录HBA卡信息
        HbaCardInfoList.append(getHbaCardInfoByHostForSpecific(context, host))
    log.info(context, "this device system eCard and otherCard infomation is:" + str(HbaCardInfoList))

    #不存在Q卡的情况不需要处理
    if not qCardHostList:
        return HbaCardInfoList
    
    #查询Q卡
    parameterList = ["Please Enter Selection:", "Press <Enter> to continue:", "#"]
    hbaCardModelCmd_str = getSingleCommandPureRetWithSpecifiedTerminator(context, getCmdIndex(cmd_info_number), "qaucli", parameterList)
    if "command not found" in hbaCardModelCmd_str.strip() and hbaCardModelCmd_str.strip().endswith("#"):
        HbaCardInfoDict = {"WWPN":"NA", "HBADriver":"NA", "Host":{"PortID":"NA", "HBAName":"NA"}, "Timeout":"Unknown", "HBAModel":"NA"}
        HbaCardInfoList.append(HbaCardInfoDict)
        return HbaCardInfoList
    elif not hbaCardModelCmd_str.strip().endswith("Please Enter Selection:"):
        HbaCardInfoDict = {"WWPN":"NA", "HBADriver":"NA", "Host":{"PortID":"NA", "HBAName":"NA"}, "Timeout":"Error", "HBAModel":"NA"}
        HbaCardInfoList.append(HbaCardInfoDict)
        return HbaCardInfoList
        
    hbaCardModelCmd_str = getSingleCommandPureRetWithSpecifiedTerminator(context, getCmdIndex(cmd_info_number), "2", parameterList)
    if not hbaCardModelCmd_str.strip().endswith("Please Enter Selection:"):
        HbaCardInfoDict = {"WWPN":"NA", "HBADriver":"NA", "Host":{"PortID":"NA", "HBAName":"NA"}, "Timeout":"Error", "HBAModel":"NA"}
        HbaCardInfoList.append(HbaCardInfoDict)
        return HbaCardInfoList
    
    hbaCardModelCmd_str = getSingleCommandPureRetWithSpecifiedTerminator(context, getCmdIndex(cmd_info_number), "3", parameterList)
    if not hbaCardModelCmd_str.strip().endswith("Please Enter Selection:"):
        HbaCardInfoDict = {"WWPN":"NA", "HBADriver":"NA", "Host":{"PortID":"NA", "HBAName":"NA"}, "Timeout":"Error", "HBAModel":"NA"}
        HbaCardInfoList.append(HbaCardInfoDict)
        return HbaCardInfoList
    
    hbaModelRes_list = hbaCardModelCmd_str.splitlines()
    for modeRes in hbaModelRes_list:
        #查询一个端口的信息
        if 'hba model' in modeRes.lower():
            qModel = modeRes.strip().split(" ")[2]
            
        if 'port' in modeRes.lower() and 'wwpn' in modeRes.lower():
            if "link down" in modeRes.lower():
                continue
            infoDatas = modeRes.strip().split(":")
            if len(infoDatas) <= 3:
                continue
            
            try:
                #初始化一个端口信息
                qPort = infoDatas[0].strip()
                wwpn = infoDatas[-1].strip().split(" ")[0].strip()
                HbaCardInfoDict = {"WWPN":wwpn, "HBADriver":"NA", "Host":{"PortID":qPort, "HBAName":"NA"}, "Timeout":"Error", "HBAModel":qModel}
                
                #获取HBA卡配置信息
                hbaCardModelCmd_str = getSingleCommandPureRetWithSpecifiedTerminator(context, getCmdIndex(cmd_info_number), qPort, parameterList)
                if not hbaCardModelCmd_str.strip().endswith("Please Enter Selection:"):
                    HbaCardInfoList.append(HbaCardInfoDict)
                    break

                hbaCardModelCmd_str = getSingleCommandPureRetWithSpecifiedTerminator(context, getCmdIndex(cmd_info_number), "1", parameterList)
                if not hbaCardModelCmd_str.strip().endswith("Press <Enter> to continue:"):
                    HbaCardInfoList.append(HbaCardInfoDict)
                    break
                
                hbaCardInfoLines = hbaCardModelCmd_str.splitlines()
                for line in hbaCardInfoLines:
                    if "link down timeout (seconds)" in line.lower():
                        timeOut = line.split(":")[-1].strip()
                        #保存一个端口信息
                        HbaCardInfoDict["Timeout"] = timeOut
                        break
                
                hbaCardModelCmd_str = CLI.execCtrlCmd("13", 300, parameterList)
                context.get("ret_map").put("cmd_display" + getCmdIndex(cmd_info_number)[8:], hbaCardModelCmd_str)
                if not hbaCardModelCmd_str.strip().endswith("Please Enter Selection:"):
                    HbaCardInfoList.append(HbaCardInfoDict)
                    break
                
                #执行0退回到上一级选项
                hbaCardModelCmd_str = getSingleCommandPureRetWithSpecifiedTerminator(context, getCmdIndex(cmd_info_number), "0", parameterList)
                if not hbaCardModelCmd_str.strip().endswith("Please Enter Selection:"):
                    HbaCardInfoList.append(HbaCardInfoDict)
                    break
                
                HbaCardInfoList.append(HbaCardInfoDict)
            except:
                log.error(context, "[getHbaCardTMOSpecific] except trace back:" + unicode(traceback.format_exc()))
                continue
            
    CLI.execCmdHasLog("ex")
    log.info(context, "this device system allCard infomation is:" + str(HbaCardInfoList))
    return HbaCardInfoList
