# coding=utf-8
import re
import traceback
from com.huawei.ism.tool.infograb.context import EvalResultEnum
from com.huawei.ism.tool.infograb.entity import Item
from hosts.linux import linux_lun_wwn_info
from common import util
from common import contentParse
from common import constants
from hosts.common.linux_parse_utils import get_dm_name_list
from common.cmd_execute import DES, CMD, BaseCmdExecute, change_list_to_tuple


def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display{}
    cmd_display.put("cmd_display"+(cmd_info_id[rg])[8:], cmd_display_temp)
    cmd_display.put("err_msg", fun_err_msg  + cmd_display.get("err_msg"))
    cmd_display.put("evl_ret", CHECK_FAIL)
    """
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = context.get("lang")
    util.updateItemProgress(context, constants.PROG5)
    linux_lun_wwn_info.get_result_info(context)
    cmd_execute(context)

    global ULTRAPATHCTRL
    ULTRAPATHCTRL = True
    global MULTIPATHCTRL
    MULTIPATHCTRL = True
    global COEXISTENCE
    COEXISTENCE = False

    #过滤掉与当前存储不关联的主机信息新增加字典格式如下:
    #LUNWWNSNDICT["0"] = WWN_600188210062f25795d139b700000004    自研+非双活
    #LUNWWNSNDICT["0"] = SN_210000188262f257,SN_210000188262f258 自研+双活

    global LUNWWNSNDICT
    LUNWWNSNDICT = {}
    return doEvaluate(context)

def doEvaluate(context):
    '''
    @summary: Evaluate ultrapath.
    @param context: Python execution context.
    @return: retDict from python execution context.
    '''
    global ULTRAPATHCTRL
    global MULTIPATHCTRL
    global COEXISTENCE
    retDict = context.get("ret_map")
    isQrySucc, ultrapathVersion, cliRet = util.qryUltrapathVersion(context)
    if not isQrySucc:
        errParas = [constants.QRY_ULTRAPATH_CMD, "messageKey:" + constants.ERR_MSG_KEY_QRY_MULTIPATH_FAILED]
        util.log.error(context, 'Query ultrapath version failed.')
        itemEvalResult = genEvalResultForMultipath(EvalResultEnum.FAILED, cliRet,
                         constants.RECOMMENDED_ACTIONS_NETWORK_CONNECTION, errParas)
        retDict['evalResult'] = itemEvalResult
        return retDict
    else:
        util.log.info(context, 'Ultrapath version is:' + unicode(ultrapathVersion))
    isQrySucc, isMultipathdRunning, pathdCliRet = util.qryMultipathdStatus(context)
    contentParse.setCmdRet4Report(context, pathdCliRet, "cmd_display_multipathd_status")
    util.updateItemProgress(context, constants.PROG10)
    cliRet += pathdCliRet
    if not isQrySucc:
        errParas = [constants.QRY_MULTIPATHD_STATUS, "messageKey:" + constants.ERR_MSG_KEY_QRY_MULTIPATHD_FAILED]
        util.log.error(context, 'Query multipathd status failed.')
        itemEvalResult = genEvalResultForMultipath(EvalResultEnum.FAILED, cliRet,
                         constants.RECOMMENDED_ACTIONS_NETWORK_CONNECTION, errParas)
        retDict['evalResult'] = itemEvalResult
        util.updateItemProgress(context, constants.PROG90)
        return retDict

    #None-root user has no privilege to query multipathd running status on Linux of some release version.
    if 'may require superuser privileges' in pathdCliRet:
        util.log.error(context, 'No privilege to query multipathd status.')
        errParas = [constants.QRY_MULTIPATHD_STATUS, "messageKey:" + constants.ERR_MSG_KEY_QRY_MULTIPATHD_NO_PRIVILEGE]
        itemEvalResult = genEvalResultForMultipath(EvalResultEnum.FAILED, cliRet,
                         constants.RECOMMENDED_ACTIONS_NETWORK_CONNECTION, errParas)
        retDict['evalResult'] = itemEvalResult
        util.updateItemProgress(context, constants.PROG90)
        return retDict

    _, portNumbers, cliReturn, _, _ = util.getTargetPortNumByMultipath(context,
                                                                       True)
    if ultrapathVersion and isMultipathdRunning and "UPTYPE" in portNumbers:
        errMsgKey = "eval.host.multipath.reduntpath.self&buildin.allexists"
        util.log.error(context, 'Ultrapath and multipathd service is running.')
        itemEvalResult = genEvalResultForMultipath(EvalResultEnum.FAILED, cliRet + cliReturn, errMsgKey)
        retDict['evalResult'] = itemEvalResult
        util.updateItemProgress(context, constants.PROG90)
        return retDict

    if ultrapathVersion and isMultipathdRunning:
        COEXISTENCE = True
        util.log.error(context, 'Ultrapath and multipathd service are running at the same time.')
        multipathCoexistenceInfo = util.MultipathCoexistenceInfo()
        multipathCoexistenceInfo.setHostIP(CLI.getHost())
        multipathCoexistenceInfo.setCoexistence(True)
#       执行自研多路径
        itemEvalResultUltrapath = checkRedundantLinkByUltrapath(context, ultrapathVersion)
        multiPathExecuteInfo = setMultipathCoexistenceInfo(cliRet, itemEvalResultUltrapath, ULTRAPATHCTRL)
        multipathCoexistenceInfo.setHuaweiMultipath(multiPathExecuteInfo)
#       执行自带多路径
        itemEvalResultMultipathd = checkRedundantLinkByMultipathd(context, multipathCoexistenceInfo)
        multiPathExecuteInfoForSelf = setMultipathCoexistenceInfo(cliRet, itemEvalResultMultipathd, MULTIPATHCTRL)
        multipathCoexistenceInfo.setSelfMultiPath(multiPathExecuteInfoForSelf)
        util.updateItemProgress(context, constants.PROG90)
        contentParse.addMultiPathResultToFile(retDict, multipathCoexistenceInfo.getJsonStr())
        return

    if not ultrapathVersion and not isMultipathdRunning:
        errMsgKey = constants.ERR_MSG_KEY_ULTRAPATH_MULTIPATHD_ALL_NOT_RUNING
        util.log.error(context, 'Neither Ultrapath nor multipathd service is running.')
        itemEvalResult = genEvalResultForMultipath(EvalResultEnum.FAILED, cliRet, errMsgKey)
        retDict['evalResult'] = itemEvalResult
        util.updateItemProgress(context, constants.PROG90)
        return retDict

    if ultrapathVersion:#For HUAWEI Ultrapath check.
        itemEvalResult = checkRedundantLinkByUltrapath(context, ultrapathVersion)
        itemEvalResult.setCliRet(cliRet + itemEvalResult.getCliRet())
        util.updateItemProgress(context, constants.PROG90)
        retDict['evalResult'] = itemEvalResult
        return itemEvalResult
    else:#For Linux multhpathd check.
        itemEvalResult = checkRedundantLinkByMultipathd(context)
        itemEvalResult.setCliRet(cliRet + itemEvalResult.getCliRet())
        util.updateItemProgress(context, constants.PROG90)
        retDict['evalResult'] = itemEvalResult
        return itemEvalResult

def setMultipathCoexistenceInfo(cliRet, itemEvalResult, isControl):
    '''
    @summary: set ultrapath information for coexistence.
    @param cliRet: cliRet.
    @param itemEvalResult: multipath result.
    @return: multiPathExecuteInfo.
    '''
    multiPathExecuteInfo = util.MultiPathExecuteInfo()

    itemEvalUltrapathEvalResult = itemEvalResult.getEvalResult()
    itemEvalUltrapathCliRet = cliRet + itemEvalResult.getCliRet()
    itemEvalUltrapathErrParas = itemEvalResult.getErrParas()

#   设置到多路径对象中
    multiPathExecuteInfo.setCliRet(itemEvalUltrapathCliRet)
    multiPathExecuteInfo.setFailCommand('')
    multiPathExecuteInfo.setfailDescribe('')
    multiPathExecuteInfo.setNoRedundantPath('')

    if EvalResultEnum.PASSED == itemEvalUltrapathEvalResult:
        multiPathExecuteInfo.setControl(True)
    else:
        hasfailCommand = False
        for errParas in itemEvalUltrapathErrParas:
            if "messageKey:" in errParas:
                hasfailCommand = True
                break
        multiPathExecuteInfo.setControl(isControl)

        if hasfailCommand:
            multiPathExecuteInfo.setFailCommand(itemEvalUltrapathErrParas[0])
            multiPathExecuteInfo.setfailDescribe(itemEvalUltrapathErrParas[1][11:])
        elif len(itemEvalUltrapathErrParas) > 1:
            multiPathExecuteInfo.setNoRedundantPath(",".join(itemEvalUltrapathErrParas[1:]))

    return multiPathExecuteInfo

def checkRedundantLinkByUltrapath(context, ultrapathVersion):
    '''
    @summary: Check all LUN redundant link with ultrapath.
    @param context: Python execution context.
    @param ultrapathVersion: Ultrapath version
    @return:  item evaluate result of Java bean.
    '''
    tupVer = util.getUltrapathIntVer(context, ultrapathVersion)
    lowerTupVer = util.getUltrapathIntVer(context, constants.LINUX_LOWER_ULTRAPATH_VER)
    middleTupVer = util.getUltrapathIntVer(context, constants.LINUX_MIDDLE_ULTRAPATH_VER)
    if tupVer <= lowerTupVer:
        return checkLowerVerRedundantPath(context)
    elif tupVer <= middleTupVer:
        return checkVlunRedundantLink(context, True)
    else:
        return checkVlunRedundantLink(context, False)

def checkLowerVerRedundantPath(context):
    '''
    @summary: Check all LUN redundant link with ultrapath with version lower than or equal to 5.01.017.
    @param context: Python execution context.
    @return: object of ItemEvalResult 
    '''
    global ULTRAPATHCTRL
    global LUNWWNSNDICT
    isQrySucc, arrayIDList, cliRet = util.getArrayIdsManagedByUltrapath(context)
    util.addItemProgress(context, getPropProgress(constants.PROG15))
    if not isQrySucc:
        util.log.error(context, 'Query array managed by ultrapath failed.')
        ULTRAPATHCTRL = False
        errParas = [constants.QRY_ARRAY_ID_CMD, "messageKey:" + constants.ERR_MSG_KEY_QRY_ARRAY_ID_FAILED]
        errMsgKey = constants.RECOMMENDED_ACTIONS_NETWORK_CONNECTION
        return genEvalResultForMultipath(EvalResultEnum.FAILED, cliRet, errMsgKey, errParas)
    if not arrayIDList:
        util.log.error(context, 'Query no array managed by ultrapath.')
        ULTRAPATHCTRL = False
        errParas = [constants.QRY_ARRAY_ID_CMD]
        return genEvalResultForMultipath(EvalResultEnum.FAILED,
                                         cliRet,
                                         constants.ERR_MSG_KEY_QRY_VLUN_ID_EMPTY, errParas)

    cli = context.get("SSH")
    COEXIST_RATE = 2
    progRate = COEXIST_RATE if COEXISTENCE else 1
    prgStep = constants.PROG35 * progRate / len(arrayIDList)
    noRedundantPathLunIds = []
    for arrayId in arrayIDList:
        try:
            arrayLunRet = cli.execCmdWithNoCheckResult('upadm show lun array=' + arrayId,
                                           constants.HOST_CMD_TIMEOUT)
            util.addItemProgress(context, prgStep)
            cliRet += arrayLunRet
            lunPathDict = parseAllLunPathOfOneArray(arrayLunRet)

            if not lunPathDict:
                ULTRAPATHCTRL = True
                util.log.error(context, 'No lun found for array:' + unicode(arrayId))
                errMsgKey = constants.RECOMMENDED_ACTIONS_NETWORK_CONNECTION
                errParas = ['upadm show lun array=' + arrayId, "messageKey:" + constants.ERR_MSG_KEY_QRY_ARRAY_LUN_PATH_FAILED]
                return genEvalResultForMultipath(EvalResultEnum.FAILED,
                                                 cliRet,
                                                 errMsgKey, errParas)

            noRedundantPathLunIds.extend(chkAllLunRedundantPath(context, lunPathDict))
        except:
            errMsgKey = constants.RECOMMENDED_ACTIONS_NETWORK_CONNECTION
            errParas = ['upadm show lun array=' + arrayId, "messageKey:" + constants.ERR_MSG_KEY_QRY_ARRAY_LUN_PATH_FAILED]
            util.log.error(context, 'Query array IDs exception:' + traceback.format_exc())
            return genEvalResultForMultipath(EvalResultEnum.FAILED, cliRet,
                                             errMsgKey, errParas)

    if not noRedundantPathLunIds:
        return genEvalResultForMultipath(EvalResultEnum.PASSED, cliRet, '')
    else:
        noRedundantPathLunIdtmp = []
        errParas = [str(cli.getHost())]

        #新增加LUN的SN\WWN信息,用于过滤 2018.12.13
        util.log.error(context, 'the Lun wwn dict is:' + str(LUNWWNSNDICT))
        for noRedundantPathLunId in noRedundantPathLunIds:
            noRedundantPathLunIdtmp.append(noRedundantPathLunId + '(' + LUNWWNSNDICT.get(noRedundantPathLunId, "") + ')'
                                           if LUNWWNSNDICT.get(noRedundantPathLunId, "")
                                           else noRedundantPathLunId)

        errParas.append(','.join(noRedundantPathLunIdtmp))
        return genEvalResultForMultipath(EvalResultEnum.FAILED,
                         cliRet,
                         constants.ULTRA_NOT_PASS_TIPS,
                         errParas)

def parseAllLunPathOfOneArray(arrayLunRet):
    '''
    @summary: Parse all LUN path of one array according the upadm show lun array = arrayId command result.
    @param arrayLunRet: command result.
    @return: LUN PATH dictionary.
    '''
    global LUNWWNSNDICT
    lunPathDict = {}
    keyWord = 'Information of Lun'
    if 'Lun Information' in arrayLunRet:
        keyWord = 'Lun Information'
    keyWordLen = len(keyWord)
    lunInfoStartIdx = arrayLunRet.find(keyWord)
    newPathPattern = re.compile(constants.NEW_PATH_FOUND_NEW_PATTERN, re.I)
    pathPattern = re.compile(constants.CTRL_ID_NEW_RE_PATTERN, re.I)
    totLen = len(arrayLunRet)

    while -1 != lunInfoStartIdx and lunInfoStartIdx < totLen - 1:
        nextLunInfoStartIdx = arrayLunRet.find(keyWord, lunInfoStartIdx + keyWordLen)
        lunPath, lunId = '', ''
        for line in arrayLunRet[lunInfoStartIdx:nextLunInfoStartIdx].splitlines():
            line = line.strip().lower()
            if not isValidLunPathInfoLine(line):
                continue

            #find a new LUN
            if 'lun #' in line:
                lunId = line.split('-')[0].split('lun #')[-1].strip()
                lunPathDict[lunId] = []

                # 获取LUN的WWN信息 by 2018.12.13
                if "wwn:" in line:
                    lunWwn = line.split('wwn:')[-1].split()[0].strip()
                    LUNWWNSNDICT[lunId] = ("WWN_" + lunWwn) if lunWwn else ""
                continue
            elif 'information of lun' in line:
                lunId = line.split('-')[0].split('information of lun')[-1].strip()
                lunPathDict[lunId] = []

                # 获取LUN的WWN信息 by 2018.12.13
                if "wwn:" in line:
                    lunWwn = line.split('wwn:')[-1].split()[0].strip()
                    LUNWWNSNDICT[lunId] = ("WWN_" + lunWwn) if lunWwn else ""
                continue

            #new lun path found
            if newPathPattern.search(line) and pathPattern.search(line):
                lunPath = pathPattern.search(line).group()[1:]
                continue

            if lunPath and line.startswith('numlunobjects'):
                objNum = int(line.split(':')[1].split()[0].strip())
                if objNum > 0:
                    pass
                else:
                    lunPath = ''
                continue

            if lunPath and 'devstate' in line and len(line.split(':')) <= 2:
                devState = line.split(':')[-1].strip()
                if 'optimal' == devState.lower():
                    if lunId in lunPathDict:
                        lunPathDict[lunId].append(lunPath)

        lunInfoStartIdx = nextLunInfoStartIdx
    return lunPathDict

def isValidLunPathInfoLine(line):
    lowerLine = line.lower()
    return ('lun name' in lowerLine or 'controller' in line
         or 'numlunobjects' in line or ('devstate' in line and 'bootowningpath' not in line))

def chkAllLunRedundantPath(context, lunPathDict):
    noRedundantPathLunIds = []
    for lunId in lunPathDict:
        lunPath = lunPathDict.get(lunId)
        if not util.hasRedundantPathForCtrlIdPath(context, lunPath):
            noRedundantPathLunIds.append(lunId)
    return noRedundantPathLunIds

def checkVlunRedundantLink(context, isMiddleVer = True):
    '''
    @summary: Check all LUN redundant link with ultrapath with version higher than 5.01.017
    @param context: Python execution context.
    @return: object of ItemEvalResult 
    '''
    global ULTRAPATHCTRL
    global LUNWWNSNDICT
    isQrySucc, vlunIdList, cliRet = util.getVlunIdsManagedByUltrapath(context, isMiddleVer)
    util.addItemProgress(context, getPropProgress(constants.PROG15))
    if "can't find any" in cliRet.lower():
        util.log.error(context, 'Query no array managed by ultrapath.')
        ULTRAPATHCTRL = False
        errParas = [constants.QRY_VLUN_ID_CMD if isMiddleVer else constants.High_VER_QRY_VLUN_ID_CMD]
        return genEvalResultForMultipath(EvalResultEnum.FAILED,
                                         cliRet,
                                         constants.ERR_MSG_KEY_QRY_VLUN_ID_EMPTY, errParas)

    if not isQrySucc or not vlunIdList:
        util.log.error(context, 'Query vluns managed by ultrapath failed.')
        ULTRAPATHCTRL = False
        errParas = [constants.QRY_VLUN_ID_CMD if isMiddleVer else constants.High_VER_QRY_VLUN_ID_CMD,
                    "messageKey:" + constants.ERR_MSG_KEY_QRY_VLUN_ID_FAILED]
        errMsgKey = constants.RECOMMENDED_ACTIONS_NETWORK_CONNECTION
        return genEvalResultForMultipath(EvalResultEnum.FAILED,
                                  cliRet, errMsgKey, errParas)

    cli = context.get("SSH")

    noRedundantPathLunIdList = []
    hyperMetroLunNoRedundantIdList = []
    progRate = 1 if COEXISTENCE else 2
    prgStep, stepsUnit = util.calcPerStepDetail(constants.PROG35 * progRate, len(vlunIdList))
    cliRet += util.query_show_path_info(context, "upadmin show path")
    for idx in range(len(vlunIdList)):
        try:
            vlunId = vlunIdList[idx]
            qryVlunPthCmd = 'upadmin show vlun id=' + vlunId + ('' if isMiddleVer else ' type=all')
            vlunPthRet = cli.execCmdWithNoCheckResult(qryVlunPthCmd,
                                                      constants.HOST_CMD_TIMEOUT)
            cliRet += vlunPthRet
            isHyperMetroLUN, chkPass, lunInfo = util.chkSingleLunPathRedundant(context, vlunPthRet)
            LUNWWNSNDICT[vlunId] = lunInfo
            util.itemProgressIncr(context, idx, prgStep, stepsUnit)

            if not isHyperMetroLUN:
                if not chkPass:
                    util.log.error(context, 'Normal Vlun path not redundant:' + vlunId)
                    noRedundantPathLunIdList.append(vlunId)
                else:
                    util.log.info(context, 'Normal or migration Vlun path redundant:' + vlunId)
            elif chkPass:
                util.log.info(context, 'Hypermetro Vlun path redundant:' + vlunId)
            else:
                hyperMetroLunNoRedundantIdList.append(vlunId)
                util.log.error(context,
                               'Hypermetro Vlun path not redundant '
                               'or from different array or missing sub LUN:' + vlunId)
        except:
            util.log.error(context, 'Query VLUN path exception:' + traceback.format_exc())
            errMsgKey = constants.RECOMMENDED_ACTIONS_NETWORK_CONNECTION
            errParas = ['upadmin show vlun id=' + vlunId + ('' if isMiddleVer else ' type=all'),
                        "messageKey:" + constants.ERR_MSG_KEY_QRY_SINGLE_LUN_PATH_FAILED]
            return genEvalResultForMultipath(EvalResultEnum.FAILED,
                                  cliRet, errMsgKey, errParas)

    if not noRedundantPathLunIdList and not hyperMetroLunNoRedundantIdList:
        return genEvalResultForMultipath(EvalResultEnum.PASSED, cliRet, '')
    else:
        errParas = [str(cli.getHost())]
        if noRedundantPathLunIdList and not hyperMetroLunNoRedundantIdList:
            #新增加LUN的SN\WWN信息,用于过滤 2018.12.13
            noRedundantPathLunIdtmp = []
            for noRedundantPathLunId in noRedundantPathLunIdList:
                noRedundantPathLunIdtmp.append(noRedundantPathLunId + '(' + LUNWWNSNDICT.get(noRedundantPathLunId, "") + ')'
                if LUNWWNSNDICT.get(noRedundantPathLunId, "")
                else noRedundantPathLunId)

            errParas.append(','.join(noRedundantPathLunIdtmp))
            return genEvalResultForMultipath(EvalResultEnum.FAILED, cliRet,
                                         constants.ULTRA_NOT_PASS_TIPS,
                                         errParas)
        elif not noRedundantPathLunIdList and hyperMetroLunNoRedundantIdList:

            #新增加LUN的SN\WWN信息,用于过滤 2018.12.13
            noRedundantPathLunIdtmp = []
            for noRedundantPathLunId in hyperMetroLunNoRedundantIdList:
                noRedundantPathLunIdtmp.append(noRedundantPathLunId + '(' + LUNWWNSNDICT.get(noRedundantPathLunId, "") + ')'
                if LUNWWNSNDICT.get(noRedundantPathLunId, "")
                else noRedundantPathLunId)

            errParas.append(','.join(noRedundantPathLunIdtmp))
            return genEvalResultForMultipath(EvalResultEnum.FAILED, cliRet,
                                             constants.ULTRA_HYPER_METRO_VLUN_NOT_PASS_TIPS,
                                             errParas)
        else:
            #新增加LUN的SN\WWN信息,用于过滤 2018.12.13
            noRedundantPathLunIdListTmp = []
            for noRedundantPathLunId in noRedundantPathLunIdList:
                noRedundantPathLunIdListTmp.append(noRedundantPathLunId + '(' + LUNWWNSNDICT.get(noRedundantPathLunId, "") + ')'
                if LUNWWNSNDICT.get(noRedundantPathLunId, "")
                else noRedundantPathLunId)
            hyperMetroLunNoRedundantIdListTmp = []
            for noRedundantPathLunId in hyperMetroLunNoRedundantIdList:
                hyperMetroLunNoRedundantIdListTmp.append(noRedundantPathLunId + '(' + LUNWWNSNDICT.get(noRedundantPathLunId, "") + ')'
                if LUNWWNSNDICT.get(noRedundantPathLunId, "")
                else noRedundantPathLunId)

            errParas.append(','.join(noRedundantPathLunIdListTmp + hyperMetroLunNoRedundantIdListTmp))
            return genEvalResultForMultipath(EvalResultEnum.FAILED, cliRet,
                                             constants.ULTRA_NOT_PASS_TIPS,
                                             errParas)
def getPropProgress(prog):
    '''
    @summary: 返回恰当的进度信息
    :param prog:
    :return:
    '''
    if COEXISTENCE:
        return prog / 2
    return prog
def checkRedundantLinkByMultipathd(context, multipathCoexistenceInfo = None):
    '''
    @summary: 评估自带多路径管理的存储LUN是否存在冗余路径。
    @param context: 上下文
    @return:评估结果.
    '''
    global MULTIPATHCTRL
    global LUNWWNSNDICT

    isQrySucc, portNumbers, cliRet, diskWWNDict, _ = \
        util.getTargetPortNumByMultipath(
            context)
    LUNWWNSNDICT = dict(LUNWWNSNDICT, **diskWWNDict)

    util.addItemProgress(context, getPropProgress(constants.PROG15))
    if not isQrySucc:
        MULTIPATHCTRL = False
        errParas = [constants.QRY_DISK_PTH_MANAGED_BY_MULTIPATHD_CMD,
                    "messageKey:" + constants.ERR_MSG_KEY_QRY_TGT_PORT_NUM_FAILED]
        util.log.error(context, 'Query target port number reported by storage failed.')
        errMsgKey = constants.RECOMMENDED_ACTIONS_NETWORK_CONNECTION
        return genEvalResultForMultipath(EvalResultEnum.FAILED,
                                         cliRet, errMsgKey, errParas)

    if not portNumbers:
        errParas = [constants.QRY_DISK_PTH_MANAGED_BY_MULTIPATHD_CMD]
        MULTIPATHCTRL = False
        util.log.error(context, 'Query no array managed by ultrapath.')
        errMsgKey = constants.ERR_MSG_KEY_QRY_TGT_PORT_NUM_EMPTY
        return genEvalResultForMultipath(EvalResultEnum.FAILED,
                                  cliRet, errMsgKey, errParas)

    util.log.info(context, 'Target port number list:' + unicode(portNumbers))
    tgtPortNumPthMap, qryPthCliRet = util.getPortNumPathDict(context, portNumbers)
    cliRet += ('\n' + qryPthCliRet)
    if not tgtPortNumPthMap:
        if COEXISTENCE:
            errParas = [",".join(constants.QRY_TGT_PORT_PATH_CMD % protNumber for protNumber in portNumbers),
                        "messageKey:" + constants.ERR_MSG_KEY_QRY_TGT_PORT_PATH_EMPTY]
        else:
            errParas = ["\",\n\"".join(constants.QRY_TGT_PORT_PATH_CMD % protNumber for protNumber in portNumbers),
                        "messageKey:" + constants.ERR_MSG_KEY_QRY_TGT_PORT_PATH_EMPTY]

        errMsgKey = constants.RECOMMENDED_ACTIONS_NETWORK_CONNECTION
        util.log.error(context, 'Query all the path of target port failed.')
        return genEvalResultForMultipath(EvalResultEnum.FAILED,
                                  cliRet, errMsgKey, errParas)

    util.log.info(context, 'Target port number path:' + unicode(tgtPortNumPthMap))
    return evaluteAllDiskManagedByMultiPathd(context, tgtPortNumPthMap, multipathCoexistenceInfo)

def evaluteAllDiskManagedByMultiPathd(context, tgtPortNumPthMap, multipathCoexistenceInfo = None):
    '''
    @summary: 根据查询到的端口路径映射关系，判断自带多路径服务multipathd管理的所有华为磁盘是否存在冗余链路。
    @param context: Python执行上下文.
    @param tgtPortNumPthMap: TGT端口和路径的映射字典。
    @return: isEvalSuccess, notRedundantDiskList, cliRet
    '''
    global LUNWWNSNDICT
    cli = context.get("SSH")
    notRedundantPathDiskList = []
    allPthRet = ''
    selfMultiInfoList = []
    qryAllDiskPthCmd = constants.QRY_DISK_PTH_MANAGED_BY_MULTIPATHD_CMD
    try:
        allPthRet = cli.execCmdWithNoCheckResult(qryAllDiskPthCmd,
                                       constants.HOST_CMD_TIMEOUT)

        diskPathDict = parseAllDiskPth(allPthRet, tgtPortNumPthMap)
        if not diskPathDict:#no disk found, unable to evaluate.
            errParas = [qryAllDiskPthCmd, "messageKey:" + constants.ERR_MSG_MULTIPATHD_NO_HW_DISK_FOUND]
            errMsgKey = constants.RECOMMENDED_ACTIONS_NETWORK_CONNECTION
            return genEvalResultForMultipath(EvalResultEnum.FAILED,
                             allPthRet, errMsgKey, errParas)
        COEXIST_RATE = 2
        progRate = 1 if COEXISTENCE else COEXIST_RATE
        prgStep, stepsUnit = util.calcPerStepDetail(constants.PROG35 * progRate, len(diskPathDict))
        idx = 0
        hostSessionDict = {}
        for diskName in diskPathDict:
            util.log.info(context, 'LunName:' + unicode(diskName) + 'LunPath:' + unicode(diskPathDict.get(diskName)))
            # 增加自带+ISCSI组网判断

            diskPathNode = diskPathDict.get(diskName)
            allNodeID = range(4)

            # 差集长度和diskPathNode的长度相等.纯ISCSI组网
            if diskPathNode and \
                    len(list(set(diskPathNode).difference(set(allNodeID)))) \
                    == len(set(diskPathNode)):
                selfMultipathInfo = util.SelfMultipathInfo()
                selfMultipathInfo.setDiskName(diskName)
                selfMultipathInfo.setNetworkType("ISCSI")

                if not hostSessionDict:
                    hostSessionDict, cliRet = getISCSIHostSessionDict(context)
                    allPthRet += cliRet

                for diskPath in diskPathNode:
                    path, cliRet = getISCSISessionPath(context, diskPath, hostSessionDict)
                    allPthRet += cliRet
                    if path not in selfMultipathInfo.getPath():
                        selfMultipathInfo.setPath(path)
                if COEXISTENCE:
                    multipathCoexistenceInfo.setSelfMultipathInfo(selfMultipathInfo)
                else:
                    selfMultiInfoList.append(selfMultipathInfo)
                continue

            # 差集diskPathNode中有而allNodeID中没有的.一个磁盘或一个LUN，FC和ISCSI混合组网
            if diskPathNode and \
                    list(set(diskPathNode).difference(set(allNodeID))):
                selfMultipathInfo = util.SelfMultipathInfo()
                selfMultipathInfo.setDiskName(diskName)
                selfMultipathInfo.setNetworkType("HybridNetwork")

                if COEXISTENCE:
                    multipathCoexistenceInfo.setSelfMultipathInfo(selfMultipathInfo)
                else:
                    selfMultiInfoList.append(selfMultipathInfo)
                continue


            if not util.hasRedundantPathForCtrlIdPath(context, diskPathDict.get(diskName), isNodeId = True):
                notRedundantPathDiskList.append(diskName)
            util.itemProgressIncr(context, idx, prgStep, stepsUnit)
            idx += 1

        if COEXISTENCE:
            util.log.info(context, 'multipathCoexistenceInfo info path are:' + unicode(
                multipathCoexistenceInfo.getSelfMultipathInfo()))
        else:
            util.log.info(context, 'self multipath info path are:' + unicode(selfMultiInfoList))

        # 所有的盘一起看，将selfMultipathInfoList作为参数传入
        if not notRedundantPathDiskList:
            return genEvalResultForMultipath(EvalResultEnum.PASSED, allPthRet, '',
                                             selfMultipathInfoList = selfMultiInfoList)
        else:
            errParas = [str(cli.getHost())]

            #新增加LUN的SN\WWN信息,用于过滤 2018.12.15
            notRedundantPathDiskListTmp = []
            util.log.error(context, 'the disk dict is:' + str(LUNWWNSNDICT))
            for notRedundantPathDisk in notRedundantPathDiskList:
                notRedundantPathDiskListTmp.append(notRedundantPathDisk + '(' + LUNWWNSNDICT.get(notRedundantPathDisk, "") + ')'
                                               if LUNWWNSNDICT.get(notRedundantPathDisk, "")
                                               else notRedundantPathDisk)

            errParas.append(','.join(notRedundantPathDiskListTmp))
            return genEvalResultForMultipath(EvalResultEnum.FAILED,
                                             allPthRet,
                                             constants.NMP_NOT_PASS_TIPS,
                                             errParas, selfMultipathInfoList = selfMultiInfoList)
    except:
        errParas = [qryAllDiskPthCmd, "messageKey:" + constants.ERR_MSG_KEY_QRY_SINGLE_LUN_PATH_FAILED]
        errMsgKey = constants.RECOMMENDED_ACTIONS_NETWORK_CONNECTION
        util.log.error(context, 'Query disk path exception:' + traceback.format_exc())
        return genEvalResultForMultipath(EvalResultEnum.FAILED,
                                         allPthRet, errMsgKey, errParas, selfMultipathInfoList = selfMultiInfoList)


def getISCSISessionPath(context, diskPath, hostSessionDict):
    '''
    @summary: 解析cat / sys / class / iscsi_session / [session id] / targetname
                                      查询session ID的目前IP
    '''
    cli = context.get("SSH")
    path = ''
    try:
        qryDiskSessionPathCmd = constants.QRY_DISK_ISCSI_PASH
        sessionPathPattern = re.compile(".*:(\d+\.\d+\.\d+\.\d+)", re.I)
        hostId = diskPath.split(":")[0] if ":" in diskPath else ""
        sessionID = hostSessionDict.get("host" + hostId, "")

        if not sessionID:
            return path, ""

        allPthRet = cli.execCmdWithNoCheckResult(qryDiskSessionPathCmd % sessionID, constants.HOST_CMD_TIMEOUT)
        util.injectRet2Context(context, allPthRet, 'cmd_display_iscsi_path' + '_' + sessionID, qryDiskSessionPathCmd % sessionID)


        for line in allPthRet.splitlines():
            sessionPathInfo = sessionPathPattern.search(line)
            if sessionPathInfo:
                path = sessionPathInfo.group(1)
                util.log.info(context, 'Query session path is:' + str(path))
                return path, allPthRet

        util.log.info(context, 'Query session path is:' + str(path))
        return path, allPthRet

    except:
        util.log.error(context, 'Query session path exception:' + traceback.format_exc())
        return path, allPthRet


def getISCSIHostSessionDict(context):
    '''
    @summary: 解析ll / sys / class / iscsi_session / , 获得host和session的关系
    {"hostX":"sessionX"}
    '''
    cli = context.get("SSH")
    hostSessionDict = {}
    try:
        qryDiskIscsiSessionCmd = constants.QRY_DISK_ISCSI_SESSION
        hostSessionPattern = re.compile(".*(host\d+).*(session\d+)", re.I)

        allPthRet = cli.execCmdWithNoCheckResult(qryDiskIscsiSessionCmd, constants.HOST_CMD_TIMEOUT)
        util.injectRet2Context(context, allPthRet, 'cmd_display_iscsi_session', qryDiskIscsiSessionCmd)

        for line in allPthRet.splitlines():
            hostSessionInfo = hostSessionPattern.search(line)
            if hostSessionInfo:
                hostName = hostSessionInfo.group(1)
                sessionName = hostSessionInfo.group(2)
                if hostName not in hostSessionDict.keys():
                    hostSessionDict[hostName] = sessionName
                else:
                    continue

        util.log.info(context, 'Query host name is:' + str(hostSessionDict.keys()))
        return hostSessionDict, allPthRet

    except:
        util.log.error(context, 'Query host session exception:' + traceback.format_exc())
        return hostSessionDict, allPthRet

def parseAllDiskPth(allPthRet, tgtPortNumPthMap):
    '''
    @summary: 解析multipaht - ll命令回文，生成磁盘名称到磁盘路径的字典。
    @param allPthRet: multipaht - ll回文。
    @param tgtPortNumPthMap: TGT端口到路径的映射字典，如：{'0:0:0':'0A', '0:0:1':'0b'}。
    @return: 磁盘名称到磁盘路径的字典。如：{'dm-2': ['0c', '0d'], 'dm-11': ['0c', '0b']}
    '''
    tgtPortNumPattern = re.compile(constants.TARGET_PORT_NUM_PATTERN, re.I)
    newDiskPattern = re.compile(constants.NEW_HW_DISK_PATTERN, re.I)
    aboveStaPattern = re.compile('.+prio.+(active|enabled)', re.I)
    dmPattern = re.compile(' dm\-\d+ ', re.I)
    belowStaPattern = re.compile('ready', re.I)
    diskPathDict = {}
    lines = allPthRet.splitlines()
    maxIdx = len(lines)
    i = 0
    pthIdx = 0
    while i < maxIdx:
        diskNameMatchObj = newDiskPattern.search(lines[i])
        if diskNameMatchObj:
            diskName = diskNameMatchObj.group().split()[0].strip()
            diskPathDict[diskName] = []
            j = i + 2
            while j < maxIdx and not newDiskPattern.search(lines[j]) and j + 1 < maxIdx and diskName:
                aboveStaMatchObj = aboveStaPattern.search(lines[j])
                if aboveStaMatchObj:#找到第一个状态值后，遍历查找其下的所有正常路径。
                    pthIdx = j + 1
                    tgtPortNumMatchObj = tgtPortNumPattern.search(lines[pthIdx])
                    while tgtPortNumMatchObj:#匹配到TGT端口号.
                        pathStaMatchObj = belowStaPattern.search(lines[pthIdx])
                        if pathStaMatchObj:#状态正常
                            tgtPortNum = tgtPortNumMatchObj.group()
                            path = tgtPortNumPthMap.get(tgtPortNum)
                            if diskName in diskPathDict:
                                diskPathDict.get(diskName).append(path)
                            else:
                                diskPathDict[diskName] = [path]
                        #Find next path in next line.
                        pthIdx += 1
                        if pthIdx >= maxIdx:
                            j = pthIdx
                            break
                        tgtPortNumMatchObj = tgtPortNumPattern.search(lines[pthIdx])
                    else:#非路径行，下一行可能是状态行或者新的磁盘信息。
                        j = pthIdx
                else:
                    j += 1

                if pthIdx < maxIdx and dmPattern.search(lines[pthIdx]):
                    diskName = ""
            else:#Inner while loop end, to find a new disk.
                i = j
        else:
            i += 1
    return diskPathDict

def genEvalResultForMultipath(evalResult, cliRet, errMsgKey, paraList = None, selfMultipathInfoList = None):
    '''
    @summary: Create an evaluate result object of Java ItemEvalResult type.
    @param evalResut: Evaluate result.
    @param errMsgKey: error message key
    @param cliRet: CLI return message.
    @param paraList:Error message parameter list of string type.
    @return: item evaluate result.
    '''
    itemEvalResult = util.genEvalItemObj(Item.MULTIPATH_CHECK_ID,
                                         evalResult,
                                         cliRet, errMsgKey, paraList, selfMultipathInfoList)
    return itemEvalResult


CMD_LIST = [
    {DES: "cmd_display_multipath_device_mapper", CMD: "rpm -qa |grep device-mapper|cat"},
    {DES: "cmd_display_multipath_multipath", CMD: "multipath -ll|cat"},
    {DES: "cmd_display_multipath_version_huawei", CMD: "upadmin show version"},
    {DES: "cmd_display_multipath_path_huawei", CMD: "upadmin show vlun"},
    {DES: "cmd_display_lsscsi_path_huawei",
     CMD: "lsscsi |grep -Ei 'huawei|huasy|symantec|hs|eisoo|udsafe|marstor|sanm|anystor|sugon|netposa'|cat"},
    {DES: "cmd_display_multipath_showvlun_typeAll", CMD: "upadmin show vlun type=all"},
    {DES: "cmd_display_multipath_iscsi_startinfo", CMD: "cat /etc/iscsi/initiatorname.iscsi"},
    {DES: "cmd_display_multipath_etc_config", CMD: "cat /etc/multipath.conf"},
    {DES: "cmd_display_multipath_ultrapath_config", CMD: "upadmin show upconfig"},
]

DM_DISK_SECTOR_CMD_DICTD = [
    {DES: "cmd_display_multipath_dm_hw_sector_", CMD: "cat /sys/block/%s/queue/max_hw_sectors_kb"},
    {DES: "cmd_display_multipath_dm_sector_", CMD: "cat /sys/block/%s/queue/max_sectors_kb"},
    {DES: "cmd_display_multipath_dm_discard_max_bytes_", CMD: "cat /sys/block/%s/queue/discard_max_bytes"},
    {DES: "cmd_display_multipath_dm_discard_granularity_", CMD: "cat /sys/block/%s/queue/discard_granularity"},
    {DES: "cmd_display_multipath_dm_sg_vpd_page_0xb2_", CMD: "sg_vpd /dev/%s --page=0xb2"},
    {DES: "cmd_display_multipath_dm_sg_vpd_page_0xb0_", CMD: "sg_vpd /dev/%s --page=0xb0"},
]

DM_DISK_PATH_ID_CMDS = [
    {DES: "cmd_display_multipath_dm_provisioning_mode_cmds_",
     CMD: "cat /sys/block/%s/device/scsi_disk/%s/provisioning_mode"},
]


def cmd_execute(context):
    LinuxMultiPathInfo(context).execute()


class LinuxMultiPathInfo(BaseCmdExecute):
    def __init__(self, context):
        BaseCmdExecute.__init__(self, context)

    def execute(self):
        """
        类的执行入口
        """
        self.cmd_list = CMD_LIST
        self.execute_pure_cmd_list(cur_step=5, progress_width=50)
        dm_names, disk_path_ids = get_dm_path_ids(self.display.get("cmd_display_multipath_multipath", ""))

        self.cmd_list = []
        self.generate_relative_cmd_list(change_list_to_tuple(dm_names), DM_DISK_SECTOR_CMD_DICTD)
        self.execute_pure_cmd_list(cur_step=55, progress_width=30)

        self.cmd_list = []
        self.generate_relative_cmd_list(disk_path_ids, DM_DISK_PATH_ID_CMDS)
        self.execute_pure_cmd_list(cur_step=85, progress_width=5)


def get_dm_path_ids(dm_multipath_content):
    dm_names = []
    path_letter_id = ''
    disk_path_ids = []
    for line in dm_multipath_content.splitlines():
        if 'dm-' in line:
            dm_name = list(filter(lambda dm_item: dm_item.startswith('dm-'), line.split()))[0]
            dm_names.append(dm_name)
            path_letter_id = ''
        elif not path_letter_id and 'size=' not in line and 'status=' not in line and 'active' in line:
            path_digital_id, path_letter_id = get_path_id(line)
            if path_letter_id:
                disk_path_ids.append((path_letter_id, path_digital_id))
    return dm_names, disk_path_ids


def get_path_id(line):
    items = line.strip().split()
    for idx, item in enumerate(items):
        if re.match('\\d+:\\d+:\\d+:\\d+', item):
            return item, items[idx + 1]
    return '', ''
