# coding=utf-8
__author__ = '******'
# 获取aix主机的多路径信息
import sys
import os
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common import util
from common import constants
from hosts.sudo_utils import get_sudo_cmd
from hosts.sudo_utils import LINUX
CLI = None
LANGUAGE = None
CHECK_FAIL          =       0
CHECK_PASS          =       1
cmd_info_id = ["cmd_info_multipath_status_phypath"           ,
               "cmd_info_multipath_status_lun_info"           
               ]
            
cmd_info_desc = ["upadmin show path",
                 "upadmin show vlun id=" 
                ]

def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = context.get("lang")
    cmd_display = context.get("ret_map")
    return check_and_get_result(cmd_execute(context, cmd_display, CLI, LANGUAGE))


# 取中间一个有效值
def check_and_get_result((fun_flag, result, fun_err_msg)):
    """
    :rtype : object
    """
    return result


def cmd_execute(context, cmd_display, CLI, LANGUAGE):
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    lunArrayErrMsg = ''
    suffixStr = ""
    util.updateItemProgress(context, constants.PROG5)
    for rg in range(len(cmd_info_id)):
        if  cmd_info_id[rg]=="cmd_info_multipath_status_lun_info":
            lunOrArrayList = []
            _, version, _ = util.qryUltrapathVersion(context)
            util.updateItemProgress(context, constants.PROG20)
            if version:
                fiveVersionTup = util.getUltrapathIntVer(context, "5.01.017")
                eightVersionTup = util.getUltrapathIntVer(context, "8.01.051")
                targetVersionTup = util.getUltrapathIntVer(context, version)
                util.updateItemProgress(context, constants.PROG30)
                if targetVersionTup > eightVersionTup:
                    suffixStr = " type=all"
                    _, lunOrArrayList, _ = util.getVlunIdsManagedByUltrapath(context, False)

                elif targetVersionTup > fiveVersionTup:
                    _, lunOrArrayList, _ = util.getVlunIdsManagedByUltrapath(context, True)
                else:
                    cmd_info_desc[rg] = "upadm show lun array="
                    _, lunOrArrayList, _ = util.getArrayIdsManagedByUltrapath(context)
            util.updateItemProgress(context, constants.PROG35)
            totalSize = -1 if len(lunOrArrayList) == 0 else len(lunOrArrayList)
            prgStep = constants.PROG55 / totalSize
            curstep = constants.PROG35
            if totalSize == -1:
                util.updateItemProgress(context, constants.PROG90)
            try:
                lunArrayErrMsg =  context.get('ret_map').get('err_msg')
            except:
                util.log.error(context,"get error msg key error.")   
            if lunArrayErrMsg:
                fun_err_msg += lunArrayErrMsg
            for lunOrArray in lunOrArrayList:

                if not lunOrArray.isdigit():
                    continue

                cmd_display_temp = ''
                if not ('' == lunOrArray or None == lunOrArray):
                    cmd_display_temp = \
                        cmd_display_temp + CLI.execCmdHasLogTimout(
                            get_sudo_cmd(cmd_info_desc[rg], LINUX, context)
                            + lunOrArray + suffixStr, 60)
                else:
                    pass
                if len(cmd_display_temp) > 0:
                    cmd_display.put("cmd_display" + (cmd_info_id[rg])[8:-4] + lunOrArray, cmd_display_temp)
                else:
                    pass
                if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                    if "en" == LANGUAGE:
                        fun_err_msg += cmd_info_desc[rg] + lunOrArray + suffixStr + ":\texecute failed\r\n"
                    else:
                        fun_err_msg += cmd_info_desc[rg] + lunOrArray + suffixStr + u":\t执行失败\r\n"
                else:
                    if "en" == LANGUAGE:
                        fun_err_msg += cmd_info_desc[rg] + lunOrArray + suffixStr + ":\texecute success\r\n"
                    else:
                        fun_err_msg += cmd_info_desc[rg] + lunOrArray + suffixStr + u":\t执行成功\r\n"
                curstep += prgStep
                util.updateItemProgress(context, curstep)
        else:
            cmd_display_temp = CLI.execCmdHasLogTimout(
                get_sudo_cmd(cmd_info_desc[rg], LINUX, context), 60)
            util.updateItemProgress(context, constants.PROG15)
            cmd_display.put("cmd_display" + (cmd_info_id[rg])[8:], cmd_display_temp)
            if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                if "en" == LANGUAGE:
                    fun_err_msg += cmd_info_desc[rg] + ":\texecute failed\r\n"
                else:
                    fun_err_msg += cmd_info_desc[rg] + u":\t执行失败\r\n"
            else:
                if "en" == LANGUAGE:
                    fun_err_msg += cmd_info_desc[rg] + ":\texecute success\r\n"
                else:
                    fun_err_msg += cmd_info_desc[rg] + u":\t执行成功\r\n"
    cmd_display.put("err_msg", fun_err_msg)
    fun_flag = CHECK_PASS
    return fun_flag, cmd_display, fun_err_msg