#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.
"""
@version: SmartKit V200R006C00
@time: 2019/10/09
@file: linux_network_discovery_info.py
@function:
@modify:
"""

import sys
import os

current_absolute_path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(current_absolute_path, "..\\..")
sys.path.append(path)
from common.contentParse import cmd_execute
from common.util import log

cmd_info_id = ["cmd_info_os_system_info",
               "cmd_info_os_disk_capacity",
               "cmd_info_os_disk_partition",
               "cmd_info_os_disk_oracleasm",
               "cmd_info_os_disk_dev_sd",
               ]

cmd_info_desc = ["cat /proc/version",
                 "df -h",
                 "ls -l /dev/disk/by-id | cat",
                 "ls -l /dev/oracleasm/disks/ | cat",
                 "ls -l /dev/ | cat",
                 ]

command_stitching_id = [
    "cmd_info_os_asm_disk_%s",
    "cmd_info_os_dev_file_%s",
]
command_stitching_desc = [
    "hexdump -n 512 -C /dev/oracleasm/disks/%s | head",
    "hexdump -n 512 -C /dev/%s | head",
]
query_command = [
    "ls -l /dev/oracleasm/disks/ | cat | awk -F ' ' '{print $NF}'",
    "ls -l /dev/| grep ^b | cat | awk -F ' ' '{print $NF}'",
]


def execute(context):
    """
    :param context:
    :return:
    """

    cli = context.get("SSH")
    lan = context.get("lang")
    cmd_display = context.get("ret_map")

    traversal_command_stitch(cli, context)
    cmd_info_dic = dict(zip(cmd_info_id, cmd_info_desc))
    cmd_execute(cmd_display, cli, lan, context, cmd_info_dic)
    return


def traversal_command_stitch(cli, context):
    """
    Dependency command stitching
    :param cli:
    :param context:
    :return:
    """
    for i in range(0, len(query_command)):
        cmd_ret = cli.execCmdWithNoCheckResult(query_command[i], 60)
        parameter_list = cmd_ret.splitlines()
        log.info(context, "parameter_list:" + str(parameter_list))
        for parameter in parameter_list[1:-1]:
            if parameter and "ls:" not in parameter:
                cmd_info_desc.append(command_stitching_desc[i] % parameter)
                cmd_info_id.append(command_stitching_id[i] % parameter)
