# -*- coding: UTF-8 -*-
import re
import sys
import traceback
import os
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common import util
from common import constants
from common import contentParse
from cbb.frame.base.exception import UnCheckException


PASS = 'PASS'
NOTPASS = 'NOTPASS'
NOCHECK = 'CANNOTEVAL'
CHECK_FAIL = 0
CHECK_PASS = 1


def execute(context):
    """
    Linux系统NVMe-oF连接配置信息
    :param context:
    :return:
    """
    global LOGGER
    LOGGER = context.get("Logger")
    cmd_display = context.get("ret_map")
    err_msg = ''
    cli_ret_list = list()
    nqn_list = list()
    try:
        CLI = context.get("SSH")
        global LANGUAGE
        LANGUAGE = context.get("lang")
        LOGGER.info("start to query linux nvme infomation")
        util.updateItemProgress(context, constants.PROG15)
        # 获取linux 设备的nqn列表，如果为空或者命令未找到则通过
        flag, nqn_list = get_host_nqn_list(context,
                                           cli_ret_list, nqn_list)
        if flag is True:
            save_host_nvme(cmd_display, PASS, "\n".join(cli_ret_list),
                           nqn_list)
            return CHECK_PASS, cmd_display, err_msg
        util.updateItemProgress(context, constants.PROG55)
        # 获取主机nvme-snsd服务的信息
        flag = check_nvme_snsd_service(context, cli_ret_list)

        # 如果服务为开启（状态为Active: active），则不管是否与存储关联都为通过
        if flag is True:
            save_host_nvme(cmd_display, PASS, "\n".join(cli_ret_list),
                           nqn_list)
            return CHECK_PASS, cmd_display, err_msg
        util.updateItemProgress(context, constants.PROG75)
        flag = check_nvme_fabrics_persistent_service(context, cli_ret_list)
        # 如果服务为开启（状态为Active: active），则不管是否与存储关联都为通过
        if flag is True:
            save_host_nvme(cmd_display, PASS, "\n".join(cli_ret_list),
                           nqn_list)
            return CHECK_PASS, cmd_display, err_msg
        util.updateItemProgress(context, constants.PROG95)
        save_host_nvme(cmd_display, NOTPASS, "\n".join(cli_ret_list),
                       nqn_list)
        return CHECK_PASS, cmd_display, err_msg
    except UnCheckException as un:
        LOGGER.error("UnCheckException, errMsg: {}".format(un.errorMsg))
        save_host_nvme(cmd_display, NOCHECK, "\n".join(cli_ret_list), nqn_list)
        return CHECK_FAIL, cmd_display, un.errorMsg
    except Exception as e:
        msg = traceback.format_exc()
        LOGGER.error("nvme info has exception {},{}".format(msg, e))
        save_host_nvme(cmd_display, NOCHECK, "\n".join(cli_ret_list), nqn_list)
        return CHECK_FAIL, cmd_display, err_msg


def exec_and_build_cmd(cmd, context):
    """
    执行并构建命令
    :param cmd:执行的命令
    :param cli:
    :param LANGUAGE:
    :param cmd_display:
    :param err_msg:
    :return:
    """
    cli = context.get("SSH")
    cmd_display = context.get("ret_map")
    LANGUAGE = context.get("lang")
    cli_ret = cli.execCmdHasLogTimout(cmd, 60)
    flag, err_msg = util.error_msg_handler(cli_ret, cmd,
                                           LANGUAGE)
    err_msgs = cmd_display.get("err_msg", "")
    cmd_display.put("err_msg", err_msgs + err_msg)
    cmd_display.put("cmd_display" + cmd, cli_ret)
    return flag, cli_ret, err_msg


def get_host_nqn_list(context, cli_ret_list, nqn_list):
    """
    获取主机nqn list
    :param CLI: cli链接
    :param LANGUAGE: 语言
    :param cmd_display: 上下文
    :return: 是否直接通过，
    """
    flag, cli_ret, err_msg = exec_and_build_cmd('cat /etc/nvme/hostnqn|cat',
                                                context)
    cli_ret_list.append(cli_ret)

    if flag is not True:
        raise UnCheckException(err_msg)
    if not cli_ret:
        return True, nqn_list

    for line in cli_ret.splitlines():
        line = line.strip()
        if line.startswith("nqn."):
            nqn_list.append(line)

    if len(nqn_list) == 0:
        return True, nqn_list
    return False, nqn_list


def check_nvme_snsd_service(context, cli_ret_list):
    """
    检查主机的nvme-snsd服务状态
    :param CLI:上下文
    :param LANGUAGE:
    :param cmd_display:
    :param cli_ret_list:
    :return:
    """
    return check_nvme_service('systemctl status nvme-snsd|cat', context,
                              cli_ret_list)


def check_nvme_fabrics_persistent_service(context, cli_ret_list):
    """
    检查主机的nvme-snsd服务状态
    :param CLI:cli链接
    :param LANGUAGE:语言
    :param cmd_display: 上下文
    :param cli_ret_list: 命令集合
    :return:
    """
    return check_nvme_service(
        'systemctl status nvme_fabrics_persistent.timer|cat', context,
        cli_ret_list)


def check_nvme_service(cmd, context, cli_ret_list):
    """
    检查主机的nvme服务状态
    :param CLI:上下文
    :param LANGUAGE:
    :param cmd_display:
    :param cli_ret_list:
    :return:
    """
    flag, cli_ret, err_msg = exec_and_build_cmd(cmd, context)
    cli_ret_list.append(cli_ret)
    if flag is not True:
        raise UnCheckException(err_msg)
    if 'Active: active' in cli_ret:
        return True
    return False


def save_host_nvme(cmd_display, access_status, cli_ret, nqn_list):
    """
    保存信息到foreEval
    :param cmd_display: 上下文
    :param access_status: 状态
    :param cli_rets: 回显集合
    :return:
    """
    json_object = dict()
    json_object["access_status"] = access_status
    cli_rets = ''
    try:
        cli_rets = unicode(cli_ret)
    except Exception as e:
        cli_rets = str(cli_ret)
        LOGGER.error("encode error" + cli_rets)
        LOGGER.error("encode error exception:" + str(e))
    json_object["nvme_initiator"] = ','.join(nqn_list).encode('utf-8')
    json_object["cliRets"] = cli_rets.encode('utf-8')
    json_object["err_meg"] = cmd_display.get("err_meg", "")
    contentParse.setCmdRet4Eval(cmd_display, str(json_object),
                                "hostNvmeInfo")


def check_command_is_not_found(cli_ret):
    """
    判断是否命令不存在
    :param cli_ret: 需要解析的回文
    :return: 是否不存在
    """
    if 'not found' in cli_ret or \
            'not-found' in cli_ret or 'not be found' in cli_ret:
        return True
    return False


