# coding=utf-8
__author__ = '******'
# 获取linux主机的一些基础信息:名称、版本、CPU、内存等.
import re
import sys
import os

path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common import util
from common import constants
from hosts.sudo_utils import get_sudo_cmd
from hosts.sudo_utils import get_sudo_cmd_special
from hosts.sudo_utils import LINUX

CLI = None
LANGUAGE = None
CHECK_FAIL = 0
CHECK_PASS = 1
cmd_info_id = ["cmd_info_os_basic_uname",
               "cmd_info_os_basic_issue",
               "cmd_info_os_basic_release",
               "cmd_info_os_basic_cpu",
               "cmd_info_os_basic_mem",
               "cmd_info_os_basic_date",
               "cmd_info_os_basic_manufacturer",
               "cmd_info_os_basic_arch",
               "cmd_info_os_ifconfig",
               "cmd_info_os_route",
               "cmd_info_os_hosts",
               "cmd_info_os_basic_configinfo",
               "cmd_info_os_rules",
               "cmd_info_os_oracleasm_listdisks",
               "cmd_info_os_sysconfig_oracleasm"
               ]

cmd_info_desc = ["uname -a",
                 "cat /etc/issue",
                 "cat /etc/*-release",
                 "cat /proc/cpuinfo",
                 "cat /proc/meminfo",
                 "date",
                 "dmidecode -s system-manufacturer",
                 "arch",
                 "ifconfig -a",
                 "netstat -rn",
                 "cat /etc/hosts",
                 "dmidecode -q",
                 "ls /etc/udev/rules.d/*rules|awk '{print $1}'",
                 # 9月19日新增,
                 "oracleasm listdisks |xargs oracleasm querydisk -p",
                 # 9月19日新增
                 "cat /etc/sysconfig/oracleasm"]


def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = context.get("lang")
    cmd_display = context.get("ret_map")
    return check_and_get_result(
        cmd_execute(cmd_display, CLI, LANGUAGE, context))


# 取中间一个有效值
def check_and_get_result((fun_flag, result, fun_err_msg)):
    """
    :rtype : object
    """
    return result


def cmd_execute(cmd_display, CLI, LANGUAGE, context):
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    cmd_display_temp = ''
    util.updateItemProgress(context, constants.PROG5)
    prgStep = constants.PROG80 / len(cmd_info_id)
    curstep = constants.PROG5
    util.updateItemProgress(context, curstep)
    for rg in range(len(cmd_info_id)):
        if 'cmd_info_os_rules' == cmd_info_id[rg]:
            cmd_display_grep = CLI.execCmdHasLogTimout(
                'ls -l /etc/udev/rules.d/*rules|wc -l', 60)
            cmd_display_grep_splielines = cmd_display_grep.splitlines()
            if len(cmd_display_grep_splielines) > 1:
                cmd_display_grep = cmd_display_grep_splielines[1].strip()
                if cmd_display_grep == '0':
                    cmd_display_temp = CLI.execCmdHasLogTimout(
                        cmd_info_desc[rg], 60)
                else:
                    cmd_display_temp = CLI.execCmdHasLogTimout(
                        cmd_info_desc[rg], 60)
                    file_list = cmd_display_temp.splitlines()
                    if context.get("SUDO"):
                        cmd = context.get("SUDO") + "cat "
                    else:
                        cmd = "cat "
                    for index in range(len(file_list)):
                        if cmd_info_desc[rg] in file_list[index]:
                            continue
                        cmd_display_temp += CLI.execCmdHasLogTimout(
                            cmd + file_list[index], 60)
            cmd_display.put("cmd_display" +
                            (cmd_info_id[rg])[8:], cmd_display_temp)
            fun_err_msg += deal_fun_err_msg(cmd_display_temp,
                                            cmd_info_desc[rg], fun_err_msg)
        else:
            cmd = get_sudo_cmd(
                get_sudo_cmd_special(cmd_info_desc[rg], LINUX, context),
                LINUX, context)
            cmd_display_temp = CLI.execCmdHasLogTimout(cmd, 60)
        curstep += prgStep
        util.updateItemProgress(context, curstep)
        cmd_display.put("cmd_display" + (cmd_info_id[rg])[8:],
                        cmd_display_temp)
        fun_err_msg += deal_fun_err_msg(cmd_display_temp, cmd_info_desc[rg],
                                        fun_err_msg)

    cmd_display.put("err_msg", fun_err_msg)
    fun_flag = CHECK_PASS
    return fun_flag, cmd_display, fun_err_msg


def deal_fun_err_msg(cmd_display_temp, cmd, fun_err_msg):
    if cmd_display_temp is None or '' == cmd_display_temp or \
            cmd_display_temp.find(
                'TOOLKIT_SEND_CMD_TIME_OUT') > 0 or \
            cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
        if "en" == LANGUAGE:
            fun_err_msg = cmd + ":\texecute failed\r\n"
        else:
            fun_err_msg = cmd + u":\t执行失败\r\n"
    else:
        if "en" == LANGUAGE:
            fun_err_msg = cmd + ":\texecute success\r\n"
        else:
            fun_err_msg = cmd + u":\t执行成功\r\n"
    return fun_err_msg
