# -*- coding: UTF-8 -*-
import re
import sys
import os

path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common import constants
from common import util
from hosts.sudo_utils import get_sudo_cmd
from hosts.sudo_utils import LINUX

cmd_info_id = ["cmd_info_hba_card_iSCSI_node",
               "cmd_info_os_basic_runlevel",
               "cmd_info_os_basic_ip",
               "cmd_info_multipath_config",
               "cmd_info_multipath_ibmsdddatapath",
               "cmd_info_oracle_row_device",
               "cmd_info_oracle_rc_local",
               "cmd_info_oracle_asm_disk",
               "cmd_info_oracle_asm",
               "cmd_info_oracle_udev_raw_rule",
               ]

cmd_info_desc = ["iscsiadm -m node",
                 "runlevel",
                 "ip addr",
                 "cat /etc/multipath.conf",
                 "rpm -qa|grep -i IBMsdd or /opt/IBMsdd/bin/"
                 "datapath query version",
                 "cat /etc/sysconfig/rawdevices",
                 "cat /etc/rc.d/rc.local",
                 "/etc/init.d/oracleasm listdisks",
                 "cat /etc/sysconfig/oracleasm",
                 "cat /etc/udev/rules.d/*",
                 ]

linux_cmd_id = [
    "cmd_info_multipath_version_emc",
    "cmd_info_multipath_path_emc",
    "cmd_info_multipath_path_ibm",
    "cmd_info_multipath_sys_hds",
    "cmd_info_multipath_sys_hds_with_env",
    "cmd_info_multipath_lu_hds",
    "cmd_info_multipath_lu_hds_with_env",
    "cmd_info_multipath_path_hds",
    "cmd_info_multipath_path_hds_with_env",
]

linux_cmd_desc = [
    "powermt version",
    "powermt display dev=all",
    "pcmpath query device",
    "dlnkmgr view -sys",
    "/opt/DynamicLinkManager/bin/dlnkmgr view -sys",
    "dlnkmgr view  -lu",
    "/opt/DynamicLinkManager/bin/dlnkmgr view  -lu",
    "dlnkmgr view -path",
    "/opt/DynamicLinkManager/bin/dlnkmgr view -path",
]


def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    CLI = context.get("SSH")
    LANGUAGE = context.get("lang")
    cmd_display = context.get("ret_map")
    if not is_fusionSphere_os(context):
        global cmd_info_id, cmd_info_desc
        cmd_info_id = cmd_info_id + linux_cmd_id
        cmd_info_desc = cmd_info_desc + linux_cmd_desc
    return cmd_execute(context, cmd_display, CLI, LANGUAGE)


def cmd_execute(context, cmd_display, CLI, LANGUAGE):
    tempStep = constants.PROG90 / len(cmd_info_id)
    curStep = tempStep
    fun_err_msg = ''

    for rg in range(len(cmd_info_id)):
        curStep += tempStep
        util.updateItemProgress(context, curStep)
        cmd_display_temp = ''
        if 'cat /etc/udev/rules.d/*' == cmd_info_desc[rg]:
            cmd_display_grep = CLI.execCmdHasLogTimout(
                'ls -l /etc/udev/rules.d|wc -l', 60)
            util.log.info(context,
                          "Number of files in the directory "
                          "/etc/udev/rules.d : " + cmd_display_grep)
            cmd_display_grep_splielines = cmd_display_grep.splitlines()
            if len(cmd_display_grep_splielines) > 1:
                cmd_display_grep = cmd_display_grep_splielines[1].strip()
                if cmd_display_grep == '0':
                    cmd_display_temp = CLI.execCmdHasLogTimout(
                        cmd_info_desc[rg], 60)
                else:
                    cmd_display_temp = CLI.execCmdHasLogTimout(
                        "ls /etc/udev/rules.d|awk '{print $1}'", 60)
                    file_list = cmd_display_temp.splitlines()[1:]
                    cmd_display_temp = ''
                    for index in range(len(file_list)):
                        cmd_display_temp += CLI.execCmdNoLogTimout(
                            get_sudo_cmd("cat /etc/udev/rules.d/", LINUX,
                                         context) + file_list[index], 60)
        else:
            cmd_display_temp = CLI.execCmdNoLogTimout(
                get_sudo_cmd(cmd_info_desc[rg], LINUX, context), 60)
        cmd_display.put("cmd_display" + (cmd_info_id[rg])[8:],
                        cmd_display_temp)

        if cmd_display_temp is None or '' == cmd_display_temp or \
                cmd_display_temp.find(
                    'TOOLKIT_SEND_CMD_TIME_OUT') > 0 or \
                cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
            if "en" == LANGUAGE:
                fun_err_msg += cmd_info_desc[rg] + ":\texecute failed\r\n"
            else:
                fun_err_msg += cmd_info_desc[rg] + u":\t执行失败\r\n"
        else:
            if "en" == LANGUAGE:
                fun_err_msg += cmd_info_desc[rg] + ":\texecute success\r\n"
            else:
                fun_err_msg += cmd_info_desc[rg] + u":\t执行成功\r\n"
    cmd_display.put("err_msg", fun_err_msg)
    return cmd_display


def is_fusionSphere_os(context):
    contextDevType = context.get(constants.DEV_LEVEL2_TYPE).lower().strip()

    if constants.OS_TYPE_FUSIONSPHERE_LOW.lower().strip() == contextDevType:
        util.log.info(context, "this item of device is FusionSphere.")
        return True
    else:
        return False
