# coding=utf-8
__author__ = '******'
# 获取linux虚拟机信息
import re
import sys
import os 
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common import constants
from common import util
CLI = None
LANGUAGE = None
CHECK_FAIL          =       0
CHECK_PASS          =       1

cmd_info_id = [
               "cmd_info_pool-list",
               "cmd_info_pool-info",
               "cmd_info_vol-list",
               "cmd_info_nodeinfo",
               
               "cmd_info_list",
               "cmd_info_domid",
               "cmd_info_domname",
               "cmd_info_domuuid",
               
               "cmd_info_dominfo",
               "cmd_info_vcpuinfo",
               "cmd_info_net-list",
               "cmd_info_domblkstat",
               
               "cmd_info_domifstat",
               "cmd_info_dumpxml",
               "cmd_info_define"
               ]
               
             
               
            
cmd_info_desc = [
                 "virsh pool-list --all",
                 "virsh pool-info guest_images_fs",
                 "virsh vol-list guest_images_disk",
                 "virsh nodeinfo",
                 
                 "virsh list --all",
                 "virsh domid",
                 "virsh domname",
                 "virsh domuuid",
                 
                 "virsh dominfo {domain-id, domain-name or domain-uuid}",
                 "virsh vcpuinfo {domain-id, domain-name or domain-uuid}",
                 "virsh net-list",
                 "virsh domblkstat GuestName block-device",
                 
                 "virsh domifstat GuestName interface-device snapshot-info domain",
                 "virsh dumpxml {domain-id, domain-name or domain-uuid}",
                 "virsh define GuestName"
                 ]

def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = context.get("lang")
    cmd_display = context.get("ret_map")
    return check_and_get_result(cmd_execute(context, cmd_display, CLI, LANGUAGE))


# 取中间一个有效值
def check_and_get_result((fun_flag, result, fun_err_msg)):
    """
    :rtype : object
    """
    return result


def cmd_execute(context, cmd_display, CLI, LANGUAGE):
    tempStep = constants.PROG90 / len(cmd_info_id)
    curStep = tempStep
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    for rg in range(len(cmd_info_id)):
        curStep += tempStep
        util.updateItemProgress(context, curStep)
        cmd_display_temp = CLI.execCmdHasLogTimout(cmd_info_desc[rg],60)
        cmd_display.put("cmd_display"+(cmd_info_id[rg])[8:], cmd_display_temp)
        if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
            if "en"==LANGUAGE:
                fun_err_msg        +=cmd_info_desc[rg] + ":\texecute failed\r\n"
            else:
                fun_err_msg        +=cmd_info_desc[rg] + u":\t执行失败\r\n"
        else:
            if "en"==LANGUAGE:
                fun_err_msg        +=cmd_info_desc[rg] + ":\texecute success\r\n"
            else:
                fun_err_msg        +=cmd_info_desc[rg] + u":\t执行成功\r\n"
    cmd_display.put("err_msg", fun_err_msg)
    fun_flag = CHECK_PASS
    return fun_flag, cmd_display, fun_err_msg