# coding=utf-8
__author__ = '******'
# \u83b7\u53d6linux\u4e3b\u673a:zimbra\u4fe1\u606f 
import re
import sys
import os 
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common import constants
from common import util
CLI = None
LANGUAGE = None
CHECK_FAIL          =       0
CHECK_PASS          =       1
cmd_info_id = [
               "linux_zimbra_mail_info_rpm_-qa_|grep_-i_ zimbra",
               "linux_zimbra_mail_info_cat_/opt/zimbra/.install_history",
			   "linux_zimbra_mail_info_cat_/opt/zimbra/config.*",
			   "linux_zimbra_mail_info_su_- zimbra",
			   "linux_zimbra_mail_info_zmcontrol_status",
			   "linux_zimbra_mail_info_zmlocalconfig_-s"
              ]
            
cmd_info_desc = [
                 "rpm -qa |grep -i zimbra",
                 "cat /opt/zimbra/.install_history",
                 "cat /opt/zimbra/config.*",
                 "su - zimbra",
                 "zmcontrol status",
                 "zmlocalconfig -s"
                 ]


def execute(context):
    """
    Function name      : execute
    Function describe  : \u5916\u90e8\u63a5\u5165
    Input              : context
    Return             : cmd display
    """
    # \u7ed9\u5168\u5c40\u53d8\u91cf\u8d4b\u521d\u59cb\u503c\uff0c\u6309\u7167\u8981\u6c42\u4f20\u9012\u4e0a\u4e0b\u6587\u8fdb\u53bb\u3002
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = context.get("lang")
    cmd_display = context.get("ret_map")
    return check_and_get_result(cmd_execute(context, cmd_display, CLI, LANGUAGE))


# \u53d6\u4e2d\u95f4\u4e00\u4e2a\u6709\u6548\u503c
def check_and_get_result((fun_flag, result, fun_err_msg)):
    """
    :rtype : object
    """
    return result


def cmd_execute(context, cmd_display, CLI, LANGUAGE):
    tempStep = constants.PROG90 / len(cmd_info_id)
    curStep = tempStep
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    for rg in range(len(cmd_info_id)):
        curStep += tempStep
        util.updateItemProgress(context, curStep)
        cmd_display_temp = CLI.execCmdHasLogTimout(cmd_info_desc[rg],60)
        cmd_display.put("cmd_display"+(cmd_info_id[rg])[8:], cmd_display_temp)
        if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
            if "en"==LANGUAGE:
                fun_err_msg        +=cmd_info_desc[rg] + ":\texecute failed\r\n"
            else:
                fun_err_msg        +=cmd_info_desc[rg] + u":\t\u6267\u884c\u5931\u8d25\r\n"
        else:
            if "en"==LANGUAGE:
                fun_err_msg        +=cmd_info_desc[rg] + ":\texecute success\r\n"
            else:
                fun_err_msg        +=cmd_info_desc[rg] + u":\t\u6267\u884c\u6210\u529f\r\n"
    cmd_display.put("err_msg", fun_err_msg)
    fun_flag = CHECK_PASS
    return fun_flag, cmd_display, fun_err_msg
