# --*-- coding:utf-8 --*--
import sys
import os
import json
import re
import traceback

from hosts.linux.migration import linux_lvm_parser

reload(sys)
sys.setdefaultencoding('utf-8')
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..\\..")
sys.path.append(path)


def execute(context):
    global logger
    logger = context.get("Logger")
    result = get_result(context)
    ret_map = context.get("map")
    ret_map.put("data", json.dumps(result))
    return context


def get_result(context):
    """
    获取vg相关数据
    :param context:上下文
    :return: vg数据
    """
    result = {"host_ip": context.get("ip"), "lvm_conf": get_lvm_conf(context)}
    try:
        result["vg_info_list"] = get_volume_list(context)
    except Exception:
        logger.error("parse error: %s" % str(traceback.format_exc()))
        result["vg_info_list"] = [get_null_result(context)]
    return result


def get_volume_list(context):
    """
    获取vg相关数据
    :param context:上下文
    :return: vg数据
    """

    vg_list = get_vg_info(context)
    # 没有vg数据，返回一个空格式
    if not vg_list:
        return [get_null_result(context)]

    fs_list = get_filesystem_info(context)
    fstab_list = get_fstab_filesystem_info(context)
    discard_fs_set = get_discard_fs_set(context)

    # 循环vg列表，组装数据
    vg_info_list = []
    for vg in vg_list:
        vg_info_list.append({
            "vg_name": (vg.get("vg_name", "")),
            "vg_size": vg.get("vg_size", ""),
            "pvs": vg.get("pvs", []),
            "lvs": assemble_lvs(discard_fs_set, fs_list, fstab_list, vg, vg.get("vg_name", ""))
        })
    return vg_info_list


def assemble_lvs(discard_fs_set, fs_list, fstab_list, vg, vg_name):
    lvs = []
    for lv in vg.get("lvs", []):
        one_lv = {
            "lv_name": lv.get("lv_name", ""),
            "lv_size": lv.get("lv_size", "")
        }
        # 下面三个方法中会用到 lv_name 的值，在调用下面三个方法前需要先填 lv_name 的值
        fill_filesystem_info(one_lv, vg_name, fs_list)
        fill_fstab_filesystem_info(one_lv, vg_name, fstab_list)
        fill_discard_info(discard_fs_set, one_lv, vg_name)
        lvs.append(one_lv)
    return lvs


def fill_discard_info(discard_fs_set, one_lv, vg_name):
    try:
        for discard_fs in discard_fs_set:
            if match_filesystem_and_lv(discard_fs, vg_name, one_lv["lv_name"]):
                one_lv["discard"] = "True"
                break
        else:
            one_lv["discard"] = "False"
    except KeyError:
        one_lv["discard"] = "False"


def generate_path_style_file_system(vg_name, lv_name):
    return "/dev/{}/{}".format(vg_name, lv_name)


def generate_mapper_style_file_system(vg_name, lv_name):
    return "/dev/mapper/{}-{}".format(vg_name, lv_name)


def get_fstab_filesystem_info(context):
    """
       获取fatab filesystem 数据
       :param context: 上下文
       :return: fatab filesystem 数据
       """
    context["command"] = "cat /etc/fstab"
    fstab_filesystem_info = get_return_from_txt(context)
    return linux_lvm_parser.parse_fs_filesystem_from_fstab(fstab_filesystem_info)


def fill_filesystem_info(one_lv, vg_name, fs_list):
    """
    组装filesystem，filesystem必须包含有 lvm_lv_name、 vg_name
    :param one_lv: one_lv
    :param vg_name: vg_name
    :param fs_list: fs_list
    :return: one_lv
    """
    for fs in fs_list:
        if match_filesystem_and_lv(fs["filesystem"], vg_name, one_lv["lv_name"]):
            one_lv["filesystem"] = fs["filesystem"]
            one_lv["fs_total_size"] = fs["fs_total_size"]
            one_lv["fs_used_size"] = fs["fs_used_size"]
            one_lv["fs_type"] = fs["fs_type"]
            one_lv["fs_mount_point"] = fs["fs_mount_point"]
            break
    else:
        one_lv["filesystem"] = ""
        one_lv["fs_total_size"] = ""
        one_lv["fs_used_size"] = ""
        one_lv["fs_type"] = ""
        one_lv["fs_mount_point"] = ""


def fill_fstab_filesystem_info(one_lv, vg_name, fstab_list):
    """
    组装fstab_filesystem，fstab_filesystem必须包含有 lvm_lv_name、 vg_name
    :param one_lv: one_lv
    :param vg_name:vg_name
    :param fstab_list: fstab_list
    :return: one_lv
    """
    for fstab in fstab_list:
        if match_filesystem_and_lv(fstab["fstab_filesystem"], vg_name, one_lv["lv_name"]):
            one_lv["fstab_filesystem"] = fstab["fstab_filesystem"]
            one_lv["fstab_mount_point"] = fstab["fstab_mount_point"]
            one_lv["fstab_fs_type"] = fstab["fstab_fs_type"]
            break
    else:
        one_lv["fstab_filesystem"] = ""
        one_lv["fstab_mount_point"] = ""
        one_lv["fstab_fs_type"] = ""


def match_filesystem_and_lv(filesystem, vg_name, lv_name):
    return "{}-{}".format(vg_name, lv_name) == get_simple_filesystem(filesystem) \
        or generate_mapper_style_file_system(vg_name, lv_name) == filesystem \
        or generate_path_style_file_system(vg_name, lv_name) == filesystem \
        or generate_mapper_style_file_system(vg_name.replace("-", "--"), lv_name.replace("-", "--")) == filesystem \
        or generate_path_style_file_system(vg_name.replace("-", "--"), lv_name.replace("-", "--")) == filesystem


def get_simple_filesystem(filesystem):
    if "/" in filesystem:
        return filesystem.split("/")[-1]
    return filesystem


def get_vg_name_size(context):
    """
    获取vg及其size
    :param context: context
    :return: vg及其size
    """
    context["command"] = "vgs|awk '{print $1,$6}'"
    vg_info = get_return_from_txt(context)
    flag = False
    vgs = []
    for line in vg_info:
        if "VG" in line and "VSize" in line:
            flag = True
            continue
        line_split = line.split()
        if flag and len(line_split) == 2:
            # 特殊处理 ，有的移< 开头，例如：<59.00g
            vgs.append({
                "vg_name": line_split[0],
                "vg_size": re.split("^\\D+", line_split[1])[-1]})
    return vgs


def get_lv_name_size(context):
    """
    获取lv及其size
    :param context: context
    :return: lv及其size
    """
    context["command"] = "lvs|awk '{print $1,$2,$4}'"
    lv_info = get_return_from_txt(context)
    flag = False
    lvs = []
    for line in lv_info:
        if "LV" in line and "LSize" in line:
            flag = True
            continue
        line_split = line.split()
        if flag and len(line_split) == 3:
            lvs.append({
                "lv_name": line_split[0],
                "vg_name": line_split[1],
                # 特殊处理 ，有的移< 开头，例如：<59.00g
                "lv_size": re.split("^\\D+", line_split[2])[-1]})
    return lvs


def get_pv_name_size(context):
    """
    获取pv及其size
    :param context: context
    :return: pv及其size
    """
    context["command"] = "pvs|awk '{print $1,$2,$5}'"
    pv_info = get_return_from_txt(context)
    flag = False
    pvs = []
    for line in pv_info:
        if "PV" in line and "PSize" in line:
            flag = True
            continue
        line_split = line.split()
        if flag and len(line_split) == 3:
            pvs.append({
                "pv_name": line_split[0],
                "vg_name": line_split[1],
                # 特殊处理 ，有的移< 开头，例如：<59.00g
                "pv_size": re.split("^\\D+", line_split[2])[-1]
            })
    return pvs


def get_vg_info(context):
    """
    获取vg 的相关数据
    :param context:  context
    :return: vg 数据
    """
    vgs = get_vg_name_size(context)
    lvs = get_lv_name_size(context)
    pvs = get_pv_name_size(context)
    vg_list = []
    for vg in vgs:
        vg_name = vg.get("vg_name", "")
        vg_list.append({
            "vg_name": vg_name,
            "vg_size": vg.get("vg_size", ""),
            "lvs": filter_current_vg_lv_names(lvs, vg_name),
            "pvs": filter_current_vg_pvs(pvs, vg_name)})
    return vg_list


def filter_current_vg_lv_names(lvs, current_vg_name):
    return [lv for lv in lvs if lv.get("vg_name", "") == current_vg_name]


def filter_current_vg_pvs(pvs, current_vg_name):
    current_vg_pvs = [{
        "pv_name": pv.get("pv_name", ""),
        "pv_pvid": "",
        "pv_size": pv.get("pv_size", "")}
        for pv in pvs if pv.get("vg_name", "") == current_vg_name]
    if current_vg_pvs:
        return current_vg_pvs
    else:
        return [{"pv_name": "", "pv_size": "", "pv_pvid": ""}]


def get_filesystem_info(context):
    """
    获取filesystem 数据
    :param context: 上下文
    :return: filesystem数据
    """
    context["command"] = "df -TH"
    file_system_info = get_return_from_txt(context)
    return linux_lvm_parser.parse_filesystem_from_df_command(file_system_info)


def get_lvm_conf(context):
    """
    解析lvm.conf信息
    :param context: 上下文
    :return: conf结果
    """
    context["command"] = "cat /etc/lvm/lvm.conf"
    lvmconf_info = get_return_from_txt(context)
    filter_list = []
    for line in lvmconf_info:
        if line.strip().startswith("#"):
            continue
        if "filter" in line.lower() or "gloal_filter" in line.lower():
            filter_list.append(line)
    if not filter_list:
        return ""
    return ", ".join(filter_list)


def get_null_result(context):
    """
    空数据格式
    :param context: 上下文
    :return: 空数据
    """
    return {
        "host_ip": context.get("ip"),
        "vg_name": "", "vg_size": "",
        "pvs": [{"pv_name": "", "pv_size": "", "pv_pvid": ""}],
        "lvs": [{
            "lv_name": "",
            "lv_size": "",
            "filesystem": "",
            "fs_total_size": "",
            "fs_used_size": "",
            "fs_type": "",
            "fs_mount_point": "",
            "fstab_filesystem": "",
            "fstab_mount_point": "",
            "fstab_fs_type": "",
            "discard": "False"
        }]}


def get_discard_fs_set(context):
    discard_fs_set = set()
    discard_fs_set.update(get_discard_fs_from_mount(context))
    discard_fs_set.update(get_discard_fs_from_fs_tab(context))
    discard_fs_set.update(get_discard_fs_from_rc_local(context))
    return discard_fs_set


def get_discard_fs_from_fs_tab(context):
    context["command"] = "cat /etc/fstab"
    return linux_lvm_parser.parse_discard_fs_from_fstab(get_return_from_txt(context))


def get_discard_fs_from_rc_local(context):
    context["command"] = "cat /etc/rc.d/rc.local"
    return linux_lvm_parser.parse_discard_fs_from_rc_local(get_return_from_txt(context))


def get_discard_fs_from_mount(context):
    context["command"] = "cmd_display_logic_mount"
    return_lines = get_return_from_txt(context)
    if return_lines:
        return linux_lvm_parser.parse_discard_fs_from_mount(return_lines[1:])
    else:
        return linux_lvm_parser.parse_discard_fs_from_mount([])


def get_return_from_txt(context):
    from common import contentParse
    return contentParse.get_return_from_txt(context)
