# --*-- coding:utf-8 --*--
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import json

from hosts.common.migra_summary_util import get_ultra_multi, get_power_multi, get_hdlm_multi, get_dm_multi


def execute(context):
    result = get_result(context)
    ret_map = context.get("map")
    ret_map.put("data", json.dumps(result))
    return context


def get_result(context):
    """
    获取数据结果
    :param context: 上下文
    :return: 数据结果
    """

    result = {}
    host_ip = context.get("ip")
    result["host_ip"] = host_ip
    result["multipaths"] = get_multipaths(context)
    return result


def get_multipaths(context):
    """
    获取多路径信息
    :param context: 上下文
    :return: 多路径信息
    """
    result = []

    dm_flag, dm_multi = get_dm_multi(context)
    power_flag, power_multi = get_power_multi(context, "linux")
    ultra_flag, ultra_multi = get_ultra_multi(context, "linux")
    hdlm_flag, hdlm_multi = get_hdlm_multi(context, "linux")
    if dm_flag:
        result.append(dm_multi)
    if power_flag:
        result.append(power_multi)
    if ultra_flag:
        result.append(ultra_multi)
    if hdlm_flag:
        result.append(hdlm_multi)
    if not result:
        null_mlti = get_null_multi()
        result.append(null_mlti)
    return result


def get_null_multi():
    """
    生成空数据
    :return: 空数据
    """
    result = {}
    result["multipath_type"] = ""
    result["version"] = ""

    disk_list = []
    one_disk = {}
    one_disk["disk_name"] = ""
    one_disk["lun_size"] = ""
    one_disk["lun_wwn"] = ""
    one_disk["vendor"] = ""
    one_disk["product"] = ""
    disk_list.append(one_disk)
    result["disk_list"] = disk_list
    return result
