# --*-- coding:utf-8 --*--
import sys
import os
import json
import traceback

reload(sys)
sys.setdefaultencoding('utf-8')
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..\\..")
sys.path.append(path)
from common.contentParse import get_return_from_txt


def execute(context):
    logger = context.get("Logger")
    result = {}
    result["host_ip"] = context.get("ip")
    try:
        os_type, os_version = get_os_type_version(context)
    except Exception:
        logger.error("parse error: %s" % str(traceback.format_exc()))
        os_type, os_version = "Linux", ""
    result["os_type"] = os_type
    result["os_version"] = os_version

    ret_map = context.get("map")
    ret_map.put("data", json.dumps(result))
    return context


def get_os_type_version(context):
    """
    获取操作系统类型、版本
    :param context: 上下文
    :return: 类型、版本
    """
    command = "cat /etc/*-release"
    context["command"] = command
    op_sys_info_list = get_return_from_txt(context)
    if not op_sys_info_list:
        return "", ""
    os_type = ""
    os_version = ""
    for line in op_sys_info_list:
        if line.startswith("#"):
            # 跳过注释行
            continue
        # 非SUSE的处理
        items = line.split("release")
        if "release" in line.lower() and len(items) == 2:
            os_type = items[0].strip() + " release"
            os_version = items[-1]
            break
        # SUSE处理
        if line.strip().startswith("PRETTY_NAME") and "SUSE" in line \
                and "=" in line:
            result = line.split("=")[1].strip("\"")
            os_type = " ".join(result.split()[0:-2])
            os_version = " ".join(result.split()[-2:])
            break
        if line.startswith("SUSE"):
            os_type = " ".join(line.split()[0:-2])
        if line.startswith("VERSION ="):
            os_version += line.split("=")[1].strip()
        if line.startswith("PATCHLEVEL ="):
            os_version += " SP"
            os_version += line.split("=")[1].strip()
    if not os_type:
        os_type = ""
    if not os_version:
        os_version = ""
    return os_type, os_version
