# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
from common.cmd_execute import DES, CMD, change_list_to_tuple
from common.cmd_execute_offline import BaseCmdExecuteOffline
from common.contentParse import get_cmd_ret
from hosts.linux.linux_multipath_info import get_dm_path_ids

CMD_LIST = [
    {DES: "cmd_display_multipath_info_upadmin_version", CMD: "upadmin show version"},
    {DES: "cmd_display_multipath_info_powermt_version", CMD: "powermt version"},
    {DES: "cmd_display_multipath_info_hdlm_version", CMD: "dlnkmgr view -sys"},
    {DES: "cmd_display_multipath_info_multipath_ll", CMD: "multipath -ll|cat"},
    {DES: "cmd_display_multipath_info_powermt_disk", CMD: "powermt display dev=all"},
    {DES: "cmd_display_multipath_info_fdisk", CMD: "fdisk -l"},
    {DES: "cmd_display_multipath_info_up_disk_type_all", CMD: "upadmin show vlun type=all"},
    {DES: "cmd_display_multipath_info_up_disk", CMD: "upadmin show vlun"},
    {DES: "cmd_display_multipath_info_hdlm1", CMD: "dlnkmgr view -path"},
    {DES: "cmd_display_multipath_info_hdlm2", CMD: "/opt/DynamicLinkManager/bin/dlnkmgr view -path"},
    {DES: "cmd_display_multipath_disk_discard_max_bytes",
     CMD: "for name in `ls /sys/block`; do echo $name; cat /sys/block/$name/queue/discard_max_bytes; echo; done"},
    {DES: "cmd_display_multipath_disk_discard_granularity",
     CMD: "for name in `ls /sys/block`; do echo $name; cat /sys/block/$name/queue/discard_granularity; echo; done"},
]

VLUN_ID_CMD_DICTS = [
    {DES: "cmd_display_multipath_info_up_vlun_id_type_all_", CMD: "upadmin show vlun id=%s type=all"},
    {DES: "cmd_display_multipath_info_up_vlun_id_", CMD: "upadmin show vlun id=%s"},
]

DM_DISK_SECTOR_CMD_DICTD = [
    {DES: "cmd_display_multipath_dm_hw_sector_", CMD: "cat /sys/block/%s/queue/max_hw_sectors_kb"},
    {DES: "cmd_display_multipath_dm_sector_", CMD: "cat /sys/block/%s/queue/max_sectors_kb"},
    {DES: "cmd_display_multipath_dm_discard_max_bytes_", CMD: "cat /sys/block/%s/queue/discard_max_bytes"},
    {DES: "cmd_display_multipath_dm_discard_granularity_", CMD: "cat /sys/block/%s/queue/discard_granularity"},
    {DES: "cmd_display_multipath_dm_sg_vpd_page_0xb0_", CMD: "sg_vpd /dev/%s --page=0xb0"},
    {DES: "cmd_display_multipath_dm_sg_vpd_page_0xb2_", CMD: "sg_vpd /dev/%s --page=0xb2"},
]

DM_DISK_PATH_ID_CMDS = [
    {DES: "cmd_display_multipath_dm_provisioning_mode_cmds_",
     CMD: "cat /sys/block/%s/device/scsi_disk/*/provisioning_mode"},
]


def execute(context):
    LinuxMultiPath(context).execute()


def get_disk_letter_ids(disk_path_ids):
    return list(group[0] for group in disk_path_ids)


class LinuxMultiPath(BaseCmdExecuteOffline):
    def __init__(self, context):
        BaseCmdExecuteOffline.__init__(self, context)

    def execute(self):
        self.cmd_list = CMD_LIST
        self.generate_relative_cmd_list(change_list_to_tuple(self.get_vlun_ids()), VLUN_ID_CMD_DICTS)

        self.context["command"] = "multipath -ll|cat"
        dm_names, disk_path_ids = get_dm_path_ids(get_cmd_ret(self.context))
        self.generate_relative_cmd_list(change_list_to_tuple(dm_names), DM_DISK_SECTOR_CMD_DICTD)

        disk_letter_ids = list((group[0],) for group in disk_path_ids)
        self.generate_relative_cmd_list(disk_letter_ids, DM_DISK_PATH_ID_CMDS)
        self.execute_pure_cmd_list()

    def get_vlun_ids(self):
        """
        获取vlun id
        :return: 数据
        """
        ids = []
        self.context["command"] = "upadmin show vlun type=all"
        vluns_info = get_cmd_ret(self.context)
        if "Vlun ID" not in vluns_info:
            self.context["command"] = "upadmin show vlun"
            vluns_info = get_cmd_ret(self.context)
        flag = False
        for line in vluns_info.splitlines():
            if "Vlun ID" in line:
                flag = True
                continue
            if not flag:
                continue
            if flag and "-----" in line:
                break
            vlun_id = line.split()[0]
            if flag and vlun_id.isdigit():
                ids.append(vlun_id)
        return ids
