# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2023. All rights reserved.

import re
from common.contentParse import get_cmd_ret
from common.contentParse import get_cmd_ret_list

cmd_info_id = [
    "cmd_info_os_basic_uname",
    "cmd_info_os_basic_release",
    "cmd_info_os_basic_hba_hosts",
    "cmd_info_os_basic_hba_type",
    "cmd_info_os_basic_hba_list",
    "cmd_info_os_basic_hba_lspci",
    "cmd_info_os_basic_hosts_conf",
    "cmd_info_os_basic_olsnodes",
    "cmd_info_os_basic_lvm_version",
    "cmd_info_os_basic_vxvm",
    "cmd_info_os_basic_asmlib",
    "cmd_info_oracle_udev_raw_rule",
    "cmd_info_oracle_info_oracleasm",
    "cmd_info_oracle_info_oracleasm_listdisks",
]

cmd_info_desc = [
    "uname -a",
    "cat /etc/*-release",
    "ls /sys/class/fc_host",
    "cat  /sys/class/scsi_host/host*/model*name",
    "cat  /sys/class/fc_host/host*/port*name",
    "lspci -vvnn | grep -iA2 'Fibre Channel'",
    "cat /etc/hosts",
    "olsnodes -s",
    "lvm version",
    "hastatus -sum",
    "oracleasm listdisks |xargs oracleasm querydisk -p",
    "ls /etc/udev/rules.d/*rules|awk '{print $1}'",
    "cat /etc/sysconfig/oracleasm",
    "oracleasm listdisks |xargs oracleasm querydisk -p",
]

cmd_hba_id = [
    "cmd_display_os_basic_hba_%s_port_name",
    "cmd_display_os_basic_hba_%s_port_type",
    "cmd_display_os_basic_hba_scsi_host_%s_model_desc",
]

cmd_hba_desc = [
    "cat /sys/class/fc_host/%s/port_name",
    "cat /sys/class/fc_host/%s/port_type",
    "cat /sys/class/scsi_host/%s/model_desc",
]


def execute(context):
    cmd_display = context.get("ret_map")
    for rg in range(len(cmd_info_id)):
        context["command"] = cmd_info_desc[rg]
        if cmd_info_id[rg] == "cmd_info_oracle_udev_raw_rule":
            cmd_display_temp = get_udev_raw_info(context)
        elif cmd_info_id[rg] == "cmd_info_os_basic_olsnodes":
            cmd_display_temp = get_olsnodes_info(context)
        else:
            cmd_display_temp = get_cmd_ret(context)
        cmd_display.put("cmd_display" + (cmd_info_id[rg])[8:],
                        cmd_display_temp)
    grab_hba_detail(context)
    return cmd_display


def grab_hba_detail(context):
    cmd_display = context.get("ret_map")
    context["command"] = "ls /sys/class/fc_host"
    lines = get_cmd_ret(context).splitlines()[1:]
    for line in lines:
        if not line:
            continue
        hosts = re.split("\\s+", line.strip())
        for host in hosts:
            build_cmd_display(cmd_display, context, host)


def build_cmd_display(cmd_display, context, host):
    for (idx, cmd) in enumerate(cmd_hba_desc):
        context["command"] = cmd % host
        cmd_display.put(cmd_hba_id[idx] % host, get_cmd_ret(context))


def get_olsnodes_info(context):
    """
    获取多个回显中成功的回显
    :param context: 上下文
    :return: 对的回显
    """
    ret_list = get_cmd_ret_list(context)
    for ret in ret_list:
        if "not found" not in ret:
            return ret
    return ret_list[0]


def get_udev_raw_info(context):
    """
    获取linux主机的udev回显
    :param context: 上下文
    :return: udev回显
    """
    udev_list = get_cmd_ret(context)
    result = ""
    for line in udev_list.splitlines()[1:]:
        if line.startswith("/etc/udev/rules.d"):
            context["command"] = "cat " + line
            result = result + get_cmd_ret(context)
    return result
