# --*-- coding:utf-8 --*--

#获取hba卡的ROM FW版本信息
import sys
import os
path = os.path.dirname(os.path.abspath(__file__))
path =os.path.join(path, "..\\..\\..")
sys.path.append(path)
from common.contentParse import getCommandRetFromTxt 


def execute(context):
    #获取HBA卡包含ROM FW版本信息的回文
    hbaFwVersionRet = getCommandRetFromTxt(context)
    while "" in hbaFwVersionRet:
        hbaFwVersionRet.remove("")

    hbaFwVersionList = hbaFwVersionRet
    if 0 == len(hbaFwVersionList):
        result = "No HBA card firmware version info."
    else:
        hbaFwVersionList = handFwVersion(hbaFwVersionList)
        result = ';'.join(hbaFwVersionList)
    context["result"]=result
    
    return context

#去掉Emulex类型HBA的版本号中其他非版本号信息
def handFwVersion(hbaDrvVersionList):
    tempList = []
    for version in hbaDrvVersionList[0:]:
        if "No such file or directory" in version or "TOOLKIT_EXE_CMD_FAILED" in version:
            continue
        else:
            tempList.append(version)
        
    return tempList


