# --*-- coding:utf-8 --*--

#获取hba卡的固件版本信息
import sys
import os
path = os.path.dirname(os.path.abspath(__file__))
path =os.path.join(path, "..\\..\\..")
sys.path.append(path)
from common.contentParse import  *

def execute(context):
    #获取HBA卡的基本信息的回文
    hbaDrvVersionRet = getCommandRetFromTxt(context)
    while "" in hbaDrvVersionRet:
        hbaDrvVersionRet.remove("")
    hbaDrvVersionList = hbaDrvVersionRet  
    
    #处理Emulex类型HBA的版本号
    if 0 == len(hbaDrvVersionList):
        result = "No HBA card driver version."
    else:
        hbaDrvVersionList = handDevVersion(hbaDrvVersionList)
        result = ';'.join(hbaDrvVersionList)
    context["result"]=result
    
    return context

#去掉Emulex类型HBA的版本号中其他非版本号信息
def handDevVersion(hbaDrvVersionList):
    tempList = []
    for drvVersion in hbaDrvVersionList[0:]:
        if "No such file or directory" in drvVersion or "TOOLKIT_EXE_CMD_FAILED" in drvVersion:
            continue
        
        if drvVersion.startswith("Emulex"):
            version = drvVersion.split()[6]
        else:
            version = drvVersion
        tempList.append(version)
        
    return tempList
