# --*-- coding:utf-8 --*--
import sys 
import os
import re
reload(sys) 
sys.setdefaultencoding('utf-8')
path = os.path.dirname(os.path.abspath(__file__))
path =os.path.join(path, "..\\..\\..")
sys.path.append(path)
from common.contentParse import getSameCommandsHbaRetFromTxt
from common.contentParse import check_lst

#获取hba卡数量
def execute(context):
    all_result = ""
    fc_result = get_fc_wwpn(context)
    iscsi_result = get_iscsi_wwpn(context)

    if len(fc_result) == 0:
        all_result = iscsi_result
    else:
        if len(iscsi_result) == 0:
            all_result = fc_result
        else:
            all_result = fc_result + ";" + iscsi_result
    if len(all_result) == 0:
        all_result = "NA"
    else:
        all_result = all_result
    # 结果
    context["result"] = all_result
    return context

def get_iscsi_wwpn(context):
    """
    获取iscsi的wwpn
    :param context:
    :return:
    """
    iscsi_wwpns = ""
    cmd_desc_iscsi = "cmd_display_multipath_iscsi_startinfo"
    iscsi_lst = getSameCommandsHbaRetFromTxt(context, [cmd_desc_iscsi])[0]
    iscsi_lst = check_lst(iscsi_lst)
    for line in iscsi_lst:
        if "InitiatorName=" in line:
            iscsi_wwpns = iscsi_wwpns + re.split('=', line)[1].strip() + ";"
    if len(iscsi_wwpns) > 0:
        iscsi_wwpns = iscsi_wwpns[0:-1]

    return iscsi_wwpns


def get_fc_wwpn(context):
    """
    获取fc的wwpn
    :param context:
    :return:
    """
    #命令描述
    CMD_DESC_NAME = "cmd_display_hba_card_port_name_ls"
    CMD_DESC_STATE = "cmd_display_hba_card_status"
    CMD_DESC_WWPN = "cmd_display_hba_card_port_name_cat"
    
    #回文列表
    name_lst = []
    state_lst = []
    wwpn_lst = []
    
    
    #获取回文
    name_lst = getSameCommandsHbaRetFromTxt(context,[CMD_DESC_NAME])[0]
    state_lst = getSameCommandsHbaRetFromTxt(context,[CMD_DESC_STATE])[0]
    wwpn_lst = getSameCommandsHbaRetFromTxt(context,[CMD_DESC_WWPN])[0]
    #过滤
    name_lst = check_lst(name_lst)
    state_lst = check_lst(state_lst)
    wwpn_lst = check_lst(wwpn_lst)
    #test
    hba_info = Hba_Info()
    
    for state in state_lst:
        if ('cat' not in state) and('*' not in state) and ('cmd_display' not in state):
            hba_info.addState(state)
    for wwpn in wwpn_lst:
        if ('cat' not in wwpn) and('*' not in wwpn) and ('cmd_display' not in wwpn):
            hba_info.addWWPN(wwpn)
    
    states = hba_info.getPortStateLst()
    wwpns = hba_info.getPortWWPNLst()
    
    result = ""
    if len(states) !=0:
        for i, state_value in enumerate(states):
           if  ('up' in state_value) or ('online' in state_value.lower()):
                result = result + wwpns[i][2:] + ';'
    if len(result) >0:
        if ';' == result[-1]:
            result = result[0:-1]
    return result

class Hba_Info:
    __portNameLst =[]
    __portStateLst = []
    __portWWPNLst = []
    
    def addName(self,name):
        self.__portNameLst.append(name)
    def addState(self,state):
        self.__portStateLst.append(state)
    def addWWPN(self,wwpn):
        self.__portWWPNLst.append(wwpn)
    
    def getPortNameLst(self):
        return self.__portNameLst
    def getPortStateLst(self):
        return self.__portStateLst
    def getPortWWPNLst(self):
        return self.__portWWPNLst
    
