# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.


def get_key_values_from_content_lines(lines, start_bid, keys_tuple, delimiter):
    """
    从内容列表中根据根据 keys解析出相应的值，返回键值对字典列表
    注意：没有找到的键将不会装入字典中
    eg:
    lines:
        [
        ':*> vserver cifs',
        '            ',
        '    Vserver: 111',
        '    User Name: 111',
        ' ',
        ':*> vserver cifs',
        '    Vserver: 222',
        '    User Name: 222'
        ]
    start_bid:
        :*> vserver cifs
    keys_tuple:
        ('Vserver', 'User Name')
    delimiter:
        ':'
    return:
        [{'Vserver': '111', 'User Name': '111'},{'Vserver': '222', 'User Name': '222'} ]
    """
    key_value_list = list()
    key_value_dict = dict()
    last_key = None  # 上一行匹配到的关键字
    content_lines = [line for line in lines if line.strip()]

    for row in content_lines:
        # 当前行是否有关键字对应值的行
        find_key = False
        content_row = row.strip()

        if content_row.startswith(start_bid):
            add_non_empty_repetitive_info_into_list(key_value_dict, key_value_list)
            key_value_dict = {}
            last_key = None
        # 出现值换行(上一行有关键字，且当前行无冒号)，要将值累加到上一个关键字的值上
        if last_key and delimiter not in row:
            key_value_dict[last_key] += '\n' + content_row
            continue

        for key in keys_tuple:
            if content_row.startswith(key + delimiter):
                key_value_dict[key] = row.split(key + delimiter)[1].strip() or ''
                last_key = key
                find_key = True
                break
        # 如果遍历keys_tuple后，啥都没匹配到，则当前行并没有key,故置last_key为None
        if not find_key:
            last_key = None
    add_non_empty_repetitive_info_into_list(key_value_dict, key_value_list)

    return key_value_list


def add_non_empty_repetitive_info_into_list(key_value_dict, key_value_list):
    """
    将非空且在列表没有的元素 添加到 列表中
    """
    if key_value_dict and key_value_dict not in key_value_list:
        key_value_list.append(key_value_dict)
