# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
import json

from common.contentParse import get_return_from_txt
from hosts.common.migra_summary_util import get_stms_disks, get_power_disks, get_ultra_disks, get_ultra_disk_list, \
    get_dmp_disk


def execute(context):
    result = {}
    os_type, os_version = get_type_version(context)
    result["host_ip"] = context.get("ip")
    result["os_type"] = os_type
    result["os_version"] = os_version
    result["is_san_boot"] = is_san_boot(context)
    ret_map = context.get("map")
    ret_map.put("data", json.dumps(result))
    return context


def get_type_version(context):
    """
    获取操作系统 版本
    :param context: 上下文
    :return:  版本
    """
    context["command"] = "cat /etc/release"
    op_sys_info_list = get_return_from_txt(context)
    if op_sys_info_list:
        for line in op_sys_info_list:
            if line.strip().startswith("Oracle Solaris"):
                return "Oracle Solaris", line.split("Oracle Solaris")[-1]
            # 容错，部分x86环境Solaris开头
            if line.strip().startswith("Solaris"):
                return "Solaris", line.split("Solaris")[-1]
    return "Oracle Solaris", ""


def is_san_boot(context):
    boot_disk = get_boot_disk(context)
    # 若没有获取到boot盘信息，无法判断是否是SanBoot，显示NA，需要人为介入
    if not boot_disk:
        return "NA"
    # SanBoot场景要求boot盘是多路径管理的LUN，LUN WWN至少16位
    if len(boot_disk) < 16:
        return "No"
    disks = get_all_disks(context)
    if boot_disk in disks:
        return "Yes"
    return "No"


def get_all_disks(context):
    """
    获取主机所有磁盘信息，用于判断是否SanBoot场景
    :param context: 上下文
    :return: 磁盘列表
    """
    disks = get_native_disks(context)
    disks.extend(get_ultra_path_disks(context))
    disks.extend(get_power_path_disks(context))
    disks.extend(get_dmp_disks(context))
    return make_disk_lower(disks)


def make_disk_lower(disks):
    all_disks = []
    for disk in disks:
        if disk:
            all_disks.append(disk.lower())
    return all_disks


def get_native_disks(context):
    disk_list = get_stms_disks(context)
    disks = []
    for disk in disk_list:
        disk_name = disk.split("/")[-1].strip().lower()
        if len(disk_name) > 7:
            disks.append(disk_name[3:-4])
    return disks


def get_ultra_path_disks(context):
    header_line, disks = get_ultra_disks(context, "solaris")
    disk_list = get_ultra_disk_list(header_line, disks, context, "solaris")
    disks = []
    for disk in disk_list:
        disks.append(disk["lun_wwn"])
    return disks


def get_power_path_disks(context):
    disk_lines = get_power_disks(context)
    disks = []
    for line in disk_lines:
        if "Logical device ID" in line:
            disks.append(line.split("=")[1].strip().split()[0])
    return disks


def get_dmp_disks(context):
    dmp_disks = get_dmp_disk(context)
    disks = []
    for disk in dmp_disks:
        disks.append(disk["lun_wwn"])
    return disks


def get_boot_disk(context):
    zpool = get_zpool(context)
    if not zpool:
        return ""
    context["command"] = "zpool status -v"
    zpool_status = get_return_from_txt(context)
    find_zpool = False
    boot_disk = ""
    for line in zpool_status:
        if "ONLINE" not in line:
            continue
        if zpool in line:
            find_zpool = True
            continue
        if find_zpool:
            item = line.strip().split()[0]
            boot_disk = item[3:-4] if len(item) > 7 else item
        if boot_disk:
            break
    return boot_disk.lower()


def get_zpool(context):
    context["command"] = "prtconf -vp | grep boot"
    boot_infos = get_return_from_txt(context)
    for line in boot_infos:
        if "zfs-bootfs:" in line:
            zpool = line[line.index(":") + 1:].strip().strip("'")
            return zpool.split("/")[0]
    return ""
