# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
import sys
import os
import json
import traceback

reload(sys)
sys.setdefaultencoding('utf-8')
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..\\..")
sys.path.append(path)
from common.contentParse import get_return_from_txt
from hosts.common.migra_summary_util import get_dmp_version


def execute(context):
    """
    入口执行方法
    :param context: 上下文
    :return: context
    """
    logger = context.get("Logger")
    try:
        vcs_cluster = get_vcs_cluster(context)
    except Exception:
        logger.error("parse error: %s" % str(traceback.format_exc()))
        vcs_cluster = get_empty_vcs_cluster(context)
    ret_map = context.get("map")
    ret_map.put("data", json.dumps(vcs_cluster))
    return context


def get_empty_vcs_cluster(context):
    """
    获取空白的VCS集群信息
    :param context: 上下文
    :return: []
    """
    result_map = {}
    result_map["host_ip"] = context.get("ip")
    result_map["cluster_member"] = [""]
    result_map["node_status"] = [""]
    result_map["cluster_version"] = ""
    result_map["cluster_vote"] = ""
    result_map["cluster_multipath"] = ""
    result_map["fencing_mode"] = ""
    result_map["cluster_group"] = [""]
    result_map["group_state"] = [""]
    result_map["dg_name"] = [""]
    return result_map


def get_vcs_cluster(context):
    """
    获取VCS集群信息
    :param context: 上下文
    :return: return map
    """
    result_map = {}
    result_map["host_ip"] = context.get("ip")
    result_map["cluster_version"] = get_dmp_version(context).split(",")[0]
    result_map["cluster_vote"] = get_cluster_vote(context)
    multi_path, fencing_mode = get_multi_path_fencing_mode(context)
    result_map["cluster_multipath"] = multi_path
    result_map["fencing_mode"] = fencing_mode

    members = get_cluster_member(context)
    disk_groups = analysis_disk_group(parse_disk_group(context), parse_disk_group_state(context))
    analysis_cluster_group(members, disk_groups, result_map)
    return result_map


def analysis_cluster_group(members, disk_groups, result_map):
    """
    分析集群组信息
    :param members: 节点信息
    :param disk_groups: 集群组信息
    :param result_map： 结果数据
    :return: none
    """
    cluster_members = []
    node_statuses = []
    cluster_groups = []
    group_states = []
    dg_names = []
    for (node, node_status) in members.items():
        for disk_group in disk_groups:
            if disk_group.get_system() == node:
                cluster_members.append(node)
                node_statuses.append(node_status)
                cluster_groups.append(disk_group.get_cluster_group())
                group_states.append(disk_group.get_group_state())
                dg_names.append(disk_group.get_disk_name())
    result_map["cluster_member"] = cluster_members
    result_map["node_status"] = node_statuses
    result_map["cluster_group"] = cluster_groups
    result_map["group_state"] = group_states
    result_map["dg_name"] = dg_names


def get_cluster_member(context):
    """
    获取集群组状态信息
    :param context: 上下文
    :return: 集群组信息
    """
    hastatus_lines = get_cmd_result_line(context, "hastatus -sum")
    start = False
    members = {}
    for line in hastatus_lines:
        if not start:
            start = "SYSTEM STATE" in line
            continue
        if "GROUP STATE" in line:
            break
        if line and ("System" not in line) and ("State" not in line):
            items = line.split()
            members[items[1]] = items[2]
    return members


def get_cluster_vote(context):
    """
    获取仲裁盘名称
    :param context: 上下文
    :return: 仲裁盘名称
    """
    vote_lines = get_cmd_result_line(context, "cat /etc/vxfendg")
    for line in vote_lines:
        if line:
            return line.strip()
    return ""


def get_multi_path_fencing_mode(context):
    """
    获取多路径软件名称和FencingMode
    :param context: 上下文
    :return: 多路径软件名称和FencingMode
    """
    fencing_lines = get_cmd_result_line(context, "vxfenadm -d")
    multipath = ""
    fencing_mode = ""
    for line in fencing_lines:
        if "Fencing Mode:".lower() in line.lower():
            fencing_mode = line.split(":")[1].strip()
        if "Fencing SCSI3 Disk Policy:".lower() in line.lower():
            multipath = line.split(":")[1].strip()
            break
    return multipath, fencing_mode


def parse_disk_group_state(context):
    """
    解析集群组信息
    :param context: 上下文
    :return: clusterGroups
    """
    disk_group_lines = get_cmd_result_line(context, "hares -state")
    disk_group_states = []
    start = False
    for line in disk_group_lines:
        if not line:
            continue
        if not start:
            start = line.startswith("#Resource") and "System" in line and "Value" in line
            continue
        items = line.strip().split()
        if len(items) > 3:
            disk_group_states.append((items[0], items[2], items[3]))
    return disk_group_states


def parse_disk_group(context):
    """
    获取集群组-DiskGroup名称map
    :param context: 上下文
    :return: 集群组-DiskGroup名称map
    """
    hares_display_lines = get_cmd_result_line(context, "hares -display")
    disk_groups = []
    disk_group = DiskGroup()
    for line in hares_display_lines:
        if not line:
            continue
        items = line.strip().split()
        if len(items) < 4:
            continue
        if items[1] == "Type":
            disk_group.set_type(items[3])
        if items[1] == "DiskGroup" and disk_group.get_type() == "DiskGroup":
            disk_group.set_cluster_group(items[0])
            disk_group.set_disk_name(items[3])
            disk_groups.append(disk_group)
            disk_group = DiskGroup()
    return disk_groups


def analysis_disk_group(disk_groups, disk_group_states):
    """
    分析可用的DiskGroup
    :param disk_groups: DG数据
    :param disk_group_states: 状态数据
    :return:
    """
    dg_list = []
    for disk_group_state in disk_group_states:
        for disk_group in disk_groups:
            if disk_group.get_cluster_group() == disk_group_state[0]:
                clone_dg = DiskGroup()
                clone_dg.set_cluster_group(disk_group.get_cluster_group())
                clone_dg.set_system(disk_group_state[1])
                clone_dg.set_group_state(disk_group_state[2])
                clone_dg.set_disk_name(disk_group.get_disk_name())
                clone_dg.set_type(disk_group.get_type())
                dg_list.append(clone_dg)
    return dg_list


def get_cmd_result_line(context, command):
    """
    获取命令回显行信息，命令执行失败时，返回空数组
    :param context: 上下文
    :param command: 命令
    :return: lines
    """
    context["command"] = command
    result_list = get_return_from_txt(context)
    cmd_not_found = command.split()[0].lower() + ": not found"
    lower_line = result_list[0].lower() if result_list else ""
    if cmd_not_found in lower_line or "no such file or directory" in lower_line:
        return []
    return result_list


class DiskGroup:

    __type = ''
    __cluster_group = ''
    __system = ''
    __group_state = ''
    __disk_name = ''

    def set_type(self, dg_type):
        self.__type = dg_type

    def set_cluster_group(self, cluster_group):
        self.__cluster_group = cluster_group

    def set_system(self, system):
        self.__system = system

    def set_group_state(self, group_state):
        self.__group_state = group_state

    def set_disk_name(self, disk_name):
        self.__disk_name = disk_name

    def get_type(self):
        return self.__type

    def get_cluster_group(self):
        return self.__cluster_group

    def get_system(self):
        return self.__system

    def get_group_state(self):
        return self.__group_state

    def get_disk_name(self):
        return self.__disk_name
