# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.
import sys
import os
import json
import re
import traceback

reload(sys)
sys.setdefaultencoding('utf-8')
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..\\..")
sys.path.append(path)
from common.contentParse import get_return_from_txt
import math


def execute(context):
    global logger
    logger = context.get("Logger")
    result = get_result(context)
    ret_map = context.get("map")
    ret_map.put("data", json.dumps(result))
    return context


def get_result(context):
    """
    获取dg相关数据
    :param context:上下文
    :return: dg数据
    """
    result = {"host_ip": context.get("ip")}
    try:
        dg_list = get_disk_group(context)
        if not dg_list:
            result["dg_list"] = get_empty_result()
            return result
        volumes = get_volume_info(context)
        for dg in dg_list:
            dg["vls"] = volumes.get(dg.get("dg_name", ""), [])
        result["dg_list"] = dg_list
    except Exception:
        logger.error("parse error: %s" % str(traceback.format_exc()))
        result["dg_list"] = get_empty_result()
    return result


def get_disk_group(context):
    """
    获取dg字典列表
    :param context:上下文
    :return: 字典列表
    """
    dg_dict = {}
    context["command"] = "vxdisk -o alldgs list"
    lines = get_return_from_txt(context)
    start = False
    headers = ["DEVICE", "TYPE", "DISK", "GROUP"]
    for line in lines:
        if not start:
            start = check_header_line(line, headers)
            continue
        parts = re.split(r"\s+", line)
        if len(parts) < 4 or parts[3] == "-":
            continue
        dg_name = parts[3].strip("()")
        current_dg = dg_dict.get(dg_name)
        if not current_dg:
            disk_list = [{"device_name": parts[0], "disk_name": parts[2]}]
            current_dg = {"dg_name": dg_name, "disks": disk_list}
            dg_dict[dg_name] = current_dg
            continue
        current_dg.get("disks").append({"device_name": parts[0], "disk_name": parts[2]})

    return list(dg_dict.values())


def get_volume_info(context):
    """
    获取volume信息字典
    :param context:上下文
    :return: 字典
    """
    volume_dict = {}
    current_dg = []
    current_dg_name = ""
    current_volume = {'volume_name': '', 'pls': []}
    current_pl = {'pl_name': '', 'sds': []}
    mount_dict = get_volume_mount_info(context)
    context["command"] = "vxprint"
    lines = get_return_from_txt(context)
    for line in lines:
        line = line.strip()
        if line.startswith("Disk group:"):  # new dg
            dg_name = line.split("Disk group:")[-1].strip()
            current_dg_name = dg_name
            current_dg = []
            volume_dict[dg_name] = current_dg
            continue
        if line.startswith("v  "):  # new volume
            volume_name = re.split(r'\s+', line)[1]
            current_volume = {"volume_name": volume_name, "pls": []}
            current_volume.update(mount_dict.get(current_dg_name + "/" + volume_name, {}))
            current_dg.append(current_volume)
            continue
        if line.startswith("pl "):  # new pl
            pl_name = re.split(r'\s+', line)[1]
            current_pl = {"pl_name": pl_name, "sds": []}
            current_volume["pls"].append(current_pl)
            continue
        if line.startswith("sd "):  # new sd
            sd_name = re.split(r'\s+', line)[1]
            current_pl["sds"].append(sd_name)
            continue
    return volume_dict


def get_volume_mount_info(context):
    """
    获取volume挂载信息字典
    :param context:上下文
    :return: 字典
    """
    context["command"] = "df -k"
    lines = get_return_from_txt(context)
    volume_dict = {}
    for line in lines[1:]:
        parts = re.split(r'\s{2,}', line)
        file_system_parts = parts[0].split('/')
        if len(parts) < 6 or len(file_system_parts) < 2:
            continue
        volume_key = '/'.join(file_system_parts[-2:])
        if not parts[5].startswith("/"):
            continue
        mount_point = parts[5]
        volume_dict[volume_key] = {'volume_size': format_block_size(int(parts[1])), 'mount_point': mount_point}
    return volume_dict


def get_empty_result():
    """
    空数据格式
    :return: 空数据
    """
    return [{"dg_name": "", "disks": [{"disk_name": "", "device_name": ""}],
             "vls": [{"volume_name": "", "mount_point": "", "volume_size": "", "pls": [{"pl_name": "", "sds": [""]}]}]}]


def check_header_line(line, headers):
    for header in headers:
        if header not in line.upper():
            return False
    return True


def format_block_size(block_size):
    """
    Converts block capacity to a readable representation of a unit of capacity
    :param block_size: The number of blocks expressed in units of 1K
    :return: The formatted capacity
    """
    byte_units = ('KiB', 'MiB', 'GiB', 'TiB', 'PiB', 'EiB', 'ZiB', 'YiB')
    if block_size <= 0:
        return "0.0 KiB"
    exponent = min(int(math.log(block_size, 1024)), len(byte_units) - 1)
    return "%.1f %s" % (float(block_size) / pow(1024, exponent), byte_units[exponent])
