# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
from common.contentParse import get_cmd_ret


cmd_info_id = [
    "cmd_info_lvm_df",
    "cmd_info_lvm_metadb",
    "cmd_info_lvm_metaset",
    "cmd_info_lvm_metaset_name",
    "cmd_info_lvm_metastat_",
    "cmd_info_lvm_metastat_lower",
    "cmd_info_lvm_zpool_status",
]

cmd_info_desc = [
    "df -k",
    "metadb",
    "metaset",
    "metaset | grep 'Set name'",
    "metastat -p -s ",
    "metastat -p",
    "zpool status -v",
]


def execute(context):
    cmd_display = context.get("ret_map")
    for rg in range(len(cmd_info_id)):
        if cmd_info_id[rg] == "cmd_info_lvm_metastat_":
            set_metastat(context, cmd_display,
                         cmd_info_id[rg], cmd_info_desc[rg])
            continue
        context["command"] = cmd_info_desc[rg]
        cmd_display_temp = get_cmd_ret(context)
        cmd_display.put("cmd_display" + (cmd_info_id[rg])[8:],
                        cmd_display_temp)
    return cmd_display


def set_metastat(context, cmd_display, cmd_id, desc):
    """
    组装metastat数据
    :param context: 上下文
    :param cmd_display: 数据存储
    :param cmd_id: 命令描述
    :param desc: 命令
    """
    context["command"] = \
        "metaset |grep 'Set name' |sed 's/,//' |awk '{print $4}'"
    cmd_display_temp = get_cmd_ret(context)
    for line in cmd_display_temp.splitlines()[1:]:
        if line.strip() and "not found" not in line:
            context["command"] = desc + line
            cmd_display_setname = get_cmd_ret(context)
            cmd_display.put("cmd_display" + cmd_id[8:], cmd_display_setname)
