# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2023. All rights reserved.
from common.contentParse import get_cmd_ret

cmd_info_id = [
    "cmd_info_multipath_info_upadmin_version",
    "cmd_info_multipath_info_powermt_version",
    "cmd_info_multipath_info_hdlm_version",
    "cmd_info_multipath_info_stms_disks",
    "cmd_info_multipath_info_stms_disk_",
    "cmd_info_multipath_info_luxadm_",
    "cmd_info_multipath_info_power_disks",
    "cmd_info_multipath_info_ultra_disks",
    "cmd_info_multipath_info_ultra_vlun_",
    "cmd_info_multipath_info_emc_luxadm_",
    "cmd_info_multipath_info_dmpnode",
    "cmd_info_multipath_info_dmp_version",
    "cmd_info_multipath_info_devices_scsi_vhci",
]

cmd_info_desc = [
    "upadm show version",
    "powermt version",
    "dlnkmgr view -sys",
    "mpathadm list lu",
    "mpathadm show lu %s",
    "luxadm display %s",
    "powermt display dev=all",
    "upadm show vlun type=all",
    "upadm show vlun id=%s type=all",
    "luxadm display /dev/rdsk/%s",
    "vxdmpadm list dmpnode all",
    "pkginfo -l VRTSvxvm",
    "ls -l /devices/scsi_vhci/",
]


def execute(context):
    cmd_display = context.get("ret_map")
    for rg in range(len(cmd_info_id)):
        if cmd_info_id[rg] == "cmd_info_multipath_info_luxadm_" \
                or cmd_info_id[rg] == "cmd_info_multipath_info_ultra_vlun_"\
                or cmd_info_id[rg] == "cmd_info_multipath_info_emc_luxadm_"\
                or cmd_info_id[rg] == "cmd_info_multipath_info_stms_disk_":
            set_prefix_cmd(cmd_display, context, cmd_info_id[rg], cmd_info_desc[rg])
            continue
        context["command"] = cmd_info_desc[rg]
        cmd_display_temp = get_cmd_ret(context)
        cmd_display.put("cmd_display" + (cmd_info_id[rg])[8:], cmd_display_temp)
    return cmd_display


def set_prefix_cmd(cmd_display, context, id_prefix, cmd_prefix):
    """
    组装通过命令前缀执行的详情
    :param cmd_prefix: 命令前缀
    :param id_prefix: 描述前缀
    :param cmd_display: 回文字典
    :param context: 上下文
    """
    if id_prefix == "cmd_info_multipath_info_luxadm_":
        context["command"] = "mpathadm list lu|grep rdsk"
        dev_list = get_cmd_ret(context).splitlines()[1:]
    elif id_prefix == "cmd_info_multipath_info_ultra_vlun_":
        context["command"] = "upadm show vlun |awk '{print $1}' |grep '[0-9]'"
        dev_list = get_cmd_ret(context).splitlines()[1:]
    elif id_prefix == "cmd_info_multipath_info_emc_luxadm_":
        dev_list = []
        context["command"] = "powermt display dev=all"
        emc_list = get_cmd_ret(context).splitlines()[1:]
        for line in emc_list:
            if len(line.split()) > 3 and line.split()[2].startswith("c"):
                dev_list.append(line.split()[2])
    elif id_prefix == "cmd_info_multipath_info_stms_disk_":
        context["command"] = "mpathadm list lu|grep rdsk"
        dev_list = list(filter(lambda stms_line: "/dev/rdsk/" in stms_line, get_cmd_ret(context).splitlines()))
    else:
        dev_list = []
    for disk_name in dev_list:
        disk = disk_name.strip()
        if disk and "not found" not in disk:
            context["command"] = cmd_prefix % disk
            cmd_display.put("cmd_display" + id_prefix[8:] + disk, get_cmd_ret(context))
