# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2023. All rights reserved.
from hosts.utils.host_utils import offline_sql_cmd_excute
from common.contentParse import get_cmd_ret_list

oracle_cmd_info_id = [
    "cmd_display_database_oracle_olsnodes",
    "cmd_display_database_oracle_cluster_status",
    "cmd_display_database_oracle_cluster_vote",
    "cmd_display_database_oracle_ocr_disk_path",
    "cmd_display_database_oracle_asmcmd_dsget",
    "cmd_display_database_oracle_asmcmd_afd_lsdsk",
]

oracle_cmd_info_desc = [
    "olsnodes -s",
    "crsctl stat res -t",
    "crsctl query css votedisk",
    "ocrcheck",
    "asmcmd dsget",
    "asmcmd afd_lsdsk",
]

sql_cmd_info_id = [
    "cmd_info_database_oracle_sqlplus",
    "cmd_info_database_oracle_oracle_version",
    "sql_info_database_oracle_cluster_database",
    "sql_info_database_oracle_asm_diskstring",
    "sql_info_database_oracle_asm_diskgroup",
    "sql_info_database_oracle_asm_disk",
]

sql_cmd_info_desc = [
    "sqlplus / as sysdba",
    "select * from v$version;",
    "select value from v$parameter where name='cluster_database';",
    "show parameter asm_diskstring",
    "select group_number,name,state,total_mb,free_mb,sector_size from v$asm_diskgroup;",
    "select group_number,disk_number,name,mount_status,header_status,path,state,total_mb,free_mb,sector_size"
    " from v$asm_disk;",
]


def execute(context):
    get_oracle_cmd_info(context)
    get_asm_disk_detail(context)
    return offline_sql_cmd_excute(context, sql_cmd_info_id, sql_cmd_info_desc)


def get_oracle_cmd_info(context):
    cmd_display = context.get("ret_map")
    for index, display in enumerate(oracle_cmd_info_id):
        command = oracle_cmd_info_desc[index]
        context["command"] = command
        cmd_results = get_cmd_ret_list(context)
        for cmd_result in cmd_results:
            if not (cmd_result.strip() == "[offline] " + command) and "command not found" not in cmd_result\
                    and "Can't exec" not in cmd_result:
                cmd_display[display] = cmd_result
                break


def get_asm_disk_detail(context):
    cmd_display = context.get("ret_map")
    asm_disk_string = cmd_display.get("cmd_display_database_oracle_asmcmd_dsget", "")
    result_paths = []
    for line in asm_disk_string.splitlines():
        if "profile:" in line:
            result_paths = get_asm_disk_path_list(line)
            break
    display_id = "cmd_display_database_oracle_asm_path_detail_"
    for result_path in result_paths:
        context["command"] = "ls -l " + result_path
        results = get_cmd_ret_list(context)
        for result in results:
            if "No such file or directory" not in result:
                cmd_display[display_id + result_path] = result
                break


def get_asm_disk_path_list(line):
    paths = line[line.index(":") + 1:].strip().split(",")
    return list(map(lambda path: path[0:-1], filter(lambda path: path != "AFD:*" and path != "/dev/rdsk/*", paths)))
