# coding=utf-8
__author__ = '******'
# 数据迁移: 获取linux主机:集群基本信息
import re
CLI = None
LANGUAGE = None
import os
import sys
CURRENT_PATH = os.path.dirname(os.path.abspath(__file__))
sys.path.append(CURRENT_PATH)
CURRENT_PATH = os.path.join(CURRENT_PATH, "..\\..")
sys.path.append(CURRENT_PATH)
HOST_CMD_TIMEOUT = 5 * 60
from common import util
from common import contentParse
from common import constants
ALUA_ENABLED='enabled'
ALUA_NOT_ENABLED = 'not enabled'
ALUA_FIGURE_UNKNOWN = 'unknown'
PASS = 'pass'
MINIMUM_VERSION = '0.175.2.0.0.42.0'
LARGEST_VERSION = '0.175.2.13.0.6.0'
SOLARIS_UPADM_VERSION = {'id': 'solaris_upadm_version',
                         'cmd': "upadm show version"}
SOLARIS_CMD_MAP = {'id': 'solaris_version',
                   'cmd': "pkg info entire"}
SOLARIS_STMSBOOT_MAP = {'id': 'solaris_stmsboot',
                        'cmd': "stmsboot -L"}
FORMAT_CMD_MAP = {'id': 'solaris_alua_format',
                  'cmd': "mpathadm list LU|grep /dev|awk '{print $1}'"}
MPIOCHECK_CMD_MAP_OLD = {'id': 'solaris_alua_mpathadm_show_lun',
                         'cmd': r' mpathadm show lu '}
def execute(context):
    '''
    Function describe  : collect Solaris host Alua information
    Return             : cmd display
    '''
    diskAluaChecker = DiskAluaChecker(context)
    return diskAluaChecker.doGrab(context)


class DiskAluaChecker(object):
    '''
    @summary: collect disk alua feature configuration on solaris server host
    '''

    def __init__(self, context):
        '''
        @summary: constructor
        '''
        self.context = context
        self.sshCon = self.context.get("SSH")
        self.lang = self.context.get("lang")
        self.cmd_display = self.context.get("ret_map")
        self.access_flag = False

    def doGrab(self, context):
        '''
        @summary: evaluation entrance
        '''
        resultStatus = ""
        failedItems = []
        util.log.info(self.context, "[Solaris] start to fetch disk format configuration.")
        util.updateItemProgress(context, constants.PROG10)
        cmdEchos = ""
        cmdArgs = {}
        cmdArgs['timeout'] = constants.LINUX_UPSCAN_CMD_TIMEOUT
        cmdArgs['recordLog'] = True
        cmdArgs['_SPEFIC_END_STRS'] = ['(enter its number):', '$']
        cmdArgs['needCheckResult'] = False

        cmdEchos, resultStatus = self.upadm_check(context, cmdEchos,
                                                  resultStatus)
        cmdEchos, resultStatus = self.solaris_version_check(context, cmdEchos,
                                                            resultStatus)
        cmdEchos, resultStatus = self.stmsboot_check(context, cmdEchos,
                                                     resultStatus)

        cmdEcho = \
            self.sshCon.execCmdWithTimout(
                FORMAT_CMD_MAP['cmd'], constants.LINUX_UPSCAN_CMD_TIMEOUT)
        util.updateItemProgress(context, constants.PROG60)
        cmdEchos += cmdEcho
        self.cmd_display.put("cmd_display_" + FORMAT_CMD_MAP['id'], cmdEcho)
        status, result = self.getResultMsg(FORMAT_CMD_MAP['cmd'], cmdEcho)
        resultStatus += result
        if not status:
            self.cmd_display.put("err_msg", resultStatus)
            #record that current alua status collection has failed
            contentParse.saveAluaStatusAndCliRet2ForeEval(ALUA_FIGURE_UNKNOWN,
                                                          cmdEchos,
                                                          self.context)
            contentParse.save_access_status_and_cliret_2_foreval(
                ALUA_NOT_ENABLED, cmdEchos,
                'solartis.failed.query.host.lun.configs', self.context)
            self.access_flag = True
            util.updateItemProgress(context, constants.PROG90)
            return self.cmd_display
        self.wwn = self.parse4HuaweiDiskWwn(cmdEcho)
        diskNoList = self.wwn

        if len(diskNoList) < 1:
            util.log.info(self.context, "[Solaris] current host has no huawei disk detected..")
            self.cmd_display.put("err_msg", resultStatus)
            #set current Alua status as false and execution succeeded
            contentParse .saveAluaStatusAndCliRet2ForeEval (ALUA_NOT_ENABLED, cmdEchos, self.context)
            contentParse.save_access_status_and_cliret_2_foreval(
                ALUA_NOT_ENABLED, cmdEchos,
                'solartis.failed.query.host.lun.configs', self.context,
                self.access_flag)
            self.access_flag = True
            util.updateItemProgress(context, constants.PROG90)
            return self.cmd_display

        util.log.info(self.context, "[Solaris] found huawei disks listed:" + ','.join(diskNoList))
        alua_flag = False
        for diskNo in diskNoList:
            cmd = MPIOCHECK_CMD_MAP_OLD["cmd"] + diskNo
            util.log.info(self.context, "[Solaris] cmd:" + cmd)
            cmdEcho = self.sshCon.execCmdWithTimout(cmd,
                                                    constants.HOST_CMD_TIMEOUT)
            cmdEchos += cmdEcho
            self.cmd_display.put("cmd_display_" + MPIOCHECK_CMD_MAP_OLD['id'] + diskNo, cmdEcho)
            status, result = self.getResultMsg(cmd, cmdEcho)
            resultStatus += result
            if not status:
                failedItems.append(diskNo)
                continue
            util.updateItemProgress(context, constants.PROG70)


            for line in cmdEcho.splitlines():
                if "vendor" in line.lower() and \
                        "huawei" not in line.lower():
                    util.log.info(self.context,
                                  "[Solaris] found not huawei lun: %s."
                                  % line)
                    break
                strip_line = line.strip().lower()
                if "asymmetric" in strip_line:
                    util.log.info(self.context, "[Solaris] found current ALUA configuration: %s." % line)
                    items = line.split(":")
                    if len(items) > 1 and items[1].lower().strip() == 'yes':
                        util.log.info(self.context, "[Solaris] found lun with ALUA working: %s." % line)
                        contentParse .saveAluaStatusAndCliRet2ForeEval (ALUA_ENABLED, cmdEchos, self.context)
                        self.cmd_display.put("err_msg", resultStatus)
                        util.updateItemProgress(context, constants.PROG90)
                        alua_flag = True
                if strip_line.startswith(
                        'access state:') and self.access_flag is False:
                    if "active optimized" in line.lower() or \
                            "active not optimized" in line.lower():
                        util.log.info(self.context,
                                      "[Solaris] found access state "
                                      "working: %s." % line)
                        contentParse.save_access_status_and_cliret_2_foreval(
                            ALUA_NOT_ENABLED, cmdEchos,
                            'solartis.failed.query.host.lun.configs.err',
                            self.context,  self.access_flag)
                        util.updateItemProgress(context, constants.PROG90)
                        self.access_flag = True
                    else:
                        contentParse.save_access_status_and_cliret_2_foreval(
                            ALUA_ENABLED, cmdEchos,
                            PASS,
                            self.context,  self.access_flag)
                        util.updateItemProgress(context, constants.PROG90)
                        self.access_flag = True
                if alua_flag and self.access_flag:
                    return self.cmd_display
        if self.access_flag is False:
            contentParse.save_access_status_and_cliret_2_foreval(
                ALUA_ENABLED, cmdEchos, PASS, self.context, self.access_flag)
        if alua_flag:
            return self.cmd_display
        if failedItems:
            util.log.info(self.context, "[solaris]found disk failed querying ALUA info")
            contentParse .saveAluaStatusAndCliRet2ForeEval (ALUA_FIGURE_UNKNOWN, cmdEchos, self.context)
        else:
            util.log.info(self.context, "[solaris]found all specified disk  ALUA not opened")
            contentParse .saveAluaStatusAndCliRet2ForeEval (ALUA_NOT_ENABLED, cmdEchos, self.context)

        self.cmd_display.put("err_msg", resultStatus)
        util.updateItemProgress(context, constants.PROG90)
        return self.cmd_display

    def upadm_check(self, context, cmdEchos, resultStatus):
        """
        solaris版本及配套检查加入的多路径检查
        :param context:
        :return:
        """
        cmdEcho = \
            self.sshCon.execCmdWithTimout(
                SOLARIS_UPADM_VERSION['cmd'],
                constants.LINUX_UPSCAN_CMD_TIMEOUT)
        util.updateItemProgress(context, constants.PROG20)
        self.cmd_display.put("cmd_display_" + SOLARIS_UPADM_VERSION['id'],
                             cmdEcho)
        cmdEchos += cmdEcho
        status, result = self.getResultMsg(SOLARIS_UPADM_VERSION['cmd'],
                                           cmdEcho)
        resultStatus += result
        if not status:
            contentParse.save_access_status_and_cliret_2_foreval(
                ALUA_NOT_ENABLED, cmdEcho, 'multipath.aix.get.version.failed',
                self.context, self.access_flag)
            self.access_flag = True
            return cmdEchos, resultStatus
        if 'not found' not in cmdEcho:
            contentParse.save_access_status_and_cliret_2_foreval(
                ALUA_ENABLED, cmdEcho, PASS, self.context, self.access_flag)
            self.access_flag = True
        return cmdEchos, resultStatus

    def solaris_version_check(self, context, cmdEchos, resultStatus):
        """
        solaris版本及配套检查加入的solaris版本的检查
        :param context:
        :param cmdEchos:
        :param resultStatus:
        :return:
        """
        if self.access_flag:
            return cmdEchos, resultStatus
        try:
            cmdEcho = \
                self.sshCon.execCmdWithTimout(
                    SOLARIS_CMD_MAP['cmd'], constants.LINUX_UPSCAN_CMD_TIMEOUT)
            util.updateItemProgress(context, constants.PROG30)
            cmdEchos += cmdEcho
            self.cmd_display.put("cmd_display_" + SOLARIS_CMD_MAP['id'],
                                 cmdEcho)
            status, result = self.getResultMsg(SOLARIS_CMD_MAP['cmd'], cmdEcho)
            resultStatus += result
            if not status:
                contentParse.save_access_status_and_cliret_2_foreval(
                    ALUA_NOT_ENABLED, cmdEchos,
                    'solartis.failed.query.host.configs',
                    self.context, self.access_flag)
                self.access_flag = True
                return cmdEchos, resultStatus
            lines = cmdEcho.splitlines()
            version = ""
            for line in lines:
                if 'branch:' in line.lower():
                    version = line.split(r':')[1].strip()
                    util.log.error(self.context,
                                   "[Solaris] check version is:" + version)
                    break
            if not version:
                contentParse.save_access_status_and_cliret_2_foreval(
                    ALUA_NOT_ENABLED, cmdEchos,
                    'solartis.failed.query.host.configs',
                    self.context, self.access_flag)
                self.access_flag = True
                return cmdEchos, resultStatus
            if util.compare_version(MINIMUM_VERSION,
                                    version) > 0 or util.compare_version(
                    LARGEST_VERSION, version) <= 0:
                contentParse.save_access_status_and_cliret_2_foreval(
                    ALUA_ENABLED, cmdEchos, PASS,
                    self.context, self.access_flag)
                self.access_flag = True
        except Exception as e:
            util.log.error(self.context,
                           "[Solaris] check version error:" + str(e))
            contentParse.save_access_status_and_cliret_2_foreval(
                ALUA_NOT_ENABLED, cmdEchos,
                'solartis.failed.query.host.configs',
                self.context, self.access_flag)
            self.access_flag = True
        return cmdEchos, resultStatus

    def stmsboot_check(self, context, cmdEchos, resultStatus):
        """
        solaris版本及配套检查加入的自带多路径检查
        :param context:
        :param cmdEchos:
        :param resultStatus:
        :return:
        """
        if self.access_flag:
            return cmdEchos, resultStatus
        cmdEcho = \
            self.sshCon.execCmdWithTimout(
                SOLARIS_STMSBOOT_MAP['cmd'],
                constants.LINUX_UPSCAN_CMD_TIMEOUT)
        cmdEchos += cmdEcho
        util.updateItemProgress(context, constants.PROG50)
        self.cmd_display.put("cmd_display_" + SOLARIS_STMSBOOT_MAP['id'],
                             cmdEcho)
        status, result = self.getResultMsg(SOLARIS_STMSBOOT_MAP['cmd'],
                                           cmdEcho)
        resultStatus += result
        if not status:
            contentParse.save_access_status_and_cliret_2_foreval(
                ALUA_NOT_ENABLED, cmdEcho, 'multipath.aix.get.version.failed',
                self.context, self.access_flag)
            self.access_flag = True
            return cmdEchos, resultStatus

        if 'stms device name' not in cmdEcho.lower():
            contentParse.save_access_status_and_cliret_2_foreval(
                ALUA_ENABLED, cmdEcho, PASS, self.context, self.access_flag)
            self.access_flag = True
        return cmdEchos, resultStatus

    def parse4HuaweiDiskWwn(self, cmdEcho):
        '''
        @summary: parse 4 huawei's disk logic number
        @return: diskNo. list
        '''
        huaweiDisks = []
        diskAndWwnPattern = re.compile(r".*t([/\d|a-f|A-F]{32})d.*",
                                       flags=re.IGNORECASE)

        for line in cmdEcho.splitlines():
            match = diskAndWwnPattern.search(line)
            if not match:
                continue
            huaweiDisks.append(line.strip())
        return huaweiDisks

    def getResultMsg(self, step_name, cmd_display_temp):
        '''
        @summary: get result status's message
        '''
        result_msg = ""
        result = True
        if None == cmd_display_temp or '' == cmd_display_temp or\
            'TOOLKIT_SEND_CMD_TIME_OUT' in  cmd_display_temp or\
                'TOOLKIT_EXE_CMD_FAILED' in cmd_display_temp:
            result = False

        if "en" == self.lang:
            if result:
                result_msg += step_name + ":\texecute success\r\n"
            else:
                result_msg += step_name + ":\texecute failed\r\n"
        else:
            if result:
                result_msg += step_name + u":\t执行成功\r\n"
            else:
                result_msg += step_name + u":\t执行失败\r\n"

        return result, result_msg
