# coding=utf-8
__author__ = '******'
# 获取solaris主机的磁盘管理信息
import re
import sys
import os 
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common import constants
from common import util
from hosts.sudo_utils import get_sudo_cmd
from hosts.sudo_utils import SOLARIS
CLI = None
LANGUAGE = None
CHECK_FAIL          =       0
CHECK_PASS          =       1
            
cmd_info_id = ["cmd_info_disk_mgt_zfs_get_all"     ,
               "cmd_info_disk_mgt_zpool_list"      ,
               "cmd_info_disk_mgt_zpool_status_v"  ,
               "cmd_info_disk_mgt_zpool_status_x"  ,
               "cmd_info_disk_mgt_zpool_iostat_v"  ,
               "cmd_info_disk_mgt_zpool_import"    ,
               "cmd_info_disk_mgt_zpool_history"   ,
               "cmd_info_disk_mgt_zpool_history_il",
               "cmd_info_disk_mgt_zpool_get_all"   ,
               "cmd_info_disk_mgt_df_k"            ]
            
cmd_info_desc = ["zfs get -rHp all ",
                 "zpool list",
                 "zpool status -v",
                 "zpool status -x",
                 "zpool iostat -v",
                 "zpool import",
                 "zpool history ",
                 "zpool history -il ",
                 "zpool get all ",
                 "df -k"]
cmd_info_zfs_list              =   "zfs list|awk '{print $1}'"
cmd_info_zpool_list              =   "zpool list|awk '{print $1}'"


def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = context.get("lang")
    cmd_display = context.get("ret_map")
    return check_and_get_result(cmd_execute(context, cmd_display, CLI, LANGUAGE))


# 取中间一个有效值
def check_and_get_result((fun_flag, result, fun_err_msg)):
    """
    :rtype : object
    """
    return result


def cmd_execute(context, cmd_display, CLI, LANGUAGE):
    tempStep = constants.PROG90 / len(cmd_info_id)
    curStep = tempStep
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    zfs_list = CLI.execCmdHasLog(cmd_info_zfs_list).splitlines()
    zpool_list = CLI.execCmdHasLog(cmd_info_zpool_list).splitlines()
    for rg in range(len(cmd_info_id)):
        curStep += tempStep
        util.updateItemProgress(context, curStep)
        if cmd_info_id[rg]=="cmd_info_disk_mgt_zfs_get_all":
            for zfs in zfs_list[2:]:
                if(rg<len(cmd_info_desc)):
                    cmd_display_temp = CLI.execCmdWithNoCheckResult(cmd_info_desc[rg] + zfs, 60)
                
                cmd_display.put("cmd_display"+(cmd_info_id[rg])[8:]+"_"+zfs, cmd_display_temp)
                if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                    if "en"==LANGUAGE:
                        fun_err_msg        +=cmd_info_desc[rg] + zfs + ":\texecute failed\r\n"
                    else:
                        fun_err_msg        +=cmd_info_desc[rg] + zfs + u":\t执行失败\r\n"
                else:
                    if "en"==LANGUAGE:
                        fun_err_msg        +=cmd_info_desc[rg] + zfs + ":\texecute success\r\n"
                    else:
                        fun_err_msg        +=cmd_info_desc[rg] + zfs + u":\t执行成功\r\n"
        if cmd_info_id[rg]=="cmd_info_disk_mgt_zpool_history" or cmd_info_id[rg]=="cmd_info_disk_mgt_zpool_history_il" or cmd_info_id[rg]=="cmd_info_disk_mgt_zpool_get_all":
            for zpool in zpool_list[2:]:
                if rg < len(cmd_info_desc):
                    cmd_display_temp = \
                        CLI.execCmdWithNoCheckResult(
                            get_sudo_cmd(cmd_info_desc[rg], SOLARIS,
                                         context) + zpool, 60)
                cmd_display.put("cmd_display"+(cmd_info_id[rg])[8:]+"_"+zpool, cmd_display_temp)
                if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                    if "en"==LANGUAGE:
                        fun_err_msg        +=cmd_info_desc[rg] + zpool + ":\texecute failed\r\n"
                    else:
                        fun_err_msg        +=cmd_info_desc[rg] + zpool + u":\t执行失败\r\n"
                else:
                    if "en"==LANGUAGE:
                        fun_err_msg        +=cmd_info_desc[rg] + zpool + ":\texecute success\r\n"
                    else:
                        fun_err_msg        +=cmd_info_desc[rg] + zpool + u":\t执行成功\r\n"
        else:
            if cmd_info_id[rg]=="cmd_info_disk_mgt_echo_format" or cmd_info_id[rg]=="cmd_info_disk_mgt_zpool_import":
                if rg < len(cmd_info_desc):
                    cmd_display_temp = \
                        CLI.execCmdWithNoCheckResult(
                            get_sudo_cmd(cmd_info_desc[rg], SOLARIS, context),
                            300)
            else:
                if rg < len(cmd_info_desc):
                    cmd_display_temp = \
                        CLI.execCmdWithNoCheckResult(
                            get_sudo_cmd(cmd_info_desc[rg], SOLARIS, context),
                            60)
            cmd_display.put("cmd_display"+(cmd_info_id[rg])[8:], cmd_display_temp)
            if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                if "en"==LANGUAGE:
                    fun_err_msg        +=cmd_info_desc[rg] + ":\texecute failed\r\n"
                else:
                    fun_err_msg        +=cmd_info_desc[rg] + u":\t执行失败\r\n"
            else:
                if "en"==LANGUAGE:
                    fun_err_msg        +=cmd_info_desc[rg] + ":\texecute success\r\n"
                else:
                    fun_err_msg        +=cmd_info_desc[rg] + u":\t执行成功\r\n"
    cmd_display.put("err_msg", fun_err_msg)
    fun_flag = CHECK_PASS
    return fun_flag, cmd_display, fun_err_msg