# coding=utf-8
__author__ = '******'
# 获取solaris主机的HBA卡信息
import re
CLI = None
LANGUAGE = None
CHECK_FAIL          =       0
CHECK_PASS          =       1
cmd_info_solaris8_9 = {"cmd_info_luxadm_port" :       "luxadm -e port",
                       "cmd_info_luxadm_dump" :       "luxadm -e dump_map "}
cmd_info_solaris10  = {"cmd_info_fcinfo" :       "fcinfo hba-port"}
cmd_info_hba_list = "luxadm -e port|grep devices|awk '{print $1}'"

import traceback
import sys
import os
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common import constants
from common.contentParse import * 
from common.util import *
from hosts.sudo_utils import get_sudo_cmd
from hosts.sudo_utils import SOLARIS

global cmd_info_number
cmd_info_number = 0
cmd_info_id_tmo = "cmd_info_hba_card_tmo" 

def execute(context):
    
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """

    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    global ctx
    ctx = context
    global LANGUAGE
    LANGUAGE = context.get("lang")
    dev_type=context.get("dev_type")
    global cmd_info_id
    global cmd_info_desc
    if dev_type.split()[1] == "8" or dev_type.split()[1] == "9":
        cmd_info_id = ["cmd_info_hba_card_luxadm_port",
                       "cmd_info_hba_card_luxadm_dump",
                       "cmd_info_hba_card_fcinfo",
                       "cmd_info_hba_card_port_startinfo",
                       "cmd_info_hba_card_iscsi"]
        cmd_info_desc = ["luxadm -e port",
                         "luxadm -e dump_map ",
                         "fcinfo hba-port",
                         "mpathadm show initiator-port",
                         "iscsiadm list initiator-node"]
    else:
        cmd_info_id = ["cmd_info_hba_card_fcinfo",
                       "cmd_info_hba_card_port_startinfo",
                       "cmd_info_hba_card_iscsi"]
        cmd_info_desc = ["fcinfo hba-port",
                         "mpathadm show initiator-port",
                         "iscsiadm list initiator-node"]
    
    # 新增命令，查询启动器信息 不区分版本
    
    cmd_display = context.get("ret_map")
    cmd_execute(cmd_display, CLI, LANGUAGE, context)
    
    #获取HBA卡的超时时间
    HbaCardInfoList = getHbaCardTimeout(context)
    if not HbaCardInfoList:
        HbaCardInfoStr = "NA"
    else:
        HbaCardInfoStr = str(HbaCardInfoList)
    getStringRet(context, HbaCardInfoStr.replace("u\'", "\'"))
    errMsgHbaInfo = context.get("ret_map").get("err_msg") 

    errMsgTMO = context.get("ret_map").get("err_msg") 
    errMsgFinal = errMsgHbaInfo  + errMsgTMO
    updateItemProgress(context, constants.PROG90)
    context.get("ret_map").put("err_msg", errMsgFinal)
    return context

def getOnlineHBACardManu(context):
    CLI = context.get("SSH")
    
    hbaCardManuList = []
    cmd = get_sudo_cmd("fcinfo hba-port", SOLARIS, context)
    fcPortInfo = CLI.execCmdHasLog(cmd)
    if "not found" in fcPortInfo:
        return None
    if "HBA Port WWN" not in fcPortInfo:
        return hbaCardManuList
    state = ""
    manu = ""
    for line in fcPortInfo.splitlines():
        if line.strip().startswith("Manufacturer"):
            if "Emulex" in line:
                manu = "Emulex"
            elif "QLogic" in line:
                manu = "QLogic"
        elif line.strip().startswith("State"):
            if manu and "online" in line:
                hbaCardManuList.append(manu)
            else:
                state = ""
                manu = ""     
    return  hbaCardManuList          

def getHbaCardTimeout(context):
    '''
    @summary: get timeout of HBA card in HP-UX system
    @param context: Python execution context.
    @return: None
    '''
    HbaCardInfoList = []
    CLI = context.get("SSH")
    
    hbaCardManuList = getOnlineHBACardManu(context)
    updateItemProgress(context, constants.PROG35)
    if hbaCardManuList is None:
        HbaCardInfoDict = {"WWPN":"NA", "HBADriver":"NA", "Host":{"PortID":"NA", "HBAName":"NA"}, "Timeout":"Error", "HBAModel":"NA"}
        HbaCardInfoList.append(HbaCardInfoDict)
        return HbaCardInfoList
    elif not hbaCardManuList:
        return HbaCardInfoList
    log.info(context, "Manus which HBA card port is online:" + str(hbaCardManuList))
    perStep = constants.PROG20/len(hbaCardManuList)
    #获取所有E卡的超时时间
    if "Emulex" in hbaCardManuList:
        command = "cat /kernel/drv/emlxs.conf  |grep linkup-delay"
        hbaTimeoutInfo = getSingleCommandPureRet(context, getCmdIndex(cmd_info_number), command)
        addItemProgress(context, perStep)
        HbaCardInfoDict = {"HBA model": "All Emulex cards", "Timeout":"NA"}
        if "linkup-delay=" in hbaTimeoutInfo:
            #获取并记录端口信息
            hbaTimeoutInfoLines =  hbaTimeoutInfo.splitlines()
            for line in hbaTimeoutInfoLines:
                if line.strip().startswith("linkup-delay="): 
                    HbaCardInfoDict["Timeout"] = "Error"
                    fields = line.split("=")
                    if len(fields) == 2: 
                        HbaCardInfoDict["Timeout"] = fields[1][:-1].strip()
                    break
        HbaCardInfoList.append(HbaCardInfoDict)
        log.info(context, "HbaCardInfoList:" + str(HbaCardInfoList))
    
    #获取所有Q卡的超时时间
    if "QLogic" not in hbaCardManuList:
        return HbaCardInfoList
    #通过qaucli插件进行查询
    parameterList = ["Please Enter Selection:", "Press <Enter> to continue:", "#"]
    hbaCardModelCmd_str = getSingleCommandPureRetWithSpecifiedTerminator(context, getCmdIndex(cmd_info_number), "qaucli", parameterList)
    if "command not found" in hbaCardModelCmd_str.strip() and hbaCardModelCmd_str.strip().endswith("#"):
        HbaCardInfoDict = {"WWPN":"NA", "HBADriver":"NA", "Host":{"PortID":"NA", "HBAName":"NA"}, "Timeout":"Unknown", "HBAModel":"NA"}
        HbaCardInfoList.append(HbaCardInfoDict)
        return HbaCardInfoList
    elif not hbaCardModelCmd_str.strip().endswith("Please Enter Selection:"):
        HbaCardInfoDict = {"WWPN":"NA", "HBADriver":"NA", "Host":{"PortID":"NA", "HBAName":"NA"}, "Timeout":"Error", "HBAModel":"NA"}
        HbaCardInfoList.append(HbaCardInfoDict)
        return HbaCardInfoList
        
    hbaCardModelCmd_str = getSingleCommandPureRetWithSpecifiedTerminator(context, getCmdIndex(cmd_info_number), "2", parameterList)
    if not hbaCardModelCmd_str.strip().endswith("Please Enter Selection:"):
        HbaCardInfoDict = {"WWPN":"NA", "HBADriver":"NA", "Host":{"PortID":"NA", "HBAName":"NA"}, "Timeout":"Error", "HBAModel":"NA"}
        HbaCardInfoList.append(HbaCardInfoDict)
        return HbaCardInfoList
    
    hbaCardModelCmd_str = getSingleCommandPureRetWithSpecifiedTerminator(context, getCmdIndex(cmd_info_number), "3", parameterList)
    if not hbaCardModelCmd_str.strip().endswith("Please Enter Selection:"):
        HbaCardInfoDict = {"WWPN":"NA", "HBADriver":"NA", "Host":{"PortID":"NA", "HBAName":"NA"}, "Timeout":"Error", "HBAModel":"NA"}
        HbaCardInfoList.append(HbaCardInfoDict)
        return HbaCardInfoList
    
    hbaModelRes_list = hbaCardModelCmd_str.splitlines()
    for modeRes in hbaModelRes_list:
        #查询一个端口的信息
        if 'hba model' in modeRes.lower():
            qModel = modeRes.strip().split(" ")[2]
            
        if 'port' in modeRes.lower() and 'wwpn' in modeRes.lower():
            if "link down" in modeRes.lower():
                continue
            infoDatas = modeRes.strip().split(":")
            if len(infoDatas) <= 3:
                continue
            
            try:
                #初始化一个端口信息
                qPort = infoDatas[0].strip()
                wwpn = infoDatas[-1].strip().split(" ")[0].strip()
                HbaCardInfoDict = {"WWPN":wwpn, "HBADriver":"NA", "Host":{"PortID":qPort, "HBAName":"NA"}, "Timeout":"Error", "HBAModel":qModel}
                
                #获取HBA卡配置信息
                hbaCardModelCmd_str = getSingleCommandPureRetWithSpecifiedTerminator(context, getCmdIndex(cmd_info_number), qPort, parameterList)
                addItemProgress(context, constants.PROG10)
                if not hbaCardModelCmd_str.strip().endswith("Please Enter Selection:"):
                    HbaCardInfoList.append(HbaCardInfoDict)
                    break

                hbaCardModelCmd_str = getSingleCommandPureRetWithSpecifiedTerminator(context, getCmdIndex(cmd_info_number), "1", parameterList)
                addItemProgress(context, constants.PROG10)
                if not hbaCardModelCmd_str.strip().endswith("Press <Enter> to continue:"):
                    HbaCardInfoList.append(HbaCardInfoDict)
                    break
                
                hbaCardInfoLines = hbaCardModelCmd_str.splitlines()
                for line in hbaCardInfoLines:
                    if "Port Down Retry Count" in line:
                        fields = line.split(":")
                        if len(fields) == 2:
                            timeOut = fields[-1].strip()
                            #保存一个端口信息
                            HbaCardInfoDict["Timeout"] = timeOut
                        break
                
                hbaCardModelCmd_str = CLI.execCtrlCmd("13", 300, parameterList)
                addItemProgress(context, constants.PROG5)
                context.get("ret_map").put("cmd_display" + getCmdIndex(cmd_info_number)[8:], hbaCardModelCmd_str)
                if not hbaCardModelCmd_str.strip().endswith("Please Enter Selection:"):
                    HbaCardInfoList.append(HbaCardInfoDict)
                    break
                
                #执行0退回到上一级选项
                hbaCardModelCmd_str = getSingleCommandPureRetWithSpecifiedTerminator(context, getCmdIndex(cmd_info_number), "0", parameterList)
                addItemProgress(context, constants.PROG5)
                if not hbaCardModelCmd_str.strip().endswith("Please Enter Selection:"):
                    HbaCardInfoList.append(HbaCardInfoDict)
                    break
                
                HbaCardInfoList.append(HbaCardInfoDict)
            except:
                log.error(context, "[getHbaCardTimeout] except trace back:" + unicode(traceback.format_exc()))
                continue
            
    CLI.execCmdHasLog("ex")
    log.info(context, "this device system allCard infomation is:" + str(HbaCardInfoList))
    return HbaCardInfoList

"""获取命令序号"""
def getCmdIndex(temp):
    global cmd_info_number
    
    cmd_info_number = temp + 1
    return cmd_info_id_tmo + "_" + str(cmd_info_number)


def cmd_execute(cmd_display, CLI, LANGUAGE, context):
    fun_err_msg = ''
    hba_list = CLI.execCmdHasLog(
        get_sudo_cmd(cmd_info_hba_list, SOLARIS, context)).splitlines()
    updateItemProgress(ctx, constants.PROG5)

    for rg in range(len(cmd_info_id)):
        if cmd_info_id[rg]=="cmd_info_hba_card_luxadm_dump":
            preStepHba = constants.PROG15 /len(hba_list)
            for hba in hba_list[1:]:
                cmd_display_temp=CLI.execCmdHasLogTimout(cmd_info_desc[rg] + hba,60)
                addItemProgress(ctx, preStepHba)
                cmd_display.put("cmd_display"+(cmd_info_id[rg])[8:]+"_"+hba, cmd_display_temp)
                if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                    if "en"==LANGUAGE:
                        fun_err_msg        +=cmd_info_desc[rg] + hba + ":\texecute failed\r\n"
                    else:
                        fun_err_msg        +=cmd_info_desc[rg] + hba + u":\t执行失败\r\n"
                else:
                    if "en"==LANGUAGE:
                        fun_err_msg        +=cmd_info_desc[rg] + hba + ":\texecute success\r\n"
                    else:
	                    fun_err_msg        +=cmd_info_desc[rg] + hba + u":\t执行成功\r\n"
        else:
            cmd_display_temp = CLI.execCmdHasLogTimout(
                get_sudo_cmd(cmd_info_desc[rg], SOLARIS, context), 60)
            addItemProgress(ctx, constants.PROG5)
            cmd_display.put("cmd_display"+(cmd_info_id[rg])[8:], cmd_display_temp)
            if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                if "en"==LANGUAGE:
                    fun_err_msg        +=cmd_info_desc[rg] + ":\texecute failed\r\n"
                else:
                    fun_err_msg        +=cmd_info_desc[rg] + u":\t执行失败\r\n"
            else:
                if "en"==LANGUAGE:
                    fun_err_msg        +=cmd_info_desc[rg] + ":\texecute success\r\n"
                else:
                    fun_err_msg        +=cmd_info_desc[rg] + u":\t执行成功\r\n"
    cmd_display.put("err_msg", fun_err_msg)
    return
