# coding=utf-8
__author__ = '******'
# 获取linux主机的逻辑卷信息
import re
import sys
import os 
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common import constants
from common import util
CLI = None
LANGUAGE = None
CHECK_FAIL          =       0
CHECK_PASS          =       1
cmd_info_id = ["cmd_info_logic_volume_pkginfo"   ,
               "cmd_info_logic_volume_metadb"    ,
               "cmd_info_logic_volume_metaset"   ,
               "cmd_info_logic_volume_metastat"  ,
               "cmd_info_logic_volume_metastat_p",
               "cmd_info_logic_volume_metastat_setname",
               "cmd_info_logic_volume_metastat_ps_",
               ]

cmd_info_desc = ["pkginfo -l VRTSvxvm",
                 "metadb",
                 "metaset",
                 "metastat",
                 "metastat -p",
                 "metaset | grep 'Set name'",
                 "metastat -p -s ",
                 ]


def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = context.get("lang")
    cmd_display = context.get("ret_map")
    return check_and_get_result(cmd_execute(context, cmd_display, CLI, LANGUAGE))


# 取中间一个有效值
def check_and_get_result((fun_flag, result, fun_err_msg)):
    """
    :rtype : object
    """
    return result


def cmd_execute(context, cmd_display, CLI, LANGUAGE):
    tempStep = constants.PROG90 / len(cmd_info_id)
    curStep = tempStep
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    for rg in range(len(cmd_info_id)):
        curStep += tempStep
        util.updateItemProgress(context, curStep)
        if cmd_info_id[rg] == "cmd_info_logic_volume_metastat_ps_":
            set_metastat(cmd_display, cmd_info_id[rg], cmd_info_desc[rg])
            continue
        cmd_display_temp = CLI.execCmdHasLogTimout(cmd_info_desc[rg],60)
        cmd_display.put("cmd_display"+(cmd_info_id[rg])[8:], cmd_display_temp)
        if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
            if "en"==LANGUAGE:
                fun_err_msg        +=cmd_info_desc[rg] + ":\texecute failed\r\n"
            else:
                fun_err_msg        +=cmd_info_desc[rg] + u":\t执行失败\r\n"
        else:
            if "en"==LANGUAGE:
                fun_err_msg        +=cmd_info_desc[rg] + ":\texecute success\r\n"
            else:
                fun_err_msg        +=cmd_info_desc[rg] + u":\t执行成功\r\n"
    cmd_display.put("err_msg", fun_err_msg)
    fun_flag = CHECK_PASS
    return fun_flag, cmd_display, fun_err_msg


def set_metastat(cmd_display, cmd_id, desc):
    """
    组装metastat数据
    :param cmd_display: 数据存储
    :param cmd_id: 命令描述
    :param desc: 命令
    """
    set_name_info = CLI.execCmdHasLogTimout("metaset | grep 'Set name'", 60)
    set_names = []
    for line in set_name_info.splitlines():
        if line.startswith("Set name"):
            set_names.append(line.split()[3][:-1])
    for set_name in set_names:
        command = desc + set_name
        set_name_detail = CLI.execCmdHasLogTimout(command, 60)
        cmd_display.put("cmd_display" + cmd_id[8:] + set_name, set_name_detail)
