# coding=utf-8
MULTIPATH_STMSBOOT_L = 'cmd_info_multipath_stmsboot_l'
__author__ = '******'
# 获取solaris主机的多路径信息
import os
import re
import sys
import traceback

path = os.path.dirname(os.path.abspath(__file__))
sys.path.append(path)
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common import util
from common.util import MultipathCoexistenceInfo
from common import contentParse
from common import constants
from com.huawei.ism.tool.infograb.context import EvalResultEnum
from solaris_lun_wwn_info import get_result_info
from hosts.sudo_utils import get_sudo_cmd
from hosts.sudo_utils import SOLARIS
from common import content_utils

CLI = None
LANGUAGE = None
# 设备硬盘路径
DEV_DSK_PATH = '/dev/rdsk/'
CHECK_FAIL = 0
CHECK_PASS = 1
CHECK_ERROR = -1
# 多路径版本边界
UTRL_PATH_VERSION = 801051
# 自带多路径管理磁盘查询命令
LIST_LU_GREP_RDSK = 'mpathadm list lu|grep rdsk'
LIST_LU_GREP_RDSK_AWK = "mpathadm list lu|grep rdsk|awk '{print $1}'"
# 查询VLUN命令详细信息
VLUN_QUERY_CMD = 'upadm show vlun id='
EVAL_RESULT_KEY = 'evalResult'
STMSBOOT_CMD = 'stmsboot -L'
LUXADM_PROBE = 'luxadm probe'
STMS_MULTIPATH_ENABLED = 'STMS device name'
MULTIPATH_CHECK_ITEMKEY = 'multiPathStatus'
cmd_info_id = [
    "cmd_info_multipath_mpathadm_list_lu"]

cmd_info_desc = ["mpathadm list lu"]


def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = context.get("lang")
    global COEXSISTANCE
    COEXSISTANCE = False
    cmd_display = context.get("ret_map")
    global multiPathCoExistResult
    multiPathCoExistResult = MultipathCoexistenceInfo()
    get_result_info(context)
    return check_and_get_result(cmd_execute(cmd_display, CLI, LANGUAGE, context))


# 取中间一个有效值
def check_and_get_result((fun_flag, result, funErrMsg)):
    """
    :rtype : object
    """
    return result

def getPropProgress(singleProg):
    '''
    @summary: 获取恰当的进度显示
    :param singleProg:非共存下的进度
    :return:
    '''
    if COEXSISTANCE:
        return singleProg/2
    return singleProg
def evalHwSelfUtrlPath(context, version, cliReturn):
    '''
    @summary: 评估华为自研系统多路径
    @param param: context 上下文
    @param param: version 多路径版本
    '''
    version = version.replace('.', '').strip()
    # 查询VLunID列表
    vLunIds, queryVLunListCmd, cliRet = queryVlunIdArray(context, version)
    cliRet = cliReturn + '\r\n' + cliRet
    curStep = constants.PROG10
    curStep += getPropProgress(constants.PROG5)
    util.updateItemProgress(context, curStep)
    evalResult = ''
    hwFailCommand = multiPathCoExistResult.getHuaweiMultipath().getFailCommand()
    if hwFailCommand or str(hwFailCommand) != "":
        messageKey = 'eval.host.multipath.reduntpath.recommended.actions.network.connection'
        failParams = [queryVLunListCmd, "messageKey:eval.host.multipath.reduntpath.qry.array.lunpath.failed"]
        multiPathCoExistResult.getHuaweiMultipath().setFailCommand(queryVLunListCmd)
        multiPathCoExistResult.getHuaweiMultipath().setCliRet(cliRet)
        multiPathCoExistResult.getHuaweiMultipath().setfailDescribe(
            'eval.host.multipath.reduntpath.qry.multipathd.srv.sta.failed')
        return util.genEvalItemObj(MULTIPATH_CHECK_ITEMKEY, EvalResultEnum.FAILED, cliRet, messageKey, failParams)
    util.log.info(context, "VLun id:" + str(vLunIds))
    # 如果没有VLUN则提示无法评估
    if len(vLunIds) == 0:
        messageKey = 'eval.host.multipath.reduntpath.donot.get.disk.information'
        if queryVLunListCmd != None:
            multiPathCoExistResult.getHuaweiMultipath().setFailCommand(queryVLunListCmd)
            multiPathCoExistResult.getHuaweiMultipath().setCliRet(cliRet)
            multiPathCoExistResult.getHuaweiMultipath().setfailDescribe(
                'eval.host.multipath.reduntpath.nodata.hw.disk.managed.by.ultrapath')
        multiPathCoExistResult.getHuaweiMultipath().setCliRet(cliRet)
        return util.genEvalItemObj(MULTIPATH_CHECK_ITEMKEY, EvalResultEnum.FAILED, cliRet, messageKey,
                                           ['upadm show vlun type=all' if int(version) > UTRL_PATH_VERSION else 'upadm show vlun'])
    retMap = context.get("ret_map")
    vLunInfos = ''
    noReduntVlun = []
    noReduntHyperVlun = []
    queryErrorVlun = []
    multiPathCoExistResult.getHuaweiMultipath().setControl(True)
    queryFailCmds = []
    # 循环检查每个VLUN的多路径信息
    idx = 0
    prgStep, stepsUnit = util.calcPerStepDetail(getPropProgress(constants.PROG70), len(vLunIds))
    cliRet += util.query_show_path_info(context, "upadm show path")
    for vlunId in vLunIds:
        execCmd = get_sudo_cmd(VLUN_QUERY_CMD, SOLARIS, context) + vlunId
        execCmd = execCmd + ' type=all' if int(version) > UTRL_PATH_VERSION else execCmd
        vLunInfo = CLI.execCmdWithNoCheckResult(execCmd, constants.HOST_CMD_TIMEOUT)
        util.injectRet2Context(context, vLunInfo, 'cmd_display_multipath_vlunInfo', execCmd)
        util.itemProgressIncr(context, idx, prgStep, stepsUnit)
        idx += 1
        vLunInfos += vLunInfo + '\r\n'
        result, isHyperMetroLun = checkIfhaveReduntPath(context, vLunInfo, vlunId)
        if CHECK_ERROR == result:
            queryErrorVlun.append(vlunId)
            queryFailCmds.append(execCmd)
            continue
        if CHECK_FAIL == result:
            if not isHyperMetroLun:
                noReduntVlun.append(str(vlunId))
            else:
                noReduntHyperVlun.append(str(vlunId))
    contentParse.setCmdRet4EvalAndReport(retMap, vLunInfos, 'cmd_info_multipath_vluninfos_Details')
    if len(queryFailCmds) > 0:
        # 多路径信息查询失败提示
        util.log.info(context, "queryerrorId:" + str(queryErrorVlun))
        failCmdsStr = ','.join(queryFailCmds)
        multiPathCoExistResult.getHuaweiMultipath().setFailCommand(failCmdsStr)
        multiPathCoExistResult.getHuaweiMultipath().setCliRet(cliRet + '\r\n' + vLunInfos)
        multiPathCoExistResult.getHuaweiMultipath().setfailDescribe("qry.single.lunpath.failed")
        messageKey = "eval.host.multipath.reduntpath.recommended.actions.network.connection"
        params = [failCmdsStr, "messageKey:qry.single.lunpath.failed"]
        return util.genEvalItemObj(MULTIPATH_CHECK_ITEMKEY, EvalResultEnum.FAILED, cliRet + '\r\n' + vLunInfos, messageKey, params)
    # 如果每个VLUN都有冗余路径，评估通过
    paramList = [CLI.getHost()]
    if not noReduntVlun and not noReduntHyperVlun:
        multiPathCoExistResult.getHuaweiMultipath().setCliRet(cliRet + '\r\n' + vLunInfos)
        return util.genEvalItemObj(MULTIPATH_CHECK_ITEMKEY, EvalResultEnum.PASSED, cliRet + '\r\n' + vLunInfos, None)
    elif noReduntVlun and not noReduntHyperVlun:
        # 部分通过，进行提示
        messageKey = "eval.host.multipath.reduntpath.ultrapath.donot.have.redundant.path"
        paramList.append(','.join(noReduntVlun))
        multiPathCoExistResult.getHuaweiMultipath().setCliRet(cliRet + '\r\n' + vLunInfos)
        multiPathCoExistResult.getHuaweiMultipath().setNoRedundantPath(','.join(noReduntVlun))
    elif not noReduntVlun and noReduntHyperVlun:
        messageKey = constants.ULTRA_HYPER_METRO_VLUN_NOT_PASS_TIPS
        paramList.append(','.join(noReduntHyperVlun))
        multiPathCoExistResult.getHuaweiMultipath().setCliRet(cliRet + '\r\n' + vLunInfos)
        multiPathCoExistResult.getHuaweiMultipath().setNoRedundantPath(','.join(noReduntHyperVlun))
    else:
        messageKey = constants.ULTRA_VLUN_NOT_PASS_TIPS
        paramList.append(','.join(noReduntVlun))
        paramList.append(','.join(noReduntHyperVlun))
        notPasshIds = list(set(noReduntVlun + noReduntHyperVlun))
        noRpathVlunIdStr = ','.join(notPasshIds)
        multiPathCoExistResult.getHuaweiMultipath().setNoRedundantPath(noRpathVlunIdStr)
        multiPathCoExistResult.getHuaweiMultipath().setCliRet(cliRet + '\r\n' + vLunInfos)
    singleEvalResult = util.genEvalItemObj(MULTIPATH_CHECK_ITEMKEY, EvalResultEnum.FAILED, cliRet + '\r\n' + vLunInfos, messageKey,
                                                   paramList)
    return singleEvalResult


def checkHyperMetroReduntPath(context, vLunInfo, vlunId):
    '''
        @summary: 检查自带双活多路径是否冗余
        @param param: context 上下文
        @param param: vLunInfo vLunInfo
        @param param: vlunId vlunId
    '''
    util.log.info(context, "current is Hyper Metro lun")
    eachLines = vLunInfo.splitlines()
    membersRangeIndex = []
    arraySnSet = set()
    # 记录aggregation member#出现位置
    for idx in range(len(eachLines)):
        line = eachLines[idx]
        if 'aggregation member#' in line.lower() and 'infomation' in line.lower():
            membersRangeIndex.append(idx + 1)
        if 'array sn' in line.lower():
            arraySnSet.add(line.split(':')[1].strip())

    if len(arraySnSet) == 1:
        util.log.info(context, "Sub LUN from same array or only one sub lun exists.")
        return False

    membersRangeIndex.append(len(eachLines))
    finalResult = True
    for pIdx in range(len(membersRangeIndex) - 1):
        ctrlStrAppearIndex = []
        memLines = eachLines[membersRangeIndex[pIdx]:membersRangeIndex[pIdx + 1]]
        for ctrlIdx in range(len(memLines)):
            tgtLineLower = memLines[ctrlIdx].lower()
            if 'controller' in tgtLineLower and ':' not in tgtLineLower:
                ctrlStrAppearIndex.append(ctrlIdx)
        ctrlStrAppearIndex.append(len(memLines))
        singleRes = checkOneTgtHaveReduntPath(context, ctrlStrAppearIndex, memLines)
        finalResult = singleRes and finalResult
    return CHECK_PASS if finalResult else CHECK_FAIL


def checkIfhaveReduntPath(context, vLunInfo, vlunId):
    '''
    @summary: 检查自研多路径是否有冗余路径
    @param param: context 上下文
    @param param: vLunInfo Vlun信息
    @param param: vlunId VlunID
    '''
    try:
        lowerInfo = vLunInfo.lower()
        if (util.isCmdExecError(vLunInfo)):
            # 命令执行失败返回
            return CHECK_ERROR, False
        if 'aggregation type' in lowerInfo and 'migration' in lowerInfo:
            util.log.info(context, "Find migration LUN, ignore:" + str(vlunId))
            return CHECK_PASS, True

        # 检查双活多路径
        if 'Aggregation Type' in vLunInfo and 'Hyper Metro' in vLunInfo:
            checkResult = checkHyperMetroReduntPath(context, vLunInfo, vlunId)
            util.log.info(context, "final checkResult " + str(checkResult))
            return checkResult, True
        eachLines = vLunInfo.splitlines()
        ctrlStrAppearIndex = []
        # 记录Controller 多路径出现位置
        for index in range(len(eachLines)):
            tgtLineLower = eachLines[index].lower()
            if 'controller ' in tgtLineLower and ':' not in tgtLineLower:
                ctrlStrAppearIndex.append(index)
        ctrlStrAppearIndex.append(len(eachLines) - 1)
        checkResult = checkOneTgtHaveReduntPath(context, ctrlStrAppearIndex, eachLines)
        return CHECK_PASS if checkResult else CHECK_FAIL, False
    except Exception, e:
        util.log.error(context, 'calc redunt path exception:' + str(e))
        return CHECK_ERROR, False


def checkOneTgtHaveReduntPath(context, ctrlStrAppearIndex, eachLines):
    '''
    @summary: 检查单个对象是否存在冗余路径
    @param param:ctrlStrAppearIndex 控制器出现的索引
    @param param:eachLines 路径信息
    '''
    hasRedntCtrlId = []
    lun_path_ids = []
    exist_shared_card = False
    for line in eachLines:
        if util.is_exist_shared_card(line):
            exist_shared_card = True
        util.add_ultra_path_id(line, lun_path_ids)
    # 循环计算每个控制器上是否有冗余路径
    for pIdx in range(len(ctrlStrAppearIndex) - 1):
        singleResult = False
        ctrlIdx = ctrlStrAppearIndex[pIdx]
        ctrlInfos = eachLines[ctrlIdx].split()
        for num in range(ctrlIdx, ctrlStrAppearIndex[pIdx + 1]):
            findResult = re.findall(r'.+Path.+:\s+Normal', eachLines[num], re.I)
            singleResult = singleResult or len(findResult) > 0
        if singleResult and len(ctrlInfos) > 1:
            hasRedntCtrlId.append(ctrlInfos[1])
    util.log.info(context, " hasRedntCtrlId:" + str(hasRedntCtrlId))
    if exist_shared_card and hasRedntCtrlId:
        util.log.info(context, "exist two type card")
        return False
    is_redundant = util.hasRedundantPathForCtrlIdPath(context, hasRedntCtrlId)
    if not is_redundant:
        is_redundant = util.check_lun_redundant_by_path_id(context,
                                                           lun_path_ids)
    return is_redundant


def queryVlunIdArray(context, version):
    '''
    @summary: 查询多路径VLunID列表
    @param param:context 上下文
    @param param: version 多路径版本
    '''
    retMap = context.get("ret_map")
    util.log.info(context, "utrlpath version:" + version)

    queryVLunListCmd = get_sudo_cmd("upadm show vlun type=all", SOLARIS,
                                    context) if int(
        version) > UTRL_PATH_VERSION else get_sudo_cmd("upadm show vlun",
                                                       SOLARIS, context)
    # 查询VLUN信息
    vLunsCmdRet = CLI.execCmdWithNoCheckResult(queryVLunListCmd, constants.HOST_CMD_TIMEOUT)

    if (util.isCmdExecError(vLunsCmdRet)):
        multiPathCoExistResult.getHuaweiMultipath().setFailCommand(queryVLunListCmd)
        multiPathCoExistResult.getHuaweiMultipath().setfailDescribe("eval.host.multipath.reduntpath.qry.vlun.id.failed")
        multiPathCoExistResult.getHuaweiMultipath().setControl(False)
        multiPathCoExistResult.getHuaweiMultipath().setCliRet(vLunsCmdRet)
        return [], queryVLunListCmd, vLunsCmdRet
    contentParse.setCmdRet4EvalAndReport(retMap, vLunsCmdRet, 'cmd_info_multipath_vlun_infos')
    
    newErrMsg = util.buildOldAndNewErrMsg(context,queryVLunListCmd,vLunsCmdRet)
    context.get('ret_map').put('err_msg',newErrMsg)
    
    if "can" in vLunsCmdRet.lower() and "t find any vluns" in vLunsCmdRet.lower():
        util.log.info(context,"no vlun found.")
        return [], None, vLunsCmdRet
    util.log.info(context, "no vlun found.:" + vLunsCmdRet)
    lines = vLunsCmdRet.splitlines()
    vLunIdArray = []
    # 提取VLUN信息到数组
    for line in lines:
        lineWords = re.split('\\s+', line)
        # 取第二个作为VLunID
        if len(lineWords) > 1 and lineWords[1].isdigit():
            vLunIdArray.append(lineWords[1])
    return vLunIdArray, queryVLunListCmd, vLunsCmdRet


def calcBuildInNoReduntPath(context, stmsDiskListLines):
    '''
    @summary: 计算自带多路径没有冗余路径的链路
    @param param: context 上下文
    @param param: stmsDiskListLines CLI回显的消息行
    @param param: noRedntPaths 没有冗余路径的链路
    '''
    noRedntPaths = []
    hwDiskCliRet = []
    cliRets = []
    failedDiskInfos = []
    idx = 0
    prgStep, stepsUnit = util.calcPerStepDetail(getPropProgress(constants.PROG75), len(stmsDiskListLines))
    util.log.info(context, "start to eval buildin multipath")
    for line in stmsDiskListLines:
        diskCode = line.replace(DEV_DSK_PATH, '').strip()
        line = line.strip()
        if DEV_DSK_PATH in line:
            diskInfoCmd = 'mpathadm show lu ' + line
            diskInfoRet = CLI.execCmdWithNoCheckResult(diskInfoCmd, constants.HOST_CMD_TIMEOUT)
            context.get('ret_map').put('err_msg',util.buildOldAndNewErrMsg(context,diskInfoCmd,diskInfoRet))
            contentParse.setCmdRet4Report(context, diskInfoRet,"mpathadm_show_lu" + line )
            if (util.isCmdExecError(diskInfoRet)):
                failedDiskInfos.append(line)
                continue
            cliRets.append(diskInfoRet + ' \r\n')
            disk_info_lower = content_utils.delete_long_blank_line(diskInfoRet).lower()
            pattern = "|".join(map(lambda key_word: r' +vendor: +' + key_word + ' +',
                                   constants.HW_DISK_KEYWORD.split("|")))
            if 'vendor' in disk_info_lower and re.findall(pattern, disk_info_lower, re.I):
                util.log.info(context, "current is hw disk " + diskCode)
                hwDiskCliRet.append({'diskCode': diskCode, 'diskCliRet': diskInfoRet})
        util.itemProgressIncr(context, idx, prgStep, stepsUnit)
        idx += 1
    if (len(failedDiskInfos) > 0):
        multiPathCoExistResult.getSelfMultiPath().setFailCommand(','.join(failedDiskInfos))
        multiPathCoExistResult.getSelfMultiPath().setfailDescribe(
            'eval.host.multipath.reduntpath.no.hw.disk.managed.by.multipathd')
    if len(hwDiskCliRet) == 0:
        return False, cliRets, None
    multiPathCoExistResult.getSelfMultiPath().setControl(True)
    for diskInfo in hwDiskCliRet:
        if not isDiskHaveRedntPath(context, diskInfo['diskCliRet']):
            noRedntPaths.append(diskInfo['diskCode'])
    if len(noRedntPaths) > 0:
        multiPathCoExistResult.getSelfMultiPath().setNoRedundantPath(','.join(noRedntPaths))
    return True, cliRets, noRedntPaths


def evalSysBuildInMultiPath(context, stmsBootRtn):
    '''
    @summary: 评估系统自带系统多路径
    @param param: context 上下文
    @param param: version 多路径版本
    '''
    retMap = context.get('ret_map')
    stmsDiskRet = CLI.execCmdWithNoCheckResult(LIST_LU_GREP_RDSK, constants.HOST_CMD_TIMEOUT)
    cliRet = stmsBootRtn + '\r\n' + stmsDiskRet
    util.addItemProgress(context, getPropProgress(constants.PROG5))
    grepRdskCmdErrMsg = util.errorMsgHandler('',stmsDiskRet,LIST_LU_GREP_RDSK,LANGUAGE)
    oldErrMsg =  context.get('ret_map').get('err_msg')
    if not oldErrMsg:
        oldErrMsg = ""
    context.get('ret_map').put('err_msg', oldErrMsg + grepRdskCmdErrMsg)
    
    contentParse.setCmdRet4EvalAndReport(retMap, stmsDiskRet, 'cmd_info_multipath_rdisk_infos')
    if (util.isCmdExecError(stmsDiskRet)):
        multiPathCoExistResult.getSelfMultiPath().setCliRet(cliRet)
        multiPathCoExistResult.getSelfMultiPath().setFailCommand(LIST_LU_GREP_RDSK)
        messageKey = "eval.host.multipath.reduntpath.recommended.actions.network.connection"
        multiPathCoExistResult.getSelfMultiPath().setfailDescribe(
            "eval.host.multipath.reduntpath.no.hw.disk.managed.by.multipathd")
        return util.genEvalItemObj(MULTIPATH_CHECK_ITEMKEY, EvalResultEnum.FAILED, cliRet, messageKey,
                                           [LIST_LU_GREP_RDSK,
                                            "eval.host.multipath.reduntpath.no.hw.disk.managed.by.multipathd"])
    stmsDiskListLines = list(filter(lambda line: DEV_DSK_PATH in line, stmsDiskRet.splitlines()))
    if not stmsDiskListLines:
        multiPathCoExistResult.getSelfMultiPath().setCliRet(cliRet)
        messageKey = 'eval.host.multipath.reduntpath.donot.get.disk.information'
        evalResult = util.genEvalItemObj(MULTIPATH_CHECK_ITEMKEY, EvalResultEnum.FAILED, cliRet, messageKey,
                                                 [LIST_LU_GREP_RDSK])
        return evalResult
    buildInInfo = retMap.get(MULTIPATH_STMSBOOT_L) + " self manage disk."
    # 刷新自带多路径接管信息
    contentParse.setCmdRet4Report(context, buildInInfo, MULTIPATH_STMSBOOT_L)
    haveHWPath, diskInfos, noRedntPaths = calcBuildInNoReduntPath(context, stmsDiskListLines)
    cliRet = cliRet + '\r\n' + ''.join(diskInfos)
    contentParse.setCmdRet4EvalAndReport(retMap, diskInfos, 'cmd_info_multipath_rdisk_infos_details')
    selfFailCommand = multiPathCoExistResult.getSelfMultiPath().getFailCommand()
    if selfFailCommand:
        selfFailDesc = multiPathCoExistResult.getSelfMultiPath().getFailDescribe()
        multiPathCoExistResult.getSelfMultiPath().setCliRet(cliRet)
        messageKey = 'eval.host.multipath.reduntpath.recommended.actions.network.connection'
        failPArams = [selfFailCommand, "messageKey:" + selfFailDesc]
        return util.genEvalItemObj(MULTIPATH_CHECK_ITEMKEY, EvalResultEnum.FAILED, cliRet, messageKey, failPArams)
    # 没有华为磁盘
    if not haveHWPath:
        messageKey = 'eval.host.multipath.reduntpath.donot.get.disk.information'
        multiPathCoExistResult.getSelfMultiPath().setCliRet(cliRet)
        multiPathCoExistResult.getSelfMultiPath().setFailCommand(LIST_LU_GREP_RDSK)
        multiPathCoExistResult.getSelfMultiPath().setfailDescribe(
            "eval.host.multipath.reduntpath.nodata.self.disk.managed.by.buildin.multipath")
        return util.genEvalItemObj(MULTIPATH_CHECK_ITEMKEY, EvalResultEnum.FAILED, cliRet, messageKey,
                                           [LIST_LU_GREP_RDSK])
    # 如果都有冗余路径评估通过
    if len(noRedntPaths) == 0:
        multiPathCoExistResult.getSelfMultiPath().setCliRet(cliRet)
        return util.genEvalItemObj(MULTIPATH_CHECK_ITEMKEY, EvalResultEnum.PASSED, cliRet, None)
    messageKey = 'eval.host.multipath.reduntpath.self.donot.have.redundant.path'
    paramList = [CLI.getHost()]
    paramList.append(','.join(noRedntPaths))
    multiPathCoExistResult.getSelfMultiPath().setCliRet(cliRet)
    return util.genEvalItemObj(MULTIPATH_CHECK_ITEMKEY, EvalResultEnum.FAILED, cliRet, messageKey, paramList)


def isDiskHaveRedntPath(context, diskInfoRet):
    '''
    @summary: 检查自带多路径是否有冗余路径
    @param param: context 上下文
    @param param: diskInfoRet 硬盘信息回文
    '''
    diskInfoLines = diskInfoRet.splitlines()
    pathStatus = ''
    targetPortName = ''
    linkOkArray = []
    for line in diskInfoLines:
        if 'target port name:' in line.lower():
            targetPortName = line.split(':')[1].strip()
        if 'path state:' in line.lower():
            pathStatus = line.split(':')[1].strip()
        if pathStatus != '' and targetPortName != '':
            if 'ok' in pathStatus.lower():
                linkOkArray.append(targetPortName)
            pathStatus = ''
            targetPortName = ''
    ctrlIdArray = []
    for wwpn in linkOkArray:
        ctrlIdArray.append(util.parseWwpn(context, wwpn)[-1])
    return util.hasRedundantPathForCtrlIdPath(context, ctrlIdArray, True)


def evalMultipathReduntPath(stmsBootRtn, version, cliReturn, context):
    '''
    @summary: 评估多路径冗余路径
    @param param: version 版本
    @param param: context 上下文
    @param param: funErrMsg 错误消息
    '''
    # 是否自带多路径
    isBuildMultiPathInOpen = 'STMS device name' in stmsBootRtn or 'found fibre channel device' in stmsBootRtn.lower()
    # 是否自研多路径
    isUtrlPath = version != ''
    retMap = context.get("ret_map")
    # 都不存在
    if not isUtrlPath and not isBuildMultiPathInOpen:
        messageKey = 'eval.host.multipath.reduntpath.self&buildin.allnotexist'
        evalResult = util.genEvalItemObj(MULTIPATH_CHECK_ITEMKEY, EvalResultEnum.FAILED, cliReturn + '\r\n' + stmsBootRtn, messageKey, None)
        retMap.put(EVAL_RESULT_KEY, evalResult)
        return
    # 都存在继续评估并返回
    if isUtrlPath and isBuildMultiPathInOpen:
        global COEXSISTANCE
        COEXSISTANCE = True
        evalHwSelfUtrlPath(context, version, cliReturn)
        evalSysBuildInMultiPath(context, stmsBootRtn)
        multiPathCoExistResult.setCoexistence(True)
        multiPathCoExistResult.setHostIP(CLI.getHost())
        contentParse.addMultiPathResultToFile(retMap, multiPathCoExistResult.getJsonStr())
        return
    # 自研多路径执行相应逻辑
    if isUtrlPath:
        retMap.put(EVAL_RESULT_KEY, evalHwSelfUtrlPath(context, version, cliReturn))
    # 自带多路径
    if isBuildMultiPathInOpen:
        retMap.put(EVAL_RESULT_KEY, evalSysBuildInMultiPath(context, stmsBootRtn))


def cmd_execute(cmd_display, CLI, LANGUAGE, context):
    isSuccess, version, cliReturn = util.qryAndSaveUltrapathVersion(context)
    versionErrMsg = util.errorMsgHandler('', cliReturn, constants.QRY_ULTRAPATH_CMD, LANGUAGE)
    util.updateItemProgress(context, constants.PROG5)
    stmsBootRtn = CLI.execCmdWithNoCheckResult(
        get_sudo_cmd(STMSBOOT_CMD, SOLARIS, context),
        constants.HOST_CMD_TIMEOUT)
    util.updateItemProgress(context, constants.PROG10)
    util.log.info(context, "stmsBootRtn:" + stmsBootRtn + "cliReturn:" + cliReturn)
    contentParse.setCmdRet4Report(context, stmsBootRtn, MULTIPATH_STMSBOOT_L)
    funErrMsg = util.errorMsgHandler('', stmsBootRtn, STMSBOOT_CMD, LANGUAGE)
    if "TOOLKIT_SEND_CMD_TIME_OUT" in stmsBootRtn:
        stmsBootRtn = CLI.execCmdWithNoCheckResult(LUXADM_PROBE, constants.HOST_CMD_TIMEOUT)
        util.log.info(context, "luxadmRtn:" + stmsBootRtn + "cliReturn:" + cliReturn)
        contentParse.setCmdRet4Report(context, stmsBootRtn, 'cmd_info_multipath_luxadm_probe')
        funErrMsg = util.errorMsgHandler('', stmsBootRtn, LUXADM_PROBE, LANGUAGE)
    # 评估多路径冗余状态
    evalMultipathReduntPath(stmsBootRtn, version, cliReturn, context)
    
    evalMultipathErrMsg = context.get('ret_map').get('err_msg')
    if not evalMultipathErrMsg:
        evalMultipathErrMsg = ''
    
    #命令新增    luxadm display 显示系统上启动器信息
    pathlist = CLI.execCmdHasLogTimout(LIST_LU_GREP_RDSK_AWK, 60).splitlines()    
    if len(pathlist) > 1:
        for domain in pathlist[1:]:
            cmd_info_desc.append(
                get_sudo_cmd("luxadm display ", SOLARIS, context) + domain)
            cmd_info_id.append("cmd_info_multipath_luxadm_path_%s" % domain) 
               
    for rg in range(len(cmd_info_id)):
        cmd_display_temp = CLI.execCmdHasLogTimout(
            get_sudo_cmd(cmd_info_desc[rg], SOLARIS, context), 60)
        cmd_display.put("cmd_display" + (cmd_info_id[rg])[8:], cmd_display_temp)
        if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find(
                'TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
            if "en" == LANGUAGE:
                funErrMsg += cmd_info_desc[rg] + ":\texecute failed\r\n"
            else:
                funErrMsg += cmd_info_desc[rg] + u":\t执行失败\r\n"
        else:
            if "en" == LANGUAGE:
                funErrMsg += cmd_info_desc[rg] + ":\texecute success\r\n"
            else:
                funErrMsg += cmd_info_desc[rg] + u":\t执行成功\r\n"
    cmd_display.put("err_msg",versionErrMsg + funErrMsg + evalMultipathErrMsg)
    fun_flag = CHECK_PASS
    util.updateItemProgress(context, constants.PROG95)
    return fun_flag, cmd_display, funErrMsg