# coding=utf-8
__author__ = '******'
# 获取aix主机的多路径信息
import re
import sys
import os

path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common.contentParse import check_lst,getStringRet
from common.util import log
from common import util
from common import constants
CLI = None
LANGUAGE = None
CHECK_FAIL          =       0
CHECK_PASS          =       1
cmd_info_id = ["cmd_info_multipath_status_phypath" ,
               "cmd_info_multipath_status_lun_info"           
               ]
            
cmd_info_desc = ["upadm show path",
                 "upadm show vlun id=" 
                ]

cmd_info_lun_list = "upadm show vlun type=all |sed '1,2d;$d' |awk '{print $1}'"
def execute(context):
    """
    Function name      : execute5
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = context.get("lang")
    cmd_display = context.get("ret_map")
    return check_and_get_result(cmd_execute(cmd_display, CLI, LANGUAGE,context))


# 取中间一个有效值
def check_and_get_result((fun_flag, result, fun_err_msg)):
    """
    :rtype : object
    """
    return result


def cmd_execute(cmd_display, CLI, LANGUAGE,context):
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    util.updateItemProgress(context, constants.PROG5)
    lun_list = CLI.execCmdHasLog(cmd_info_lun_list).splitlines()
    totalCmd = len(lun_list) + len(cmd_info_id) - 1
    perPreg = constants.PROG85/totalCmd
    for rg in range(len(cmd_info_id)):
        if  cmd_info_id[rg]=="cmd_info_multipath_status_lun_info":
            #使用upRescan扫盘命令重新上报逻辑路径
            #upadm show vlun type=all |sed '1,2d;$d' |awk '{print $1}'命令的回文如果异常，不往下执行
            if lun_list[-1] == "--" or len(lun_list) == 1 or lun_list[-1].find("not found") >= 0:
                continue
            for lun in lun_list[1:]:
                if not lun.isdigit():
                    continue
                
                cmd_display_temp = ''
                if 'command not found' in lun:
                    pass
                else:
                    cmd_display_temp = cmd_display_temp + CLI.execCmdHasLogTimout(cmd_info_desc[rg] + lun + " type=all ",60)
                util.addItemProgress(context, perPreg)
                if len(cmd_display_temp)>0:
                    cmd_display.put("cmd_display"+(cmd_info_id[rg])[8:-4] + lun, cmd_display_temp)
                else:
                    pass
                if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                    if "en"==LANGUAGE:
                        fun_err_msg        +=cmd_info_desc[rg] + lun + " type=all" + ":\texecute failed\r\n"
                    else:
                        fun_err_msg        +=cmd_info_desc[rg] + lun + " type=all" + u":\t执行失败\r\n"
                else:
                    if "en"==LANGUAGE:
                        fun_err_msg        +=cmd_info_desc[rg] + lun + " type=all" + ":\texecute success\r\n"
                    else:
                        fun_err_msg        +=cmd_info_desc[rg] + lun + " type=all" + u":\t执行成功\r\n"
        else:        
            cmd_display_temp = CLI.execCmdHasLogTimout(cmd_info_desc[rg],60)
            util.addItemProgress(context, perPreg)
            cmd_display.put("cmd_display"+(cmd_info_id[rg])[8:], cmd_display_temp)
            if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                if "en"==LANGUAGE:
                    fun_err_msg        +=cmd_info_desc[rg] + ":\texecute failed\r\n"
                else:
                    fun_err_msg        +=cmd_info_desc[rg] + u":\t执行失败\r\n"
            else:
                if "en"==LANGUAGE:
                    fun_err_msg        +=cmd_info_desc[rg] + ":\texecute success\r\n"
                else:
                    fun_err_msg        +=cmd_info_desc[rg] + u":\t执行成功\r\n"
    cmd_display.put("err_msg", fun_err_msg)
    util.updateItemProgress(context, constants.PROG90)
    fun_flag = CHECK_PASS
    return fun_flag, cmd_display, fun_err_msg