#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
from common.cmd_execute import BaseCmdExecute, DES, CMD

CMD_LIST = [
    {DES: "cmd_display_database_%s_olsnodes", CMD: "olsnodes -s"},
    {DES: "cmd_display_database_%s_cluster_status", CMD: "crsctl stat res -t"},
    {DES: "cmd_display_database_%s_cluster_vote", CMD: "crsctl query css votedisk"},
    {DES: "cmd_display_database_%s_ocr_disk_path", CMD: "ocrcheck"},
    {DES: "cmd_display_database_%s_asmcmd_dsget", CMD: "asmcmd dsget"},
    {DES: "cmd_display_database_%s_asmcmd_afd_lsdsk", CMD: "asmcmd afd_lsdsk"},
]

ORACLE_SQL_CMD_LIST = [
    # 切换到数据库SQL
    {DES: "cmd_display_database_%s_sqlplus", CMD: "sqlplus / as sysdba"},
    {DES: "cmd_display_database_%s_set_linesize", CMD: "set linesize 200"},
    {DES: "cmd_display_database_%s_set_pagesize", CMD: "set pagesize 300"},
    {DES: "cmd_display_database_%s_set_col_path_size", CMD: "col path for a40"},
    {DES: "cmd_display_database_%s_set_col_name_size", CMD: "col name for a30"},
    {DES: "cmd_display_database_%s_set_col_name_size", CMD: "col name for a30"},
    {DES: "cmd_display_database_%s_select_oracle_version", CMD: "select * from v$version;"},
    {DES: "cmd_display_database_%s_select_cluster_value",
        CMD: "select value from v$parameter where name='cluster_database';"},
    {DES: "cmd_display_database_%s_select_asm_disk_group",
        CMD: "select group_number,name,state,total_mb,free_mb,sector_size from v$asm_diskgroup;"},
    {DES: "cmd_display_database_%s_select_asm_disk",
        CMD: "select group_number,disk_number,name,mount_status,header_status,path,state,total_mb,free_mb,sector_size"
             " from v$asm_disk;"},
    {DES: "cmd_display_database_%s_select_ask_disk_string", CMD: "show parameter asm_diskstring"},
]


def execute(context):
    SolarisOracleRacInfo(context).execute()


class SolarisOracleRacInfo(BaseCmdExecute):
    def __init__(self, context):
        BaseCmdExecute.__init__(self, context)

    def execute(self):
        """
        类的执行入口
        """
        if not self.execute_cmd("oracle"):
            self.execute_cmd("grid")

    def execute_cmd(self, user):
        """
        执行命令，区分用户场景，RAC场景可能使用Oracle或Grid两种用户
        :param user: 用户
        :return:
        """
        self.cmd_list = []
        # 先切换账户
        self.cmd_list.append({DES: "cmd_display_database_%s_object" % user, CMD: "su - " + user})
        self.execute_pure_cmd_list(cur_step=5, progress_width=10)
        if not self.is_switch_user_success(user):
            return False
        if not self.is_user_has_permission():
            self.exec_cmd("exit")
            return False
        # 依赖切换账户命令
        self.cmd_list = []
        self.append_cmd_list(user, CMD_LIST)
        self.execute_pure_cmd_list(cur_step=15, progress_width=30)
        self.cmd_list = []
        self.append_asm_path_detail_cmd_list(user, self.get_asm_path(user))
        self.execute_pure_cmd_list(cur_step=45, progress_width=15)
        # 后续执行SQL命令，更换执行命令的方法
        self.cmd_list = []
        self.execute_cmd_method = self.cli.execDbCmdNoLogTimout
        self.append_cmd_list(user, ORACLE_SQL_CMD_LIST)
        self.execute_pure_cmd_list(cur_step=60, progress_width=30)
        self.execute_cmd_method = None
        self.exit_to_outside(user)
        return True

    def is_switch_user_success(self, user):
        switch_content = self.display.get("cmd_display_database_%s_object" % user, "")
        return "Unknown id:" not in switch_content

    def is_user_has_permission(self):
        content = self.exec_cmd("olsnodes -s")
        return "command not found" not in content

    def append_cmd_list(self, user, cmd_dict_list):
        for cmd_dict in cmd_dict_list:
            self.cmd_list.append({DES: cmd_dict[DES] % user, CMD: cmd_dict[CMD]})

    def append_asm_path_detail_cmd_list(self, user, asm_path_list):
        for path in asm_path_list:
            self.cmd_list.append({DES: "cmd_display_database_%s_asm_path_detail_%s" % (user, path),
                                  CMD: "ls -l %s" % path})

    def get_asm_path(self, user):
        """
        获取 asmcmd dsget 命令中路径，用于 ls -l %s 命令参数，需要grid用户权限
        :return: ASM路径（非 AFD:* 或 /dev/rdsk/* ）
        """
        asmcmd_dsget = self.display.get("cmd_display_database_%s_asmcmd_dsget" % user, "")
        for line in asmcmd_dsget.splitlines():
            if "profile:" in line:
                return self.get_asm_disk_path_list(line)
        return []

    def get_asm_disk_path_list(self, line):
        paths = line[line.index(":") + 1:].strip().split(",")
        return list(map(lambda path: path[0:-1],
                        filter(lambda path: path != "AFD:*" and path != "/dev/rdsk/*", paths)))

    def exit_to_outside(self, user):
        """
        从SQL和oracle/grid用户下退出到外部用户
        :param user: 外部用户
        :return:
        """
        content = self.cli.execCmdHasLogTimout("who am i", 60)
        if "SQL>" in content:
            # SQL模式下执行两次exit，分别退出到grid用户和外部用户
            self.cli.execCmdHasLogTimout("exit", 60)
            self.cli.execCmdHasLogTimout("exit", 60)
            return
        for line in content.splitlines():
            if line.startswith(user + "@"):
                # 当前为 grid 账户，退出一次
                self.cli.execCmdHasLogTimout("exit", 60)
                return
