# coding=utf-8
__author__ = '******'
# 获取linux主机的一些基础信息:名称、版本、CPU、内存等.
from common import constants
from common import util

CLI = None
LANGUAGE = None
CHECK_FAIL = 0
CHECK_PASS = 1
cmd_info_id = ["cmd_info_os_basic_cat_release",
               "cmd_info_os_basic_uname",
               "cmd_info_os_basic_date",
               "cmd_info_os_basic_meminfo",
               "cmd_info_os_basic_arch",
               "cmd_info_os_basic_cpunums",
               "cmd_info_os_basic_ips",
               "cmd_info_os_basic_memuse",
               "cmd_info_os_basic_cputype",
               "cmd_info_os_basic_system_bit",
               "cmd_info_os_prtconf_vp",
               "cmd_info_os_hosts",
               ]

cmd_info_desc = ["cat /etc/release",
                 "uname -a",
                 "date",
                 "prtconf",
                 "isainfo",
                 "mpstat",
                 "ifconfig -a",
                 "vmstat 1 6",
                 "prtdiag -v",
                 "isainfo -b",
                 "prtconf -vp | grep boot",
                 "cat /etc/hosts",
                 ]


def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = context.get("lang")
    cmd_display = context.get("ret_map")
    return cmd_execute(context, cmd_display)


def cmd_execute(context, cmd_display):
    temp_step = constants.PROG90 / len(cmd_info_id)
    cur_step = temp_step
    fun_err_msg = ''
    for rg in range(len(cmd_info_id)):
        cur_step += constants.PROG10
        util.updateItemProgress(context, cur_step)
        cmd_display_temp = CLI.execCmdHasLogTimout(cmd_info_desc[rg], 60)
        cmd_display.put("cmd_display" + (cmd_info_id[rg])[8:], cmd_display_temp)
        if not cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 \
                or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
            if "en" == LANGUAGE:
                fun_err_msg += cmd_info_desc[rg] + ":\texecute failed\r\n"
            else:
                fun_err_msg += cmd_info_desc[rg] + u":\t执行失败\r\n"
        else:
            if "en" == LANGUAGE:
                fun_err_msg += cmd_info_desc[rg] + ":\texecute success\r\n"
            else:
                fun_err_msg += cmd_info_desc[rg] + u":\t执行成功\r\n"
    cmd_display.put("err_msg", fun_err_msg)
    return cmd_display
