# coding=utf-8
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2023. All rights reserved.
# 获取linux主机的多路径信息
from common import constants
from common import util
from hosts.sudo_utils import get_sudo_cmd
from hosts.sudo_utils import SOLARIS

CHECK_FAIL = 0
CHECK_PASS = 1
cmd_info_id = [
    "cmd_info_os_basic_rev",
    "cmd_info_multipath_cat_mpt",
    "cmd_info_multipath_cat_scsi_vhci",
    "cmd_info_multipath_cat_scsi_vhci2",
    "cmd_info_database_ls_device_scsi_vhci",
]
cmd_info_desc = [
    "showrev",
    "cat /etc/driver/drv/mpt.conf",
    "cat /etc/driver/drv/scsi_vhci.conf",
    "cat /kernel/drv/scsi_vhci.conf",
    "ls -l /devices/scsi_vhci/",
]

cmd_multipath_Huawei_id = ['cmd_info_multipath_version_Huawei', 'cmd_info_multipath_path_Huawei']
cmd_multipath_Huawei_desc = ['upadmin show version', 'upadmin show vlun']

cmd_multipath_Huawei_old_id = ['cmd_info_multipath_version_Huawei_old', 'cmd_info_multipath_path_Huawei_old']
cmd_multipath_Huawei_old_desc = ['upadm show version', 'upadm show vlun']

cmd_multipath_EMC_id = [
    'cmd_info_multipath_version_EMC',
    'cmd_info_multipath_path_EMC',
    'cmd_info_multipath_path_EMC_luxadm_',
]
cmd_multipath_EMC_desc = [
    'powermt version',
    'powermt display dev=all',
    'luxadm display /dev/rdsk/',
]

cmd_multipath_HDS_id = ['cmd_info_multipath_sys_HDS', 'cmd_info_multipath_lu_HDS', 'cmd_info_multipath_path_HDS']
cmd_multipath_HDS_desc = ['dlnkmgr view -sys', 'dlnkmgr view  -lu', 'dlnkmgr view -path']

cmd_multipath_IBMSDDDSM_id = ['cmd_info_multipath_sdddatapath']
cmd_multipath_IBMSDDDSM_desc = ['pkginfo -i SDDsrv or datapath query version']

cmd_multipath_id = cmd_multipath_Huawei_id + cmd_multipath_Huawei_old_id + cmd_multipath_EMC_id \
                   + cmd_multipath_HDS_id + cmd_multipath_IBMSDDDSM_id
cmd_multipath_desc = cmd_multipath_Huawei_desc + cmd_multipath_Huawei_old_desc \
                     + cmd_multipath_EMC_desc + cmd_multipath_HDS_desc + cmd_multipath_IBMSDDDSM_desc


def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    cli = context.get("SSH")
    language = context.get("lang")
    cmd_display = context.get("ret_map")

    cmd_storage_execute(context, cmd_display, cli, language, cmd_multipath_id, cmd_multipath_desc)
    return cmd_execute(context, cmd_display, cli, language)


def cmd_storage_execute(context, cmd_display, cli, language, cmd_info_id, cmd_info_desc):
    tempStep = constants.PROG60 / len(cmd_info_id)
    curStep = tempStep
    fun_err_msg = ''
    for rg in range(len(cmd_info_id)):
        curStep += tempStep
        util.updateItemProgress(context, curStep)
        if "cmd_info_multipath_path_EMC_luxadm_" == cmd_info_id[rg]:
            set_disk_capacity(cli, cmd_display, cmd_info_id[rg], cmd_info_desc[rg])
            continue
        cmd_display_temp = cli.execCmdNoLogTimout(
            get_sudo_cmd(cmd_info_desc[rg], SOLARIS, context), 60)
        if not cmd_display_temp or cmd_display_temp.find(
                'TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
            continue
        else:
            cmd_display.put("cmd_display" + (cmd_info_id[rg])[8:], cmd_display_temp)
            if "en" == language:
                fun_err_msg += cmd_info_desc[rg] + ":\texecute success\r\n"
            else:
                fun_err_msg += cmd_info_desc[rg] + u":\t执行成功\r\n"
    cmd_display.put("err_msg", fun_err_msg)
    return cmd_display


def set_disk_capacity(cli, cmd_display, cmd_id, cmd_desc):
    """
    获取emc的容量
    :param cli: 连接
    :param cmd_display: 回文存储
    :param cmd_id: 描述
    :param cmd_desc: 命令
    """
    cmd_display_temp = cli.execCmdHasLogTimout("powermt display dev=all", 60)
    for line in cmd_display_temp.splitlines():
        if len(line.split()) > 3 and line.split()[2].startswith("c"):
            cmd_display.put("cmd_display" + cmd_id[8:] + line.split()[2],
                            cli.execCmdHasLogTimout(cmd_desc + line.split()[2], 60))


def cmd_execute(context, cmd_display, cli, language):
    util.updateItemProgress(context, constants.PROG90)
    fun_err_msg = ''
    for rg in range(len(cmd_info_id)):
        cmd_display_temp = cli.execCmdHasLogTimout(cmd_info_desc[rg], 60)
        cmd_display.put("cmd_display" + (cmd_info_id[rg])[8:], cmd_display_temp)
        if not cmd_display_temp or cmd_display_temp.find(
                'TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
            if "en" == language:
                fun_err_msg += cmd_info_desc[rg] + ":\texecute failed\r\n"
            else:
                fun_err_msg += cmd_info_desc[rg] + u":\t执行失败\r\n"
        else:
            if "en" == language:
                fun_err_msg += cmd_info_desc[rg] + ":\texecute success\r\n"
            else:
                fun_err_msg += cmd_info_desc[rg] + u":\t执行成功\r\n"
    cmd_display.put("err_msg", fun_err_msg + cmd_display.get("err_msg"))
    return cmd_display
