# coding=utf-8
__author__ = '******'
# 获取solaris主机的虚拟化信息
import re
import sys
import os
import traceback
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common import util
from common import constants
from hosts.sudo_utils import get_sudo_cmd
from hosts.sudo_utils import SOLARIS

CLI = None
LANGUAGE = None
CHECK_FAIL          =       0
CHECK_PASS          =       1
cmd_info_id = ["cmd_info_virtual_pkginfo_ldomsmanager",
               "cmd_info_virtual_pkginfo_SUNWldm_VERSION",
               "cmd_info_virtual_pkginfo_SUNWldmp2v_VERSION",
               "cmd_info_virtual_ldm_list",
               "cmd_info_virtual_ldm_list_l",
               "cmd_info_virtual_ldm_list_e",
               "cmd_info_virtual_ldm_list_p",
               "cmd_info_virtual_ldm_list_devices",
               "cmd_info_virtual_ldm_list_devices_a",
               "cmd_info_virtual_ldm_list_domain_o",
               "cmd_info_virtual_ldm_list_services_primary",
               "cmd_info_virtual_ldm_list_domain",
               "cmd_info_virtual_ldm_ls_lp",
               "cmd_info_virtual_ldm_list_lp",
               "cmd_info_virtual_ldm_list_services",
               "cmd_info_virtual_ldm_list_bindings",
               "cmd_info_virtual_zpool_status_rpool",
               "cmd_info_virtual_ldm_list_crypto_primary",
               "cmd_info_virtual_ldm_v",
               "cmd_info_virtual_ldm_list_io",
               "cmd_info_virtual_ldm_list_config"]
            
cmd_info_desc = ["pkginfo ldomsmanager",
                 "pkginfo -l SUNWldm | grep VERSION",
                 "pkginfo -l SUNWldmp2v | grep VERSION",
                 "ldm list",
                 "ldm list -l",
                 "ldm list -e",
                 "ldm list -p",
                 "ldm list-devices",
                 "ldm list-devices -a",
                 "ldm list -o domain -p",
                 "ldm list-services primary",
                 "ldm list-domain ",
                 "ldm ls -l -p ",
                 "ldm list -l -p ",
                 "ldm list-services",
                 "ldm list-bindings",
                 "zpool status rpool",
                 "ldm list -o crypto primary",
                 "ldm -V",
                 "ldm list-io",
                 "ldm list-config"]
cmd_info_ldm_list              =   "ldm list|awk '{print $1}'"
cmd_info_domain_list           =   "ldm list-domain | awk '{print $1}'"


def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = context.get("lang")
    global logger
    logger = context.get("Logger")    
    cmd_display = context.get("ret_map")
    try:
        return check_and_get_result(cmd_execute(cmd_display, CLI, LANGUAGE,context))
    except:
        logger.error("the except info is:" + traceback.format_exc())
        return cmd_display


# 取中间一个有效值
def check_and_get_result((fun_flag, result, fun_err_msg)):
    """
    :rtype : object
    """
    return result


def cmd_execute(cmd_display, CLI, LANGUAGE,context):
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    ldm_list = CLI.execCmd(
        get_sudo_cmd(cmd_info_ldm_list, SOLARIS, context)).splitlines()
    
    #新增命令，查看来宾域 获取name信息
    domain_list = CLI.execCmd(
        get_sudo_cmd(cmd_info_domain_list, SOLARIS, context)).splitlines()
    if len(domain_list) > 1:
        for domain in domain_list[1:]:
            cmd = get_sudo_cmd("ldm list-bindings ", SOLARIS, context)
            cmd_info_desc.append(cmd + domain)
            cmd_info_id.append("cmd_info_virtual_domain_%s" % domain)
            
        for domain in domain_list[1:]:
            cmd = get_sudo_cmd("ldm list-hba -l ", SOLARIS, context)
            cmd_info_desc.append(cmd + domain)
            cmd_info_id.append("cmd_info_virtual_hba_%s" % domain)
                                       
    util.updateItemProgress(context, constants.PROG5)
    totalCmd = (len(cmd_info_id) + (len(ldm_list) -2) * 4 - 4)
    prgStep,stepsUnit = util.calcPerStepDetail(constants.PROG80 , totalCmd)
    for rg in range(len(cmd_info_id)):
        if cmd_info_id[rg]=="cmd_info_virtual_ldm_list_domain" or cmd_info_id[rg]=="cmd_info_virtual_ldm_ls_lp" or cmd_info_id[rg]=="cmd_info_virtual_ldm_list_lp":
            for idx in range(len(ldm_list[2:])):
                ldm = ldm_list[idx + 2]
                cmd_display_temp = CLI.execCmdWithTimout(
                    get_sudo_cmd(cmd_info_desc[rg], SOLARIS,
                                 context) + ' ' + ldm, 60)
                util.itemProgressIncr(context, idx, prgStep, stepsUnit)
                cmd_display.put("cmd_display"+(cmd_info_id[rg])[8:]+"_"+ldm, cmd_display_temp)
                if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                    if "en"==LANGUAGE:
                        fun_err_msg        +=cmd_info_desc[rg] + ldm + ":\texecute failed\r\n"
                    else:
                        fun_err_msg        +=cmd_info_desc[rg] + ldm + u":\t执行失败\r\n"
                else:
                    if "en"==LANGUAGE:
                        fun_err_msg        +=cmd_info_desc[rg] + ldm + ":\texecute success\r\n"
                    else:
	                    fun_err_msg        +=cmd_info_desc[rg] + ldm + u":\t执行成功\r\n"
        else:
            cmd_display_temp = CLI.execCmdWithTimout(
                get_sudo_cmd(cmd_info_desc[rg], SOLARIS, context), 60)
            util.itemProgressIncr(context, rg, prgStep, stepsUnit)
            cmd_display.put("cmd_display"+(cmd_info_id[rg])[8:], cmd_display_temp)
            if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                if "en"==LANGUAGE:
                    fun_err_msg        +=cmd_info_desc[rg] + ":\texecute failed\r\n"
                else:
                    fun_err_msg        +=cmd_info_desc[rg] + u":\t执行失败\r\n"
            else:
                if "en"==LANGUAGE:
                    fun_err_msg        +=cmd_info_desc[rg] + ":\texecute success\r\n"
                else:
                    fun_err_msg        +=cmd_info_desc[rg] + u":\t执行成功\r\n"
    cmd_display.put("err_msg", fun_err_msg)
    fun_flag = CHECK_PASS
    util.updateItemProgress(context, constants.PROG90)
    return fun_flag, cmd_display, fun_err_msg