# --*-- coding:utf-8 --*--

import sys 
import os
import re
reload(sys) 
sys.setdefaultencoding('utf-8')
path = os.path.dirname(os.path.abspath(__file__))
path =os.path.join(path, "..\\..\\..")
sys.path.append(path)
from common.contentParse import *  

OsVersionCmd = 'cmd_display_os_basic_cat_release'

def execute(context):
    global LOG
    LOG = context.get("Logger")
    result = getOs(context,OsVersionCmd)
    context["result"]=result
    return context


def getOs(context,osCmd):
    '''
    @summary: 获取solaris操作系统 
    @param osCmd: 操作系统命令
    '''
    isSparc = False
    
    versionLst = getSingleOrMoreCommandRetFromTxt(context, osCmd, False)
    for line in versionLst:
        if 'SPARC'.lower() in line.lower():
            isSparc = True
            break
    if isSparc:
        return getSparcOs(versionLst)
    else:
        return getX86Os(versionLst)
    
    
def getSparcOs(lst):
    '''
           举例：
    Oracle Solaris 11.3 SPARC
    Solaris 10 5/09 s10s_u7wos_08 SPARC
    @summary: 获取solaris操作系统，Sparc小型机
    @param lst: 操作系统回文 
    '''
    osName = 'NA'
    osLine = ''
    uVersion = ''
    
    for line in lst:
        if 'sparc' in line.lower():
            osLine = line
            if 'wos' in osLine.lower() and 'u' in osLine.lower():
                wosLst = re.findall(r'u\d{1,}wos', osLine)
                if wosLst:
                    uLine = wosLst[0]
                    uVersion = uLine[uLine.lower().find('u') + 1:uLine.lower().find('wos')]
            else:
                osName = line[0:-5].strip() + ' for ' + 'SPARC'
                return osName
            break
    osLst = osLine.split()
    try:
        osName = osLst[0] + ' ' + osLst[1] + ' U' + uVersion + ' for ' + 'SPARC'
        if not osName.lower().startswith('oracle'):
            osName = 'Oracle ' + osName
    except Exception, e:
        LOG.info('osName not found.', str(e))
    return osName



def getX86Os(lst):
    '''
    @summary: 获取solaris操作系统，x86情况下
    @param lst: 操作系统回文 
    root@solaris11:~# cat /etc/releas
    Oracle Solaris 11.3 X86     
    '''
    osName = 'NA'
    osIdx = 0
    lst = check_lst(lst)
    
    for idx,line in enumerate(lst):
        if ('cat' in line) and ('etc' in line) and ('releas' in line):
            osIdx = idx + 1
            break
    try:
        osName = lst[osIdx].strip()
        if(isUX86(osName)):
            return getUX86OsName(osName)
    except Exception, e:
        LOG.info('os not found.', str(e))
         
    arch = ''
    if 'NA' != osName:
        try:
            arch =  re.split('\s+',osName)[-1]
            osName = osName.replace(arch, 'for ' + arch.lower()).strip()
        except Exception,e:
            LOG.info('os not found.',str(e))
    return osName


def getUX86OsName(osLine):
    '''
    @summary:获取u版本x86os信息
    @osLine:回文
    @os信息
           回文为：Solaris 10 10/09 s10x_u8wos_08a X86 ，则返回： 
    Oracle Solaris 10 U8 for x86
    '''
    result = 'NA'
    osLst = osLine.split()
    
    osVersion = ''
    uVersion = ''
    arch = ''
    try:
        osVersion = osLst[1].strip()
        if 'wos' in osLine.lower() and 'u' in osLine.lower():
            uVersion = osLine[osLine.lower().find('u')+1:osLine.lower().find('wos')]
        arch = osLst[-1].strip()
    except Exception,e:
        LOG.info("osVerison or arch not found.the info is = ",str(osLine))
        return result
    
    result = 'Oracle ' + 'Solaris ' + osVersion + ' U' + uVersion + ' for ' + arch 
    return result 



def isUX86(osLine):
    '''
    @summary: 判断是否u版本x86系统
    @param osLine: 回文
    @return: True:是u版本os系统，False:不是
    Solaris 10 10/09 s10x_u8wos_08a X86
    '''
    return 'wos' in osLine.lower()
