# --*-- coding:utf-8 --*--
import sys 
import os
import re
reload(sys) 
sys.setdefaultencoding('utf-8')
path = os.path.dirname(os.path.abspath(__file__))
path =os.path.join(path, "..\\..\\..")
sys.path.append(path)
from common.contentParse import getSingleOrMoreCommandRetFromTxt


WWWPN_CMD_DESC = "cmd_display_hba_card_fcinfo"

# 处理codeMars中的try except pass问题，占位变量，无意义。
DO_NOTHING_PASS = None

def execute(context):
    '''
    @summary: 脚本入口
    @param context:上下文
    @return :处理过的上下文
           执行fcinfo hba - port命令，在回显中
    Model的是HBA卡型号，
    HBA Port WWN是HBA卡的WWPN，
    Firmware Version是HBA卡固件版本(括号内的不取)，
    Driver Version是HBA卡驱动版本（括号以内的内容不获取），
            过滤掉state不为online的HBA卡。
    '''
    
    hbaObjs = getAllHbaObjs(context)
    result = ""
    fc_result = getAllWWPNS(hbaObjs)
    iscsi_result = get_iscsi_wwn(context)
    if fc_result == "NA":
        result = iscsi_result
    else:
        if iscsi_result == "NA":
            result = fc_result
        else:
            result = fc_result + ";" + iscsi_result

    context['result'] = result
    return context


def get_iscsi_wwn(context):
    """
    获取iscsi的wwn
    :param context:
    :return:
    """
    iscsi_wwn = ""
    cmd_iscsi_wwn_desc = "cmd_display_hba_card_iscsi"
    iscsi_wwn_str = getSingleOrMoreCommandRetFromTxt(context,
                                                     cmd_iscsi_wwn_desc, False)
    for line in iscsi_wwn_str:
        if "Initiator node name" in line:
            iscsi_wwn = iscsi_wwn + re.split('\\s+', line)[-1].strip() + ";"
    if not iscsi_wwn:
        iscsi_wwn = "NA"
    else:
        iscsi_wwn = iscsi_wwn[0:-1]
    return iscsi_wwn


    
def getAllWWPNS(hbas):
    '''
    @summary: 过滤掉state不为online的HBA卡。
    @param hba:对象列表
    @return :wwpns 
    '''
    
    wwpns = ''
    for hba in hbas:
        if 'online' != hba.getState().lower():
            continue
        wwpns = wwpns + ';' + hba.getHbaWWPN()
    if not wwpns:
        wwpns = 'NA'
    else:
        wwpns = wwpns[1:]
    return wwpns


        
def getAllHbaObjs(context):
    '''
    @summary: 获取所有hba对象
    @param context: 上下文
    @return:hbaObjLst:所有hba对象
    
    '''
    lst = []
    eachHbaLst = []
    hbaObjLst = []
    lst = getSingleOrMoreCommandRetFromTxt(context, WWWPN_CMD_DESC, False)
    eachHbaLst = getEachHbaInfo(lst)

    for hbalst in eachHbaLst:
        hbaObjLst.append(getHbaBySingleInfo(hbalst))
    return hbaObjLst


def getEachHbaInfo(allHbaLst): 
    startIdxLst = []
    endIdxLst = []
    eachHbaLst = []
    
    for idx, line in  enumerate(allHbaLst):
        if ('HBA Port WWN'.lower() in line.lower()):  
            startIdxLst.append(idx)
            
    for i in range(len(startIdxLst)):
        if i != len(startIdxLst) - 1:
            endIdxLst.append(startIdxLst[i + 1])
        else:
            endIdxLst.append(len(allHbaLst) - 1)
    for idx in range(len(startIdxLst)):
        start = startIdxLst[idx]
        end = endIdxLst[idx]
        eachHbaLst.append(allHbaLst[start:end])
            
    return eachHbaLst
        

        
def getHbaBySingleInfo(hbaLst):
    '''
    @summary: 从当个hba对象的回文中获取关键信息构造对象
    @param hbaLst: hba列表
     
    Model的是HBA卡型号，
    HBA Port WWN是HBA卡的WWPN，
    Firmware Version是HBA卡固件版本(括号内的不取)，
    Driver Version是HBA卡驱动版本（括号以内的内容不获取），
           过滤掉state不为online的HBA卡。
           回文例子：
    HBA Port WWN: 10000090fa50e413
    OS Device Name: /dev/cfg/c10
    Manufacturer: Emulex
    Model: LPe12002-M8
    Firmware Version: 2.01a10 (U3D2.01A10)
    FCode/BIOS Version: Boot:5.12a11 Fcode:3.10a5
    Serial Number: FC34310798
    Driver Name: emlxs
    Driver Version: 2.31p (2008.12.11.10.30)
    Type: L-port
    State: online
    Supported Speeds: 2Gb 4Gb 8Gb
    Current Speed: 8Gb
    Node WWN: 20000120fa50e413
    @return:hba对象
    
    '''
    hbaObj = HbaEntity()
    for line in hbaLst:
        if ('HBA Port WWN'.lower() in line.lower()) and (':' in line):  
            try:
                wwpn = re.split(':', line)[-1].strip()   
                if (wwpn.lower().startswith('0x')):
                    wwpn = wwpn[2:]
                hbaObj.setHbaWWPN(wwpn)
            except:
                hbaObj.setHbaWWPN('NA')
            continue
       
        if ('Model'.lower() in line.lower()) and (':' in line):
            try:
                model = re.split(':', line)[-1].strip()
                hbaObj.setHbaModel(model)
            except:
                hbaObj.setHbaWWPN('NA')
            continue
        
        if ('Firmware Version'.lower() in line.lower()) :
            fwVersion = 'NA'
            try:
                fwVersion = re.split(':', line)[-1].strip()
            except:
                global DO_NOTHING_PASS
                DO_NOTHING_PASS = None
            fields = fwVersion.split()
            if '(' in fwVersion and len(fields) >= 2:
                fwVersion = fields[0].strip()
            elif len(fields) != 0:
                fwVersion = fields[-1]
            hbaObj.setFwVersion(fwVersion)
            continue
        #Driver Version: 2.31p (2008.12.11.10.30)
        #Driver Version: 20081115-2.29
        if ('Driver Version'.lower() in line.lower()):
            drVersion = "NA"
            if ':' in line:
                drVersion = re.split(':', line)[-1].strip()
                
            if '(' in drVersion:
                drVersion = drVersion[:drVersion.index("(")].strip()
            hbaObj.setDrVersion(drVersion)
            continue
        if ('State'.lower() in line.lower()) and (':' in line):
            state = re.split(':', line)[-1].strip()
            hbaObj.setState(state)
            continue
    return hbaObj

    
class HbaEntity:
    hbaModel = 'NA'
    wwpn = 'NA'
    fwVersion = 'NA'
    drVersion = 'NA'
    state = 'NA'
    #get 方法
    def getHbaModel(self):
        return self.hbaModel
    def getHbaWWPN(self):
        return self.wwpn
    def getFwVersion(self):
        return self.fwVersion
    def getDrVersion(self):
        return self.drVersion
    def getState(self):
        return self.state
    #set 方法
    def setHbaModel(self,model):
        self.hbaModel = model
    def setHbaWWPN(self,wwpn):
        self.wwpn = wwpn
    def setFwVersion(self,version):
        self.fwVersion = version
    def setDrVersion(self,drVersion):
        self.drVersion = drVersion
    def setState(self,state):
        self.state = state



