# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
LINUX = "linux"
AIX = "aix"
SOLARIS = "solaris"
HPUX = "hpux"
XENSERVER = "xenserver"
FS = "fusionsphere"

linux_sudo_list = ["fdisk -l",
                   "smartctl -a /dev/hda",
                   "raw -qa",
                   "lvm version",
                   "pvdisplay",
                   "vgdisplay",
                   "vgdisplay -v",
                   "lvdisplay",
                   "vgs|awk '{print $1,$6}'",
                   "lvs|awk '{print $1,$2,$4}'",
                   "pvs|awk '{print $1,$2,$5}'",
                   "multipath -ll|cat",
                   "upadmin show version",
                   "cat /etc/iscsi/initiatorname.iscsi",
                   "upadm show array",
                   "upadm show version",
                   "upadmin show vlun",
                   "upadmin show vlun type=all",
                   "upadmin show upconfig",
                   "upadmin show path",
                   "upadmin show vlun id=",
                   "dmidecode -s system-manufacturer",
                   "dmidecode -q",
                   "runlevel",
                   "cat /etc/multipath.conf",
                   "cat /etc/rc.d/rc.local",
                   "su - grid",
                   "su - oracle",
                   "service multipathd status | cat",
                   "dlnkmgr view -sys",
                   "/opt/DynamicLinkManager/bin/dlnkmgr view -sys",
                   "dlnkmgr view  -lu",
                   "dlnkmgr view -path",
                   "/opt/DynamicLinkManager/bin/dlnkmgr view -path",
                   "hastatus -sum",
                   "lltstat -l",
                   "gabconfig -a",
                   "vxfenadm -d",
                   "hagrp -state",
                   "hares -state",
                   "hares -display",
                   "hagrp -display",
                   "hasys -list",
                   "cat /etc/VRTSvcs/conf/config/main.cf",
                   "vxddladm get namingscheme",
                   "vxdmpadm list dmpnode all",
                   "vxdmpadm getsubpaths",
                   "vxdmpadm listctlr all",
                   "vxdmpadm listenclosure all",
                   "vxdg list",
                   "vxdisk -e list",
                   "vxdisk list",
                   "vxdisk -o alldgs list",
                   "vxdisk path",
                   "vxdisk list|awk '{print $1}'",
                   "mmlscluster",
                   "mmlsconfig",
                   "mmlsnsd",
                   "iscsiadm -m node",
                   "cat /etc/udev/rules.d/",
                   # ↓缺环境，直接配的sudo
                   "crmadmin -v",
                   "cman_tool status",
                   "clustat -l",
                   "cman_tool nodes -a",
                   "cat /etc/cluster/cluster.conf",
                   "crm ra classes",
                   "crm status",
                   "mkqdisk -L",
                   "sg_inq -p 0x83 /dev/sdX",
                   "clustat",
                   # ↑ 缺环境，直接配的sudo
                   "netstat -anp",
                   "ifconfig -a",
                   "powermt display dev=all",
                   ]
linux_sudo_dict_special = {
    "oracleasm listdisks |xargs oracleasm "
    "querydisk -p": "oracleasm listdisks |xargs %soracleasm querydisk -p", }

aix_sudo_list = ["bootinfo -K",
                 "sar 1 5",
                 "upadm show version",
                 "upadm show path",
                 "upadm show vlun type=all |sed '1,2d;$d' |awk '{print $1}'",
                 "upadm show phypath",
                 "upadm show vlun",
                 "upadm chkconfig",
                 "upadm show vlun type=all",
                 "upadm show vlun id=",
                 "bootinfo -s ",
                 "su - grid",
                 "su - oracle",
                 "dlnkmgr view -sys",
                 "/usr/DynamicLinkManager/bin/dlnkmgr view -sys",
                 "dlnkmgr view  -lu",
                 "dlnkmgr view -path",
                 "/usr/DynamicLinkManager/bin/dlnkmgr view -path",
                 "powermt display dev=all",
                 # ↓缺环境，直接配的sudo
                 "clstat -o",
                 "/usr/sbin/cluster/clstat -o",
                 "hastatus -sum",
                 "lltstat -l",
                 "gabconfig -a",
                 "vxfenadm -d",
                 "hagrp -state",
                 "hares -state",
                 "hares -display",
                 "hagrp -display",
                 "hasys -list",
                 "cat /etc/VRTSvcs/conf/config/main.cf",
                 "vxddladm get namingscheme",
                 "vxdmpadm list dmpnode all",
                 "vxdmpadm getsubpaths",
                 "vxdmpadm listctlr all",
                 "vxdmpadm listenclosure all",
                 "vxdg list",
                 "vxprint",
                 "vxprint -ht",
                 "vxprint -vt",
                 "vxprint -pt",
                 "vxdisk -e list",
                 "vxdisk list",
                 "vxdisk -o alldgs list",
                 "cat /etc/vxfendg",
                 "vxdisk path",
                 "vxdisk list ",
                 "vxdisk list|awk '{print $1}'"
                 "pcmpath query device ",
                 "su - padmin",
                 "lsnports",
                 "ioscli ioslevel",
                 "lsmap -all",
                 "lsmap -npiv -all",
                 "mpio_get_config -Av",
                 # ↑ 缺环境，直接配的sudo
                 ]

solaris_sudo_list = ["fcinfo hba-port",
                     "iscsiadm list initiator-node",
                     "stmsboot -L",
                     "mpathadm list lu",
                     "luxadm display ",
                     "ldm list|awk '{print $1}'",
                     "ldm list-domain | awk '{print $1}'",
                     "ldm list",
                     "ldm list -e",
                     "ldm list -p",
                     "ldm list -l",
                     "ldm list-devices",
                     "ldm list-devices -a",
                     "ldm list -o domain -p",
                     "ldm list-services primary",
                     "ldm ls -l -p ",
                     "ldm list -l -p ",
                     "ldm list-domain ",
                     "ldm list-services",
                     "ldm list-bindings ",
                     "ldm list-bindings",
                     "ldm list-hba -l ",
                     "ldm list -o crypto primary",
                     "ldm list-io",
                     "ldm list-config",
                     "zpool import",
                     "zpool history ",
                     "zpool history -il ",
                     "luxadm -e port|grep devices|awk '{print $1}'",
                     # ↓缺环境，直接配的sudo
                     "upadmin show version",
                     "upadmin show vlun",
                     "upadm show version",
                     "upadm show vlun",
                     "upadm show vlun type=all",
                     "upadm show vlun id=",
                     "powermt version",
                     "powermt display dev=all",
                     "dlnkmgr view -sys",
                     "dlnkmgr view  -lu",
                     "dlnkmgr view -path",
                     "hastatus -sum",
                     "lltstat -l",
                     "gabconfig -a",
                     "vxfenadm -d",
                     "hagrp -state",
                     "hares -state",
                     "hares -display",
                     "hagrp -display",
                     "hasys -list",
                     "cat /etc/VRTSvcs/conf/config/main.cf",
                     "vxddladm get namingscheme",
                     "vxdmpadm list dmpnode all",
                     "vxdmpadm getsubpaths",
                     "vxdmpadm listctlr all",
                     "vxdmpadm listenclosure all",
                     "vxdg list",
                     "vxprint",
                     "vxprint -ht",
                     "vxprint -vt",
                     "vxprint -pt",
                     "vxdisk -e list",
                     "vxdisk list",
                     "vxdisk -o alldgs list",
                     "cat /etc/vxfendg",
                     "vxdisk path",
                     # ↑缺环境，直接配的sudo
                     ]

solaris_sudo_dict_special = {"echo | format": "echo | %sformat",
                             }

hpux_sudo_list = ["ioscan -funC fc",
                  "ioscan -funC fc|grep dev|awk '{print $1}'",
                  "fcmsutil ",
                  "scsimgr get_attr -H %s -a path_fail_secs",
                  "ioscan -P health -C disk",
                  "scsimgr lun_map -H %s | grep 'SCSI transport protocol'",
                  "lvmadm -l -V 1.0",
                  "lvmadm -l -V 2.0",
                  "lvmadm -l -V 2.1",
                  "lvmadm -l -V 2.2",
                  "swlist|grep MirrorDisk",
                  "strings /etc/lvmtab",
                  "strings /etc/lvmpvg",
                  "vgdisplay -v",
                  "swlist -l product | grep vxvm",
                  "swlist  -l product|grep Serviceguard",
                  "ioscan -funNC disk",
                  "ioscan -funC disk",
                  "scsimgr lun_map",
                  "ioscan -m dsf",
                  "scsimgr get_attr -a leg_mpath_enable",
                  "ioscan -fnC fc",
                  "ioscan -funNC disk|grep 'disk '|awk '{print $2}'",
                  "ioscan -kfnNC lunpath",
                  "scsimgr -p get_attr all_lun -a hw_path -a "
                  "device_file -a wwid",
                  "scsimgr get_info -D /dev/rdisk/disk%s",
                  "scsimgr get_attr -D  /dev/rdisk/disk%s -a alua_enabled",
                  "scsimgr get_attr -a preferred_path -D ",
                  "ioscan -funNC disk|grep rdisk",
                  "diskinfo ",
                  "scsimgr get_attr -D %s -a alua_enabled",
                  "mount",
                  "mount -v",
                  "scsimgr -p get_attr all_lun -a device_file -a wwid",
                  "ioscan",
                  "parstatus",
                  "ioscan -fnk",
                  "swlist |grep -i par",
                  "swlist -l bundle |grep Ignite",
                  "parstatus -V -p 0",
                  "setboot -v",
                  "swlist -l product | grep VRTS",
                  # ↓缺环境，直接配的sudo
                  "iscsiutil -l",
                  "cmversion",
                  "cmviewcl -v",
                  "cat /etc/cmcluster/cluster.ascii",
                  "hpvmstatus",
                  "vparstatus",
                  "vparstatus -v",
                  "vparstatus -m",
                  "vparstatus -p ",
                  "hastatus -sum",
                  "lltstat -l",
                  "gabconfig -a",
                  "vxfenadm -d",
                  "hagrp -state",
                  "hares -state",
                  "hares -display",
                  "hagrp -display",
                  "hasys -list",
                  "cat /etc/VRTSvcs/conf/config/main.cf",
                  "vxddladm get namingscheme",
                  "vxdmpadm list dmpnode all",
                  "vxdmpadm getsubpaths",
                  "vxdmpadm listctlr all",
                  "vxdmpadm listenclosure all",
                  "vxdg list",
                  "vxprint",
                  "vxprint -ht",
                  "vxprint -vt",
                  "vxprint -pt",
                  "vxdisk -e list",
                  "vxdisk list",
                  "vxdisk -o alldgs list",
                  "cat /etc/vxfendg",
                  "vxdisk path",
                  "vxdisk list|awk '{print $1}'",
                  "vxdisk list ",
                  "powermt version",
                  "powermt display dev=all",
                  # ↑缺环境，直接配的sudo
                  ]

xenserver_sudo_list = ["dmidecode -s system-manufacturer",
                       "xe sr-list",
                       "xe vdi-list",
                       "xe pbd-list",
                       "xe vbd-list",
                       "fdisk -l",
                       "iscsiadm -m node",
                       "multipath -ll|cat",
                       "xe vm-list",
                       "lvm version",
                       "pvdisplay",
                       "vgdisplay",
                       "vgdisplay -v",
                       "lvdisplay",
                       "df -h",
                       "df -TH",

                       # ↓缺环境，直接配的sudo
                       "sr-param-list",
                       "vdi-param-list",
                       "cat /sys/class/scsi_host/host4/modelname",
                       "cat /sys/class/fc_host/hostX/port_name",
                       "ls /sys/class/fc_host/host*/port*name",
                       "cat  /sys/class/fc_host/host*/port*name",
                       "ls /sys/class/scsi_host/host*/model*name",
                       "cat  /sys/class/scsi_host/host*/model*name",
                       "ls /sys/class/scsi_host/host*/*version |awk '/"
                       "lpfc_drvr_version|driver_version/'",
                       "ls /sys/class/fc_remote_ports/",
                       "lspci -vvnn | grep -iA2 'Fibre Channel'",
                       # ↑缺环境，直接配的sudo
                       ]

fusionsphere_sudo_list = ["cat /etc/*-release",
                          "dmidecode -s system-manufacturer",
                          "lvm version",
                          "pvdisplay",
                          "vgdisplay",
                          "vgdisplay -v",
                          "lvdisplay",
                          "mount",
                          "cat /etc/fstab",
                          "df -TH",
                          "df -k",
                          "fdisk -l",
                          "netstat -anp",
                          "df -h",
                          # ↓缺环境，直接配的sudo
                          "cat /etc/hostos.version",
                          "ls /sys/class/fc_host/host*/port*name",
                          "cat  /sys/class/fc_host/host*/port*name",
                          "ls /sys/class/scsi_host/host*/model*name",
                          "cat  /sys/class/scsi_host/host*/model*name",
                          "ls /sys/class/scsi_host/host*/*version |awk '/"
                          "lpfc_drvr_version|driver_version/'",
                          "ls /sys/class/fc_remote_ports/",
                          "cat /sys/class/fc_host/host*/port_state",
                          "lspci -vvnn | grep -iA2 'Fibre Channel'",

                          # ↑缺环境，直接配的sudo
                          ]


def get_sudo_cmd(cmd, host_type, context):
    """
    根据sudo模式，及命令列表，对命令进行处理(单命令处理)
    :param host_type: 主机类型
    :param cmd: 原始cmd
    :param context: 上下文
    :return: 返回的cmd
    """
    sudo = context.get("SUDO")
    if not sudo:
        return cmd
    list_name = host_type + "_sudo_list"
    sudo_list = globals()[list_name]
    if cmd in sudo_list:
        if cmd.startswith("su - "):
            return "sudo " + cmd
        return sudo + cmd
    return cmd


def get_sudo_cmd_desc(cmd_info_desc, host_type, context):
    """
    根据sudo模式，及命令列表，对命令进行处理（命令列表处理）
    :param host_type: 主机类型
    :param cmd_info_desc: 原始cmd
    :param context: 上下文
    :return: 返回的cmd
    """
    sudo = context.get("SUDO")
    list_name = host_type + "_sudo_list"
    sudo_list = globals()[list_name]
    if sudo:
        new_cmd_info_desc = []
        for cmd in cmd_info_desc:
            if cmd in sudo_list:
                new_cmd_info_desc.append(sudo + cmd)
            else:
                new_cmd_info_desc.append(cmd)
        return new_cmd_info_desc
    return cmd_info_desc


def get_sudo_cmd_special(cmd, host_type, context):
    """
    根据sudo模式，及命令列表，对命令进行处理(单命令处理)
    :param host_type: 主机类型
    :param cmd: 原始cmd
    :param context: 上下文
    :return: 返回的cmd
    """
    sudo_middle = context.get("SUDO_MIDDLE")
    dict_name = host_type + "_sudo_dict_special"
    sudo_dict = globals()[dict_name]
    if sudo_middle and cmd in sudo_dict:
        return sudo_dict.get(cmd) % sudo_middle
    return cmd
