# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.

from common.contentParse import get_cmd_ret
from common.contentParse import get_sql_ret_list


def offline_cmd_excute(context, cmd_info_id, cmd_info_desc):
    """
    离现场景，批量命令执行
    :param context: 上下文
    :param cmd_info_id: 命令描述
    :param cmd_info_desc: 命令
    :return: 执行结果
    """
    cmd_display = context.get("ret_map")
    for rg in range(len(cmd_info_id)):
        context["command"] = cmd_info_desc[rg]
        cmd_display_temp = get_cmd_ret(context)
        cmd_display.put("cmd_display" + (cmd_info_id[rg])[8:],
                        cmd_display_temp)
    return cmd_display


def offline_sql_cmd_excute(context, cmd_info_id, cmd_info_desc):
    """
    离现场景，批量sql命令执行
    :param context: 上下文
    :param cmd_info_id: 命令描述
    :param cmd_info_desc: 命令
    :return: 执行结果
    """
    cmd_display = context.get("ret_map")
    for rg in range(len(cmd_info_id)):
        context["command"] = cmd_info_desc[rg]
        cmd_display_temp = get_right_sql_ret(context)
        cmd_display.put(get_cmd_display(cmd_info_id[rg]), cmd_display_temp)
    return cmd_display


def get_right_sql_ret(context):
    """
    离线场景，获取oracle、grid用户的正确sql语句回文
    :param context: 上下文
    :return: 正确回文
    """
    sql_ret_list = get_sql_ret_list(context)
    ret = ""
    for tmp_ret in sql_ret_list:
        if "oracle not available" in tmp_ret.lower():
            continue
        ret = tmp_ret
    if not ret:
        ret = sql_ret_list[0]
    return ret


def get_cmd_display(cmd_info_id):
    """
    根据命令类型，返回回显key的描述
    """
    if cmd_info_id.startswith("cmd"):
        return "cmd_display" + cmd_info_id[8:]
    return "sql_display" + cmd_info_id[8:]
