# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
import sys
import os
import json

reload(sys)
sys.setdefaultencoding('utf-8')
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..\\..")
sys.path.append(path)
from common.contentParse import get_return_from_txt


def execute(context):
    result = {}
    os_type, os_version = get_type_version(context)
    result["host_ip"] = context.get("ip")
    result["os_type"] = os_type
    result["os_version"] = os_version
    ret_map = context.get("map")
    ret_map.put("data", json.dumps(result))
    return context


def get_type_version(context):
    """
    获取操作系统 版本
    :param context: 上下文
    :return:  版本
    """
    command = "vmware -v"
    context["command"] = command
    op_sys_info_list = get_return_from_txt(context)
    if op_sys_info_list:
        for line in op_sys_info_list:
            if line.strip().startswith("VMware ESXi") and "." in line:
                return "VMware ESXi", line.split("VMware ESXi")[-1]
    return "VMware ESXi", ""
