# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
import sys
import os
import json
import traceback
import re

from storages.HUAWEI.huawei_storage_util import parse_table_type_result
from hosts.parse_util import get_key_values_from_content_lines

reload(sys)
sys.setdefaultencoding('utf-8')
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..\\..")
sys.path.append(path)
from common.contentParse import get_return_from_txt
from hosts.common.migra_summary_util import get_host_name
from hosts.common.migra_summary_util import get_vm_lun_list
from hosts.common.migra_summary_util import get_nmp_lun_list
from hosts.vmware.migration.vmware_os import get_type_version
from hosts.common.migra_summary_util import get_vm_nmp_multi
from hosts.common.migra_summary_util import get_vm_ultra_multi
from hosts.common.migra_summary_util import get_vm_other_multis
from hosts.common.migra_summary_util import get_split_item
from hosts.common.migra_summary_util import get_empty_overview_result


def execute(context):
    result = get_result(context)
    ret_map = context.get("map")
    ret_map.put("data", json.dumps(result))
    return context


def get_result(context):
    """
    获取数据
    :param context: 上下文
    :return: 数据
    """
    logger = context.get("Logger")
    try:
        result = {}
        multi_type, multi_version = get_multi_type_version(context)
        hba_list, hba_type = get_hba_wwn_list_type(context)
        result["host_ip"] = context.get("ip")
        result["host_name"] = get_host_name(context)
        result["os_version"] = get_os_version(context)
        result["hba_type"] = hba_type
        result["hba_wwn_list"] = hba_list
        result["multi_type"] = multi_type
        result["multi_version"] = multi_version
        result["cluster_name"] = ""
        result["cluster_version"] = ""
        result["cluster_ips"] = []
        result["lvm_type"] = ""
        result["db_name"] = ""
        result["db_version"] = ""
        result["disk_use"] = get_disk_use(context)
        result["real_ip"] = ""
        result["multi_path_status"] = ""
        result["hba_detail"] = get_hba_detail(context)
        return result
    except Exception:
        logger.error("parse error: %s" % str(traceback.format_exc()))
        return get_empty_overview_result(context)


def get_hba_detail(context):
    """
    获取hba_detail
    :param context: 上下文
    :return: 获取hba_detail
    """
    hba_detail = []
    context["command"] = "esxcli storage core adapter list"
    core_adapter_list = get_return_from_txt(context)
    table_data = parse_table_type_result(core_adapter_list)
    start_bid = "Adapter:"
    keys_tuple = ('Adapter', 'Port Name', 'Speed', 'Port Type')
    delimiter = ":"
    context["command"] = "esxcli storage san fc list"
    san_fc_list = get_return_from_txt(context)
    fc_infos = get_key_values_from_content_lines(san_fc_list, start_bid, keys_tuple, delimiter)
    # 进行处理
    for info in fc_infos:
        hba_detail.append(build_single_hba_info(info, table_data))
    context["command"] = "esxcli storage san fcoe list"
    san_fcoe_list = get_return_from_txt(context)
    fcoe_infos = get_key_values_from_content_lines(san_fcoe_list, start_bid, keys_tuple, delimiter)
    # 进行处理
    for info in fcoe_infos:
        hba_detail.append(build_single_hba_info(info, table_data))

    context["command"] = "esxcli storage san iscsi list"
    san_iscsi_list = get_return_from_txt(context)
    iscsi_keys_tuple = ('Adapter', 'UID')
    iscsi_infos = get_key_values_from_content_lines(san_iscsi_list, start_bid, iscsi_keys_tuple, delimiter)
    for info in iscsi_infos:
        single_hba_detail = ["ID=" + info['UID'], "Vendor=" + "", "Type=" + "", "Speed=" + "", "Location=" + ""]
        hba_detail.append(";".join(single_hba_detail).strip())
    return "\n".join(hba_detail).strip()


def build_single_hba_info(info, table_data):
    single_hba_detail = []
    key = info['Adapter']
    for data in table_data:
        if key == data['HBA Name']:
            description = data.get("Description", "")
            single_hba_detail.append("ID=" + info['Port Name'])
            single_hba_detail.append("Vendor=" + get_vendor_from_desc(description))
            single_hba_detail.append("Type=" + info['Port Type'])
            single_hba_detail.append("Speed=" + get_speed_from_desc(description, info))
            single_hba_detail.append("Location=")
            break
    return ";".join(single_hba_detail).strip()


def get_vendor_from_desc(description):
    items = description.split()
    return items[1] if len(items) > 1 else ""


def get_speed_from_desc(description, info):
    speed = info['Speed']
    if speed:
        return speed
    speeds = [item for item in description.split() if item.endswith('Gb')]
    return speeds[0] if speeds else ''


def get_disk_use(context):
    """
    获取 磁盘绑定形式
    :param context: 上下文
    :return:磁盘绑定形式
    """
    disk_use = []
    vm_flag, vm_multi = get_vm_nmp_multi(context)
    ultra_flag, ultra_multi = get_vm_ultra_multi(context)
    other_flag, other_multis = get_vm_other_multis(context)
    if vm_flag:
        get_disk_uses(disk_use, vm_multi)
    if ultra_flag:
        get_disk_uses(disk_use, ultra_multi)
    if other_flag:
        for one_multi in other_multis:
            get_disk_uses(disk_use, one_multi)
    return ", ".join(disk_use)


def get_disk_uses(disk_use, multi):
    """
    获取disk_uses
    :param disk_use: 磁盘绑定方式
    :param multi: 多路径
    :return: 磁盘绑定方式
    """
    disk_list = multi.get("disk_list", [])
    for disk in disk_list:
        # DataStore
        if disk.get("datastore_name", "") \
                and disk.get("datastore_name", "") != "NA" \
                and disk.get("datastore_type", "") != "RDM":
            if "DataStore" not in disk_use:
                disk_use.append("DataStore")
        # RDM
        elif disk.get("datastore_type", "") == "RDM":
            if "RDM" not in disk_use:
                disk_use.append("RDM")
    return disk_use


def get_os_version(context):
    """
    获取类型+版本
    :param context:上下文
    :return: 类型+版本
    """
    os_type, os_version = get_type_version(context)
    return os_type + " " + os_version


def get_hba_wwn_list_type(context):
    """
    获取hba_wwn、type
    :param context: 上下文
    :return: hba_wwn
    """
    context["command"] = "esxcli storage core adapter list"
    hba_info = get_return_from_txt(context)
    hba_list = []
    hba_type = ""
    for line in hba_info:
        fc_str = get_split_item(line.split(), 3)
        if fc_str.strip().startswith("fc.") and ":" in fc_str:
            hba_list.append(fc_str.split(":")[-1])
            if not hba_type:
                hba_type = line.split("  ")[-1]
    return "\n".join(hba_list), hba_type


def get_multi_type_version(context):
    """
    获取多路径的类型、版本
    :param context: 上下文
    :return: 类型、版本
    """
    context["command"] = "esxcli upadm show version"
    ultra_multi = get_return_from_txt(context)
    for line in ultra_multi:
        if "software version" in line.lower():
            return "UltraPath", line.split(":")[1].strip()

    other_flag, other_multis = get_vm_other_multis(context)
    if other_flag:
        for multi in other_multis:
            if multi.get("multipath_type", ""):
                return multi.get("multipath_type", ""), "NA"

    lun_list = get_vm_lun_list(context)
    multi_lun_list = get_nmp_lun_list(lun_list, "NMP")
    if multi_lun_list:
        return "NMP", "NA"
    return "", ""
