# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
import sys
import os
import json
import traceback

reload(sys)
sys.setdefaultencoding('utf-8')
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..\\..")
sys.path.append(path)
from hosts.common.migra_summary_util import get_vm_host_info
from hosts.common.migra_summary_util import get_empty_vm_host


def execute(context):
    result = get_result(context)
    ret_map = context.get("map")
    ret_map.put("data", json.dumps(result))
    return context


def get_result(context):
    """
    获取数据
    :param context: 上下文
    :return: 数据
    """
    logger = context.get("Logger")
    result = {}
    result["host_ip"] = context.get("ip")
    try:
        vm_list = get_vm_host_info(context)
    except Exception:
        logger.error("parse error: %s" % str(traceback.format_exc()))
        vm_list = get_empty_vm_host()
    result["vm_list"] = vm_list
    return result
